"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const path = require("path");
const lambda = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-layer-version-1');
// Just for the example - granting to the current account is not necessary.
const awsAccountId = stack.accountId;
/// !show
const layer = new lambda.LayerVersion(stack, 'MyLayer', {
    code: lambda.Code.directory(path.join(__dirname, 'layer-code')),
    compatibleRuntimes: [lambda.Runtime.NodeJS810],
    license: 'Apache-2.0',
    description: 'A layer to test the L2 construct',
});
// To grant usage by other AWS accounts
layer.grantUsage('remote-account-grant', { accountId: awsAccountId });
// To grant usage to all accounts in some AWS Ogranization
// layer.grantUsage({ accountId: '*', organizationId });
new lambda.Function(stack, 'MyLayeredLambda', {
    code: new lambda.InlineCode('foo'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NodeJS810,
    layers: [layer],
});
/// !hide
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubGF5ZXItdmVyc2lvbi5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5sYXllci12ZXJzaW9uLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLG9DQUFxQztBQUNyQyw2QkFBOEI7QUFDOUIsaUNBQWtDO0FBRWxDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUseUJBQXlCLENBQUMsQ0FBQztBQUU1RCwyRUFBMkU7QUFDM0UsTUFBTSxZQUFZLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztBQUVyQyxTQUFTO0FBQ1QsTUFBTSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUU7SUFDdEQsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFlBQVksQ0FBQyxDQUFDO0lBQy9ELGtCQUFrQixFQUFFLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUM7SUFDOUMsT0FBTyxFQUFFLFlBQVk7SUFDckIsV0FBVyxFQUFFLGtDQUFrQztDQUNoRCxDQUFDLENBQUM7QUFFSCx1Q0FBdUM7QUFDdkMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsRUFBRSxFQUFFLFNBQVMsRUFBRSxZQUFZLEVBQUUsQ0FBQyxDQUFDO0FBRXRFLDBEQUEwRDtBQUMxRCx3REFBd0Q7QUFFeEQsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUM1QyxJQUFJLEVBQUUsSUFBSSxNQUFNLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztJQUNsQyxPQUFPLEVBQUUsZUFBZTtJQUN4QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxTQUFTO0lBQ2pDLE1BQU0sRUFBRSxDQUFDLEtBQUssQ0FBQztDQUNoQixDQUFDLENBQUM7QUFDSCxTQUFTO0FBRVQsR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGNkayA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2NkaycpO1xuaW1wb3J0IHBhdGggPSByZXF1aXJlKCdwYXRoJyk7XG5pbXBvcnQgbGFtYmRhID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdhd3MtY2RrLWxheWVyLXZlcnNpb24tMScpO1xuXG4vLyBKdXN0IGZvciB0aGUgZXhhbXBsZSAtIGdyYW50aW5nIHRvIHRoZSBjdXJyZW50IGFjY291bnQgaXMgbm90IG5lY2Vzc2FyeS5cbmNvbnN0IGF3c0FjY291bnRJZCA9IHN0YWNrLmFjY291bnRJZDtcblxuLy8vICFzaG93XG5jb25zdCBsYXllciA9IG5ldyBsYW1iZGEuTGF5ZXJWZXJzaW9uKHN0YWNrLCAnTXlMYXllcicsIHtcbiAgY29kZTogbGFtYmRhLkNvZGUuZGlyZWN0b3J5KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYXllci1jb2RlJykpLFxuICBjb21wYXRpYmxlUnVudGltZXM6IFtsYW1iZGEuUnVudGltZS5Ob2RlSlM4MTBdLFxuICBsaWNlbnNlOiAnQXBhY2hlLTIuMCcsXG4gIGRlc2NyaXB0aW9uOiAnQSBsYXllciB0byB0ZXN0IHRoZSBMMiBjb25zdHJ1Y3QnLFxufSk7XG5cbi8vIFRvIGdyYW50IHVzYWdlIGJ5IG90aGVyIEFXUyBhY2NvdW50c1xubGF5ZXIuZ3JhbnRVc2FnZSgncmVtb3RlLWFjY291bnQtZ3JhbnQnLCB7IGFjY291bnRJZDogYXdzQWNjb3VudElkIH0pO1xuXG4vLyBUbyBncmFudCB1c2FnZSB0byBhbGwgYWNjb3VudHMgaW4gc29tZSBBV1MgT2dyYW5pemF0aW9uXG4vLyBsYXllci5ncmFudFVzYWdlKHsgYWNjb3VudElkOiAnKicsIG9yZ2FuaXphdGlvbklkIH0pO1xuXG5uZXcgbGFtYmRhLkZ1bmN0aW9uKHN0YWNrLCAnTXlMYXllcmVkTGFtYmRhJywge1xuICBjb2RlOiBuZXcgbGFtYmRhLklubGluZUNvZGUoJ2ZvbycpLFxuICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLk5vZGVKUzgxMCxcbiAgbGF5ZXJzOiBbbGF5ZXJdLFxufSk7XG4vLy8gIWhpZGVcblxuYXBwLnJ1bigpO1xuIl19