"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const lambda = require("../lib");
module.exports = {
    'can add same singleton Lambda multiple times, only instantiated once in template'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        for (let i = 0; i < 5; i++) {
            new lambda.SingletonFunction(stack, `Singleton${i}`, {
                uuid: '84c0de93-353f-4217-9b0b-45b6c993251a',
                code: new lambda.InlineCode('def hello(): pass'),
                runtime: lambda.Runtime.Python27,
                handler: 'index.hello',
                timeout: 300,
            });
        }
        // THEN
        assert_1.expect(stack).to(assert_1.matchTemplate({
            Resources: {
                SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235: {
                    Type: "AWS::IAM::Role",
                    Properties: {
                        AssumeRolePolicyDocument: {
                            Statement: [
                                {
                                    Action: "sts:AssumeRole",
                                    Effect: "Allow",
                                    Principal: { Service: { "Fn::Join": ["", ["lambda.", { Ref: "AWS::URLSuffix" }]] } }
                                }
                            ],
                            Version: "2012-10-17"
                        },
                        ManagedPolicyArns: [
                            {
                                "Fn::Join": ["", ["arn:", { Ref: "AWS::Partition" }, ":iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"]]
                            }
                        ]
                    }
                },
                SingletonLambda84c0de93353f42179b0b45b6c993251a840BCC38: {
                    Type: "AWS::Lambda::Function",
                    Properties: {
                        Code: {
                            ZipFile: "def hello(): pass"
                        },
                        Handler: "index.hello",
                        Role: { "Fn::GetAtt": ["SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235", "Arn"] },
                        Runtime: "python2.7",
                        Timeout: 300
                    },
                    DependsOn: ["SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235"]
                }
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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