"use strict";
const assert_1 = require("@aws-cdk/assert");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/cdk");
const lambda = require("../lib");
module.exports = {
    'lambda can be used as metric subscription destination'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const fn = new lambda.Function(stack, 'MyLambda', {
            code: new lambda.InlineCode('foo'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NodeJS610,
        });
        const logGroup = new logs.LogGroup(stack, 'LogGroup');
        // WHEN
        new logs.SubscriptionFilter(stack, 'Subscription', {
            logGroup,
            destination: fn,
            filterPattern: logs.FilterPattern.allEvents()
        });
        // THEN: subscription target is Lambda
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::SubscriptionFilter', {
            DestinationArn: { "Fn::GetAtt": ["MyLambdaCCE802FB", "Arn"] },
        }));
        // THEN: Lambda has permissions to be invoked by CWL
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Lambda::Permission', {
            Action: "lambda:InvokeFunction",
            FunctionName: {
                "Fn::GetAtt": [
                    "MyLambdaCCE802FB",
                    "Arn"
                ]
            },
            Principal: { "Fn::Join": ["", ["logs.", { Ref: "AWS::Region" }, ".amazonaws.com"]] }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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