/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.core.util.converter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.objectweb.proactive.core.util.converter.MakeDeepCopy;
import org.objectweb.proactive.core.util.converter.SunMarshalInputStream;

public class ByteToObjectConverter {
    private static Object convert(InputStream is, MakeDeepCopy.ConversionMode conversionMode, ClassLoader cl) throws IOException, ClassNotFoundException {
        return ByteToObjectConverter.standardConvert(is, conversionMode, cl);
    }

    private static Object readFromStream(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        return objectInputStream.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object standardConvert(InputStream is, MakeDeepCopy.ConversionMode conversionMode, ClassLoader cl) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            if (conversionMode == MakeDeepCopy.ConversionMode.MARSHALL) {
                objectInputStream = new SunMarshalInputStream(is);
            } else {
                if (conversionMode == MakeDeepCopy.ConversionMode.PAOBJECT) {
                    throw new UnsupportedOperationException((Object)((Object)MakeDeepCopy.ConversionMode.PAOBJECT) + " is not supported");
                }
                objectInputStream = cl != null ? new ObjectInputStreamWithClassLoader(is, cl) : new ObjectInputStream(is);
            }
            Object object = ByteToObjectConverter.readFromStream(objectInputStream);
            return object;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            is.close();
        }
    }

    private static class ObjectInputStreamWithClassLoader
    extends ObjectInputStream {
        private ClassLoader cl;

        public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.cl = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            if (this.cl == null) {
                return super.resolveClass(v);
            }
            return Class.forName(v.getName(), true, this.cl);
        }
    }

    public static class ObjectStream {
        public static Object convert(byte[] byteArray) throws IOException, ClassNotFoundException {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            return ObjectStream.convert(bais, null);
        }

        public static Object convert(InputStream is) throws IOException, ClassNotFoundException {
            return ObjectStream.convert(is, null);
        }

        public static Object convert(byte[] byteArray, ClassLoader cl) throws IOException, ClassNotFoundException {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            return ObjectStream.convert(bais, cl);
        }

        public static Object convert(InputStream is, ClassLoader cl) throws IOException, ClassNotFoundException {
            return ByteToObjectConverter.convert(is, MakeDeepCopy.ConversionMode.OBJECT, cl);
        }
    }

    public static class MarshallStream {
        public static Object convert(byte[] byteArray) throws IOException, ClassNotFoundException {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            return MarshallStream.convert(bais);
        }

        public static Object convert(InputStream is) throws IOException, ClassNotFoundException {
            return ByteToObjectConverter.convert(is, MakeDeepCopy.ConversionMode.MARSHALL, null);
        }
    }
}

