/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final String namePrefix;
    private final boolean isDaemon;
    private final int priority;
    private final ThreadCustomizer customizer;

    public NamedThreadFactory(String poolName) {
        this(poolName, false);
    }

    public NamedThreadFactory(String poolName, boolean isDaemon) {
        this(poolName, isDaemon, 5, null);
    }

    public NamedThreadFactory(String poolName, boolean isDaemon, int priority) {
        this(poolName, isDaemon, priority, null);
    }

    public NamedThreadFactory(String poolName, boolean isDaemon, int priority, ThreadCustomizer customizer) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = poolName + " #" + poolNumber.getAndIncrement() + "-thread-";
        this.isDaemon = isDaemon;
        this.priority = priority;
        this.customizer = customizer;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.isDaemon);
        t.setPriority(this.priority);
        if (this.customizer != null) {
            this.customizer.customize(t);
        }
        return t;
    }

    public static interface ThreadCustomizer {
        public void customize(Thread var1);
    }
}

