/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.AbstractVfsContainer;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;

public abstract class AbstractFileProvider
extends AbstractVfsContainer
implements FileProvider {
    private final ConcurrentMap<FileSystemKey, FileSystem> fileSystems = new ConcurrentHashMap<FileSystemKey, FileSystem>();
    private FileNameParser parser = GenericFileNameParser.getInstance();

    protected FileNameParser getFileNameParser() {
        return this.parser;
    }

    protected void setFileNameParser(FileNameParser parser) {
        this.parser = parser;
    }

    @Override
    public void close() {
        this.fileSystems.clear();
        super.close();
    }

    @Override
    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions properties) throws FileSystemException {
        throw new FileSystemException("vfs.provider/not-layered-fs.error", (Object)scheme);
    }

    protected void addFileSystem(Comparable<?> key, FileSystem fs) throws FileSystemException {
        this.addComponent(fs);
        FileSystemKey treeKey = new FileSystemKey(key, fs.getFileSystemOptions());
        ((AbstractFileSystem)fs).setCacheKey(treeKey);
        this.fileSystems.put(treeKey, fs);
    }

    protected FileSystem findFileSystem(Comparable<?> key, FileSystemOptions fileSystemProps) {
        FileSystemKey treeKey = new FileSystemKey(key, fileSystemProps);
        return (FileSystem)this.fileSystems.get(treeKey);
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    public void freeUnusedResources() {
        LinkedList<AbstractFileSystem> copy = new LinkedList<AbstractFileSystem>();
        for (FileSystem fileSystem : this.fileSystems.values()) {
            try {
                copy.add((AbstractFileSystem)fileSystem);
            }
            catch (ClassCastException classCastException) {}
        }
        for (AbstractFileSystem abstractFileSystem : copy) {
            if (!abstractFileSystem.isReleaseable()) continue;
            abstractFileSystem.closeCommunicationLink();
        }
    }

    public void closeFileSystem(FileSystem filesystem) {
        AbstractFileSystem fs = (AbstractFileSystem)filesystem;
        if (fs.getCacheKey() != null) {
            this.fileSystems.remove(fs.getCacheKey());
        }
        this.removeComponent(fs);
        fs.close();
    }

    @Override
    public FileName parseUri(FileName base, String uri) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), base, uri);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }
}

