/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.ow2.proactive.http.CommonHttpClientBuilder;
import org.ow2.proactive.utils.FileUtils;

public class CommonHttpResourceDownloader {
    private static final Logger logger = Logger.getLogger(CommonHttpResourceDownloader.class);
    private static final Integer CONNECTION_POOL_SIZE = 5;
    private static final String CONTENT_DISPOSITIOB_REGEXP = "(?i)^.*filename=\"([^\"]+)\".*$";
    private static CommonHttpResourceDownloader instance = null;
    private CloseableHttpClient client;

    public static CommonHttpResourceDownloader getInstance() {
        if (instance == null) {
            instance = new CommonHttpResourceDownloader();
        }
        return instance;
    }

    private CommonHttpResourceDownloader() {
    }

    public String getResource(String sessionId, String url, boolean insecure) throws IOException {
        CommonHttpClientBuilder builder = new CommonHttpClientBuilder().maxConnections(CONNECTION_POOL_SIZE).useSystemProperties().insecure(insecure);
        try (CloseableHttpClient client = builder.build();){
            CloseableHttpResponse response = this.createAndExecuteRequest(sessionId, url, client);
            String string = this.readContent(response.getEntity().getContent());
            return string;
        }
    }

    public UrlContent getResourceContent(String sessionId, String url, boolean insecure) throws IOException {
        CommonHttpClientBuilder builder = new CommonHttpClientBuilder().maxConnections(CONNECTION_POOL_SIZE).useSystemProperties().insecure(insecure);
        try (CloseableHttpClient client = builder.build();){
            CloseableHttpResponse response = this.createAndExecuteRequest(sessionId, url, client);
            Header contentDispositionHeader = response.getFirstHeader("Content-Disposition");
            String filename = contentDispositionHeader != null && contentDispositionHeader.getValue().matches(CONTENT_DISPOSITIOB_REGEXP) ? contentDispositionHeader.getValue().replaceFirst(CONTENT_DISPOSITIOB_REGEXP, "$1") : FileUtils.getFileNameWithExtension(new URL(url));
            UrlContent urlContent = new UrlContent(this.readContent(response.getEntity().getContent()), filename);
            return urlContent;
        }
    }

    private CloseableHttpResponse createAndExecuteRequest(String sessionId, String url, CloseableHttpClient client) throws IOException {
        CloseableHttpResponse response;
        StatusLine status;
        HttpGet request = new HttpGet(url);
        if (sessionId != null) {
            request.setHeader("sessionid", sessionId);
        }
        if ((status = (response = client.execute((HttpUriRequest)request)).getStatusLine()).getStatusCode() != 200) {
            throw new IOException(String.format("Cannot access resource %s: code %d", url, status.getStatusCode()));
        }
        return response;
    }

    private String readContent(InputStream input) throws IOException {
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(input));){
            String tmp;
            StringBuilder builder = new StringBuilder();
            while ((tmp = buf.readLine()) != null) {
                builder.append(tmp).append("\n");
            }
            String string = builder.toString();
            return string;
        }
    }

    public static class UrlContent {
        private final String content;
        private final String fileName;

        public UrlContent(String content, String fileName) {
            this.content = content;
            this.fileName = fileName;
        }

        public String getContent() {
            return this.content;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

