/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.CollectionUtils;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.task.CommonAttribute;
import org.ow2.proactive.scheduler.common.task.ForkEnvironment;
import org.ow2.proactive.scheduler.common.task.JavaTask;
import org.ow2.proactive.scheduler.common.task.NativeTask;
import org.ow2.proactive.scheduler.common.task.ParallelEnvironment;
import org.ow2.proactive.scheduler.common.task.ScriptTask;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.UpdatableProperties;
import org.ow2.proactive.scheduler.common.task.dataspaces.InputSelector;
import org.ow2.proactive.scheduler.common.task.dataspaces.OutputSelector;
import org.ow2.proactive.scheduler.common.task.flow.FlowScript;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SelectionScript;
import org.ow2.proactive.topology.descriptor.ThresholdProximityDescriptor;
import org.ow2.proactive.topology.descriptor.TopologyDescriptor;

public class JobComparator {
    private Stack<String> stack;

    public String getDifferenceMessage() {
        return this.stack.toString();
    }

    public boolean isEqualJob(TaskFlowJob job1, TaskFlowJob job2) throws IOException, ClassNotFoundException {
        this.stack = new Stack();
        this.stack.push("job");
        this.stack.push("Job attributes");
        if (!this.isEqualCommonAttribute(job1, job2)) {
            return false;
        }
        this.stack.pop();
        if (!this.isEqualString(job1.getProjectName(), job2.getProjectName(), false)) {
            this.stack.push("ProjectName");
            return false;
        }
        if (!job1.getPriority().equals(job2.getPriority())) {
            this.stack.push("Priority");
            return false;
        }
        if (!job1.getName().equals(job2.getName())) {
            this.stack.push("Name");
            return false;
        }
        if (!this.isEqualString(job1.getDescription(), job2.getDescription())) {
            this.stack.push("Description");
            return false;
        }
        if (!this.isEqualString(job1.getInputSpace(), job2.getInputSpace())) {
            this.stack.push("Input Space");
            return false;
        }
        if (!this.isEqualString(job1.getOutputSpace(), job2.getOutputSpace())) {
            this.stack.push("Output Space");
            return false;
        }
        this.stack.push("stackflow");
        if (!this.isTaskFlowEqual(job1, job2)) {
            return false;
        }
        this.stack.pop();
        return true;
    }

    private boolean isEqualCommonAttribute(CommonAttribute attrib1, CommonAttribute attrib2) {
        if (!JobComparator.isEqualUpdatableProperty(attrib1.getOnTaskErrorProperty(), attrib2.getOnTaskErrorProperty())) {
            this.stack.push(" CancelJobOnErrorProperty ");
            return false;
        }
        if (!JobComparator.isEqualUpdatableProperty(attrib1.getMaxNumberOfExecutionProperty(), attrib2.getMaxNumberOfExecutionProperty())) {
            this.stack.push(" maxNumberOfExecution ");
            return false;
        }
        if (!JobComparator.isEqualUpdatableProperty(attrib1.getRestartTaskOnErrorProperty(), attrib2.getRestartTaskOnErrorProperty())) {
            this.stack.push(" RestartTaskOnError ");
            return false;
        }
        this.stack.push(" genericInformation ");
        if (!this.isEqualMap(attrib1.getGenericInformation(), attrib2.getGenericInformation())) {
            this.stack.push("generic info 1= " + attrib1.getGenericInformation() + " ----- generic info 2 = " + attrib2.getGenericInformation());
            return false;
        }
        this.stack.pop();
        return true;
    }

    private boolean isTaskFlowEqual(TaskFlowJob job1, TaskFlowJob job2) throws IOException, ClassNotFoundException {
        ArrayList<Task> tasks1 = job1.getTasks();
        ArrayList<Task> tasks2 = job2.getTasks();
        if (tasks1.size() != tasks2.size()) {
            this.stack.push("Sizes don't match");
            return false;
        }
        HashMap<String, Task> map1 = new HashMap<String, Task>();
        HashMap<String, Task> map2 = new HashMap<String, Task>();
        for (int k = 0; k < tasks1.size(); ++k) {
            map1.put(tasks1.get(k).getName(), tasks1.get(k));
            map2.put(tasks2.get(k).getName(), tasks2.get(k));
        }
        for (String name : map1.keySet()) {
            this.stack.push("Task " + map1.get(name));
            if (!this.isTaskEqual((Task)map1.get(name), (Task)map2.get(name))) {
                return false;
            }
            this.stack.pop();
        }
        return true;
    }

    private boolean isTaskEqual(Task t1, Task t2) throws IOException, ClassNotFoundException {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 == null ^ t2 == null) {
            this.stack.push("One of 2 tasks is null");
            return false;
        }
        if (!this.isEqualCommonAttribute(t1, t2)) {
            return false;
        }
        if (!t1.getName().equals(t2.getName())) {
            this.stack.push("name");
            return false;
        }
        if (!this.isEqualString(t1.getDescription(), t2.getDescription())) {
            this.stack.push("description");
            return false;
        }
        if (t1.getWallTime() != t2.getWallTime()) {
            this.stack.push("walltime");
            return false;
        }
        this.stack.push("task dependenices");
        List<Task> dep1 = t1.getDependencesList();
        List<Task> dep2 = t2.getDependencesList();
        if (dep1 == null ^ dep2 == null) {
            this.stack.push("one dependency list is empty");
            return false;
        }
        if (dep1 != null) {
            if (dep1.size() != dep2.size()) {
                this.stack.push("sizes don't match");
                return false;
            }
            int dep1Size = dep1.size();
            HashSet<String> names1 = new HashSet<String>(dep1Size);
            HashSet<String> names2 = new HashSet<String>(dep1Size);
            for (int k = 0; k < dep1Size; ++k) {
                names1.add(dep1.get(k).getName());
                names2.add(dep2.get(k).getName());
            }
            if (!CollectionUtils.isEqualCollection(names1, names2)) {
                return false;
            }
        }
        this.stack.pop();
        this.stack.push("parallel environment");
        if (!this.isEqualParallelEnvironment(t1.getParallelEnvironment(), t2.getParallelEnvironment())) {
            return false;
        }
        this.stack.pop();
        this.stack.push("input files");
        if (!this.isEqualInputFiles(t1.getInputFilesList(), t2.getInputFilesList())) {
            return false;
        }
        this.stack.pop();
        this.stack.push("output files");
        if (!this.isEqualOutputFiles(t1.getOutputFilesList(), t2.getOutputFilesList())) {
            return false;
        }
        this.stack.pop();
        this.stack.push("pre script");
        if (!this.isEqualScript(t1.getPreScript(), t2.getPreScript())) {
            return false;
        }
        this.stack.pop();
        this.stack.push("post script");
        if (!this.isEqualScript(t1.getPostScript(), t2.getPostScript())) {
            return false;
        }
        this.stack.pop();
        this.stack.push("cleaning script");
        if (!this.isEqualScript(t1.getCleaningScript(), t2.getCleaningScript())) {
            return false;
        }
        this.stack.pop();
        this.stack.push("selection scripts");
        List<SelectionScript> ss1 = t1.getSelectionScripts();
        List<SelectionScript> ss2 = t2.getSelectionScripts();
        if (ss1 == null ^ ss2 == null) {
            this.stack.push("One of two lists of selection scripts is null");
            return false;
        }
        if (ss1 != null) {
            if (t1.getSelectionScripts().size() != t2.getSelectionScripts().size()) {
                this.stack.push("lists size don't match");
                return false;
            }
            for (int k = 0; k < t1.getSelectionScripts().size(); ++k) {
                if (this.isEqualScript((Script)t1.getSelectionScripts().get(k), (Script)t2.getSelectionScripts().get(k))) continue;
                return false;
            }
        }
        this.stack.pop();
        if (t1.getFlowBlock() != t2.getFlowBlock()) {
            this.stack.push("flow block");
            return false;
        }
        this.stack.push("flow control");
        if (!this.isEqualFlowControl(t1.getFlowScript(), t2.getFlowScript())) {
            return false;
        }
        this.stack.pop();
        if (!this.isEqualClass(t1.getClass(), t2.getClass())) {
            this.stack.push("Executable types don't match");
            return false;
        }
        if (t1 instanceof JavaTask) {
            JavaTask jt1 = (JavaTask)t1;
            JavaTask jt2 = (JavaTask)t2;
            this.stack.push("arguments");
            if (!this.isEqualMap(jt1.getArguments(), jt2.getArguments())) {
                return false;
            }
            this.stack.pop();
            this.stack.push("executable class");
            if (!this.isEqualString(jt1.getExecutableClassName(), jt2.getExecutableClassName())) {
                return false;
            }
            this.stack.pop();
            this.stack.push("forked environemnt");
            if (!this.isEqualForkedEnvironment(jt1.getForkEnvironment(), jt2.getForkEnvironment())) {
                return false;
            }
            this.stack.pop();
        }
        if (t1 instanceof NativeTask) {
            String[] cl2;
            NativeTask nt1 = (NativeTask)t1;
            NativeTask nt2 = (NativeTask)t2;
            String[] cl1 = nt1.getCommandLine();
            if (cl1 == null ^ (cl2 = nt2.getCommandLine()) == null) {
                return false;
            }
            if (cl1 != null && !CollectionUtils.isEqualCollection(Arrays.asList(cl1), Arrays.asList(cl2))) {
                return false;
            }
        }
        if (t1 instanceof ScriptTask) {
            ScriptTask st1 = (ScriptTask)t1;
            ScriptTask st2 = (ScriptTask)t2;
            if (!this.isEqualScript((Script<?>)st1.getScript(), (Script<?>)st2.getScript())) {
                return false;
            }
        }
        return true;
    }

    private boolean isEqualForkedEnvironment(ForkEnvironment fe1, ForkEnvironment fe2) {
        if (fe1 == null && fe2 == null) {
            return true;
        }
        if (fe1 == null ^ fe2 == null) {
            this.stack.push("One null value out of 2");
            return false;
        }
        if (!CollectionUtils.isEqualCollection(fe1.getAdditionalClasspath(), fe2.getAdditionalClasspath())) {
            this.stack.push("AdditionalClasspath");
            return false;
        }
        if (!this.isEqualScript(fe1.getEnvScript(), fe2.getEnvScript())) {
            this.stack.push("EnvScript");
            return false;
        }
        if (!this.isEqualString(fe1.getJavaHome(), fe2.getJavaHome())) {
            this.stack.push("JavaHome");
            return false;
        }
        if (!CollectionUtils.isEqualCollection(fe1.getJVMArguments(), fe2.getJVMArguments())) {
            this.stack.push("JVMArguments");
            return false;
        }
        if (!this.isEqualMap(fe1.getSystemEnvironment(), fe2.getSystemEnvironment())) {
            this.stack.push("SystemEnvironment");
            return false;
        }
        if (!this.isEqualString(fe1.getWorkingDir(), fe2.getWorkingDir())) {
            this.stack.push("WorkingDir");
            return false;
        }
        return true;
    }

    private boolean isEqualFlowControl(FlowScript fs1, FlowScript fs2) {
        if (fs1 == null && fs2 == null) {
            return true;
        }
        if (fs1 == null || fs2 == null) {
            return false;
        }
        if (!this.isEqualString(fs1.getActionContinuation(), fs2.getActionContinuation())) {
            return false;
        }
        if (!this.isEqualString(fs1.getActionTarget(), fs2.getActionTarget())) {
            return false;
        }
        if (!this.isEqualString(fs1.getActionTargetElse(), fs2.getActionTargetElse())) {
            return false;
        }
        if (!this.isEqualString(fs1.getActionType(), fs2.getActionType())) {
            return false;
        }
        if (!this.isEqualString(fs1.getEngineName(), fs2.getEngineName())) {
            return false;
        }
        return this.isEqualScript(fs1, fs2);
    }

    private boolean isEqualString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null ^ s2 == null) {
            this.stack.push("One of 2 values is null " + s1 + "!=" + s2);
            return false;
        }
        if (!s1.equals(s2)) {
            this.stack.push(s1 + "!= " + s2);
            return false;
        }
        return true;
    }

    private boolean isEqualString(String s1, String s2, boolean caseSensitive) {
        if (s1 == null || s2 == null) {
            return this.isEqualString(s1, s2);
        }
        if (caseSensitive) {
            return this.isEqualString(s1, s2);
        }
        return this.isEqualString(s1.toLowerCase(), s2.toLowerCase());
    }

    private boolean isEqualScript(Script<?> s1, Script<?> s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null ^ s2 == null) {
            this.stack.push("One of 2 scripts is null");
            return false;
        }
        if (s1.getScriptUrl() == null ^ s2.getScriptUrl() == null) {
            this.stack.push("One of 2 scripts urls is null and the other is not");
            return false;
        }
        if (s1.getScriptUrl() != null && s2.getScriptUrl() != null && s1.getScriptUrl() != s2.getScriptUrl()) {
            this.stack.push("The script urls are different");
            return false;
        }
        if (s1.getScriptUrl() != null && s2.getScriptUrl() != null) {
            return true;
        }
        if (!s1.getEngineName().equals(s2.getEngineName())) {
            this.stack.push("engine names are different");
            return false;
        }
        String text1 = "";
        if (s1.getParameters() != null) {
            text1 = Arrays.toString(s1.getParameters());
        }
        String text2 = "";
        if (s2.getParameters() != null) {
            text2 = Arrays.toString(s2.getParameters());
        }
        return text1.equals(text2);
    }

    private boolean isEqualInputFiles(List<InputSelector> l1, List<InputSelector> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null ^ l2 == null) {
            this.stack.push("One of 2 values is null");
            return false;
        }
        if (l1.size() != l2.size()) {
            this.stack.push("sizes don't match");
            return false;
        }
        for (InputSelector is1 : l1) {
            boolean found = false;
            for (int i = 0; i < l2.size(); ++i) {
                Set e2;
                Set e1;
                Set i2;
                Set i1;
                InputSelector is2 = l2.get(i);
                if (!is1.getMode().equals((Object)is2.getMode()) || !(i1 = is1.getInputFiles().getIncludes()).equals(i2 = is2.getInputFiles().getIncludes()) || !(e1 = is1.getInputFiles().getExcludes()).equals(e2 = is2.getInputFiles().getExcludes())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualOutputFiles(List<OutputSelector> l1, List<OutputSelector> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null ^ l2 == null) {
            this.stack.push("One of 2 values is null");
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (OutputSelector os1 : l1) {
            boolean found = false;
            for (int i = 0; i < l2.size(); ++i) {
                Set e2;
                Set e1;
                Set i2;
                Set i1;
                OutputSelector os2 = l2.get(i);
                if (!os1.getMode().equals((Object)os2.getMode()) || !(i1 = os1.getOutputFiles().getIncludes()).equals(i2 = os2.getOutputFiles().getIncludes()) || !(e1 = os1.getOutputFiles().getExcludes()).equals(e2 = os2.getOutputFiles().getExcludes())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualParallelEnvironment(ParallelEnvironment e1, ParallelEnvironment e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null ^ e2 == null) {
            this.stack.push("One value out of 2 is null");
            return false;
        }
        if (e1.getNodesNumber() != e2.getNodesNumber()) {
            this.stack.push("nodes number");
            return false;
        }
        TopologyDescriptor topologyDescriptor1 = e1.getTopologyDescriptor();
        TopologyDescriptor topologyDescriptor2 = e2.getTopologyDescriptor();
        if (topologyDescriptor1 == null && topologyDescriptor2 == null) {
            return true;
        }
        if (topologyDescriptor1 == null ^ topologyDescriptor2 == null) {
            return this.isEqualClass(TopologyDescriptor.ARBITRARY.getClass(), topologyDescriptor1 == null ? topologyDescriptor2.getClass() : topologyDescriptor1.getClass());
        }
        if (!this.isEqualClass(topologyDescriptor1.getClass(), topologyDescriptor2.getClass())) {
            this.stack.push("topology descriptor type");
            return false;
        }
        if (topologyDescriptor1 instanceof ThresholdProximityDescriptor) {
            if (!(topologyDescriptor2 instanceof ThresholdProximityDescriptor)) {
                this.stack.push("Only one is ThresholdProximityDescriptor type.");
                return false;
            }
            if (((ThresholdProximityDescriptor)topologyDescriptor1).getThreshold() != ((ThresholdProximityDescriptor)topologyDescriptor2).getThreshold()) {
                this.stack.push("ThresholdProximityDescriptor.threshold");
                return false;
            }
        }
        return true;
    }

    private boolean isEqualMap(Map<?, ?> m1, Map<?, ?> m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.equals(m2);
    }

    private static <T> boolean isEqualUpdatableProperty(UpdatableProperties<T> property1, UpdatableProperties<T> property2) {
        return property1.isSet() ^ property2.isSet() ? false : (property1.isSet() ? property1.getValue().equals(property2.getValue()) : true);
    }

    private boolean isEqualClass(Class<?> clazz1, Class<?> clazz2) {
        return clazz1.getName().equals(clazz2.getName());
    }
}

