/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.ow2.proactive.scheduler.common.util.Object2ByteConverter;

public class AllObjects2BytesConverterHandler {
    private static final Logger logger = Logger.getLogger(AllObjects2BytesConverterHandler.class);
    private static final String TIMEOUT_JAVA_PROPERTY = "pa.max.deserialization.seconds";
    private static final Long secondsToWait = Long.getLong("pa.max.deserialization.seconds", 30L);
    private static final String ERROR_MESSAGE = " was stuck for more than " + secondsToWait + " seconds. Killing the Java process.(You can control this timeout  with the java property -D" + "pa.max.deserialization.seconds" + "= when starting nodes and/or when starting the scheduler )";

    private AllObjects2BytesConverterHandler() {
    }

    public static Map<String, Serializable> convertAllBytes2Objects(Map<String, byte[]> target, ClassLoader cl) {
        return AllObjects2BytesConverterHandler.convert("Deserialization of variables", AllObjects2BytesConverterHandler.createDeserializeCollable(target, cl));
    }

    public static Map<String, byte[]> convertAllObjects2Bytes(Map<String, Serializable> variableMap) {
        return AllObjects2BytesConverterHandler.convert("Serialization of variables", AllObjects2BytesConverterHandler.createSerializableCallable(variableMap));
    }

    public static byte[] convertObject2Byte(String key, Serializable value) {
        return AllObjects2BytesConverterHandler.convertSingle("Serialization of single value", AllObjects2BytesConverterHandler.createSerializeSingleValueCollable(key, value));
    }

    public static Serializable convertByte2Object(byte[] value) {
        return AllObjects2BytesConverterHandler.convertSingle("Deserialization of single value", AllObjects2BytesConverterHandler.createDeserializeSingleValueCollable(value));
    }

    private static <K, V> Map<K, V> convert(String action, Callable<Map<K, V>> callable) {
        Map resultMap = new HashMap();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Map<K, V>> future = executor.submit(callable);
        try {
            resultMap = future.get(secondsToWait, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            logger.fatal((Object)(action + ERROR_MESSAGE));
            System.exit(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdownNow();
        }
        return resultMap;
    }

    private static <V> V convertSingle(String action, Callable<V> callable) {
        V result = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<V> future = executor.submit(callable);
        try {
            result = future.get(secondsToWait, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            logger.fatal((Object)(action + ERROR_MESSAGE));
            System.exit(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdownNow();
        }
        return result;
    }

    private static Callable<Map<String, byte[]>> createSerializableCallable(final Map<String, Serializable> variableMap) {
        return new Callable<Map<String, byte[]>>(){

            @Override
            public Map<String, byte[]> call() throws ClassNotFoundException, IOException {
                HashMap<String, byte[]> serializedMap = new HashMap<String, byte[]>();
                for (String key : variableMap.keySet()) {
                    Serializable value = (Serializable)variableMap.get(key);
                    byte[] serialized = AllObjects2BytesConverterHandler.serialiseValue(key, value);
                    serializedMap.put(key, serialized);
                }
                return serializedMap;
            }
        };
    }

    private static Callable<Map<String, Serializable>> createDeserializeCollable(final Map<String, byte[]> target, final ClassLoader cl) {
        return new Callable<Map<String, Serializable>>(){

            @Override
            public Map<String, Serializable> call() throws ClassNotFoundException, IOException {
                HashMap<String, Serializable> deserializedMap = new HashMap<String, Serializable>(target.size());
                for (Map.Entry e : target.entrySet()) {
                    deserializedMap.put((String)e.getKey(), (Serializable)Object2ByteConverter.convertByte2Object((byte[])e.getValue(), cl));
                }
                return deserializedMap;
            }
        };
    }

    private static Callable<byte[]> createSerializeSingleValueCollable(final String key, final Serializable value) {
        return new Callable<byte[]>(){

            @Override
            public byte[] call() throws ClassNotFoundException, IOException {
                return AllObjects2BytesConverterHandler.serialiseValue(key, value);
            }
        };
    }

    private static Callable<Serializable> createDeserializeSingleValueCollable(final byte[] value) {
        return new Callable<Serializable>(){

            @Override
            public Serializable call() throws ClassNotFoundException, IOException {
                return (Serializable)Object2ByteConverter.convertByte2Object(value);
            }
        };
    }

    private static byte[] serialiseValue(String key, Serializable value) {
        if (key != null && key.length() > 255) {
            throw new IllegalArgumentException("Key is too long, it must have 255 chars length max : " + key);
        }
        try {
            return Object2ByteConverter.convertObject2Byte(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot add argument " + key, e);
        }
    }
}

