/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.result.Result;
import com.datapps.linkoopdb.jdbc.result.ResultLob;
import com.datapps.linkoopdb.jdbc.types.ClobData;
import com.datapps.linkoopdb.jdbc.types.ClobInputStream;
import com.datapps.linkoopdb.jdbc.types.LobLocation;
import java.io.Reader;

public class ClobDataID
implements ClobData {
    long id;
    long length = -1L;
    LobLocation lobLocation;

    public ClobDataID(long id) {
        this.id = id;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }

    @Override
    public char[] getChars(SessionInterface session, long position, int length) {
        ResultLob resultOut = ResultLob.newLobGetCharsRequest(this, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getCharArray();
    }

    @Override
    public long length(SessionInterface session) {
        if (this.length > -1L) {
            return this.length / 2L;
        }
        ResultLob resultOut = ResultLob.newLobGetLengthRequest(this.id, this.lobLocation);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
        return this.length / 2L;
    }

    @Override
    public String getSubString(SessionInterface session, long pos, int length) {
        if (this.lobLocation == null) {
            long clobLength = this.length(session);
            if (pos >= clobLength) {
                return "";
            }
            if (pos + (long)length >= clobLength) {
                length = (int)(clobLength - pos);
            }
        }
        char[] chars = this.getChars(session, pos, length);
        return new String(chars);
    }

    @Override
    public ClobData duplicate(SessionInterface session) {
        ResultLob resultOut = ResultLob.newLobDuplicateRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new ClobDataID(lobID);
    }

    @Override
    public ClobData getClob(SessionInterface session, long position, long length) {
        ResultLob resultOut = ResultLob.newLobGetRequest(this.id, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new ClobDataID(lobID);
    }

    @Override
    public void truncate(SessionInterface session, long len) {
        if (len >= this.length(session)) {
            return;
        }
        ResultLob resultOut = ResultLob.newLobTruncateRequest(this, len);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface session) {
        long length = this.length(session);
        return new ClobInputStream(session, this, 0L, length);
    }

    @Override
    public void setCharacterStream(SessionInterface session, long pos, Reader in) {
    }

    @Override
    public void setString(SessionInterface session, long pos, String str) {
        ResultLob resultOut = ResultLob.newLobSetCharsRequest(this, pos, str.toCharArray());
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public void setClob(SessionInterface session, long pos, ClobData clob, long offset, long len) {
    }

    @Override
    public void setChars(SessionInterface session, long pos, char[] chars, int offset, int len) {
        ResultLob resultOut;
        Result resultIn;
        if (offset != 0 || len != chars.length) {
            if (!ClobDataID.isInLimits(chars.length, offset, len)) {
                throw Error.error(3401);
            }
            if (offset != 0 || len != chars.length) {
                char[] newChars = new char[len];
                System.arraycopy(chars, offset, newChars, 0, len);
                chars = newChars;
            }
        }
        if ((resultIn = session.execute(resultOut = ResultLob.newLobSetCharsRequest(this, pos, chars))).isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public long position(SessionInterface session, String searchstr, long start) {
        ResultLob resultOut = ResultLob.newLobGetCharPatternPositionRequest(this.id, searchstr.toCharArray(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long position(SessionInterface session, ClobData searchstr, long start) {
        ResultLob resultOut = ResultLob.newLobGetCharPatternPositionRequest(this.id, searchstr.getId(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long nonSpaceLength(SessionInterface session) {
        ResultLob resultOut = ResultLob.newLobGetTruncateLength(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface session, long pos, long length) {
        return new ClobInputStream(session, this, pos, length);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setSession(SessionInterface session) {
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public LobLocation getLobLocation() {
        return this.lobLocation;
    }

    @Override
    public void setLobLocation(LobLocation lobLocation) {
        this.lobLocation = lobLocation;
    }

    public boolean equals(Object other) {
        if (other instanceof ClobDataID) {
            return this.id == ((ClobDataID)other).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

