import { PolicyDocument } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/cdk';
import { IBucket } from './bucket';
export interface BucketPolicyProps {
    /**
     * The Amazon S3 bucket that the policy applies to.
     */
    readonly bucket: IBucket;
}
/**
 * Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
 */
export declare class BucketPolicy extends Construct {
    /**
     * A policy document containing permissions to add to the specified bucket.
     * For more information, see Access Policy Language Overview in the Amazon
     * Simple Storage Service Developer Guide.
     */
    readonly document: PolicyDocument;
    constructor(scope: Construct, id: string, props: BucketPolicyProps);
}
