from .base import SolverBase
from .heat_diffusion import SolverHeatDiffusion
from .models import SolverModels
from .utils import SolverUtils

from am.units import MMGS


class Solver(SolverBase, SolverHeatDiffusion, SolverModels, SolverUtils):
    def __init__(
        self,
        model: str,
        name: str = None,
        filename=None,
        build_config_file: str = "default.ini",
        material_config_file: str = "SS316L.ini",
        mesh_config_file: str = "scale_millimeter.ini",
        device: str = "cpu",
        units=MMGS,
        verbose: bool = False,
        **kwargs,
    ):
        """
        @param model: Solver model (i.e. "eagar-tsai", "rosenthal", "surrogate-ss316")
        @param name: Name for solver model instance.
        @param filename: File friendly name for solver model instance (autogenerated).
        @param build_config_file: File for default build parameter values
        @param material_config_file: File for default material parameter values
        @param mesh_config_file: File for default mesh configuration values,
        @param device: pytorch device input field (i.e. "cpu", "cuda" 1 GPU max)
        @param units: MMGS
        @param verbose: For debugging
        """
        super().__init__(
            model=model,
            name=name,
            filename=filename,
            build_config_file=build_config_file,
            material_config_file=material_config_file,
            mesh_config_file=mesh_config_file,
            device=device,
            units=units,
            verbose=verbose,
            **kwargs,
        )
