"""AlertsHistory Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.alerts_history.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.alerts_history import AlertsHistoryService

log = logging.getLogger(__name__)


class TaegisSDKAlertsHistoryQuery:
    """Taegis Alerts_history Query operations."""

    def __init__(self, service: AlertsHistoryService):
        self.service = service

    def alert_history_by_id(self, id_: str) -> List[AlertChangeRecord]:
        """Returns all recorded versions of the alert with the given ID, sorted by modification date."""
        endpoint = "alertHistoryByID"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(AlertChangeRecord),
        )
        if result.get(endpoint) is not None:
            return AlertChangeRecord.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query alertHistoryByID")
