"""AlertsHistory Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class AlertOperationType(str, Enum):
    """AlertOperationType."""

    UNKNOWN = "UNKNOWN"
    CREATE = "CREATE"
    UPDATE = "UPDATE"
    DELETE = "DELETE"
    RESOLVE = "RESOLVE"
    INVESTIGATE = "INVESTIGATE"


class Origin(str, Enum):
    """Origin."""

    INTERNAL = "INTERNAL"
    CUSTOMER = "CUSTOMER"
    EXTERNAL = "EXTERNAL"
    PARTNER = "PARTNER"


class Visibility(str, Enum):
    """Visibility."""

    DEPLOYED = "DEPLOYED"
    RESEARCH = "RESEARCH"


class ResolutionStatus(str, Enum):
    """ResolutionStatus."""

    OPEN = "OPEN"
    TRUE_POSITIVE_BENIGN = "TRUE_POSITIVE_BENIGN"
    TRUE_POSITIVE_MALICIOUS = "TRUE_POSITIVE_MALICIOUS"
    FALSE_POSITIVE = "FALSE_POSITIVE"
    NOT_ACTIONABLE = "NOT_ACTIONABLE"
    OTHER = "OTHER"
    SUPPRESSED = "SUPPRESSED"


class ImprobableLogonDetail_FeatureName(str, Enum):
    """ImprobableLogonDetail_FeatureName."""

    UNKNOWN = "UNKNOWN"
    COUNTRY = "COUNTRY"
    CITY = "CITY"
    ASN = "ASN"


class EntityPerspective(str, Enum):
    """EntityPerspective."""

    UNKNOWN = "UNKNOWN"
    SOURCE = "SOURCE"
    TARGET = "TARGET"
    BOUNDARY = "BOUNDARY"
    BOTH = "BOTH"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeographicIp:
    """GeographicIp."""

    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address")
    )
    latitude: Optional[float] = field(
        default=None, metadata=config(field_name="latitude")
    )
    longitude: Optional[float] = field(
        default=None, metadata=config(field_name="longitude")
    )
    radius: Optional[float] = field(default=None, metadata=config(field_name="radius"))
    geohash: Optional[str] = field(default=None, metadata=config(field_name="geohash"))
    country_code_iso: Optional[str] = field(
        default=None, metadata=config(field_name="country_code_iso")
    )
    asn: Optional[int] = field(default=None, metadata=config(field_name="asn"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails_Commandline:
    """HandsOnKeyboardDetails_Commandline."""

    commandline: Optional[str] = field(
        default=None, metadata=config(field_name="commandline")
    )
    matched_features: Optional[List[str]] = field(
        default=None, metadata=config(field_name="matched_features")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails_Image:
    """HandsOnKeyboardDetails_Image."""

    image_path: Optional[str] = field(
        default=None, metadata=config(field_name="image_path")
    )
    matched_features: Optional[List[str]] = field(
        default=None, metadata=config(field_name="matched_features")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LogonAnomaly:
    """LogonAnomaly."""

    feature_value: Optional[str] = field(
        default=None, metadata=config(field_name="feature_value")
    )
    feature_frequency_in_org: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_org")
    )
    feature_frequency_in_user: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_user")
    )
    approximate_count_in_user: Optional[int] = field(
        default=None, metadata=config(field_name="approximate_count_in_user")
    )
    min_allowed_user_percentage: Optional[float] = field(
        default=None, metadata=config(field_name="min_allowed_user_percentage")
    )
    min_allowed_org_percentage: Optional[float] = field(
        default=None, metadata=config(field_name="min_allowed_org_percentage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UserLogonBaseline:
    """UserLogonBaseline."""

    feature_value: Optional[str] = field(
        default=None, metadata=config(field_name="feature_value")
    )
    feature_frequency_in_org: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_org")
    )
    feature_frequency_in_user: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_user")
    )
    approximate_count_in_user: Optional[int] = field(
        default=None, metadata=config(field_name="approximate_count_in_user")
    )
    days_in_baseline: Optional[int] = field(
        default=None, metadata=config(field_name="days_in_baseline")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Kerberoasting:
    """Kerberoasting."""

    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    user_baseline: Optional[int] = field(
        default=None, metadata=config(field_name="user_baseline")
    )
    user_avg_requests: Optional[float] = field(
        default=None, metadata=config(field_name="user_avg_requests")
    )
    user_max_requests: Optional[int] = field(
        default=None, metadata=config(field_name="user_max_requests")
    )
    total_spns: Optional[int] = field(
        default=None, metadata=config(field_name="total_spns")
    )
    suspicious_num_requests: Optional[int] = field(
        default=None, metadata=config(field_name="suspicious_num_requests")
    )
    percentage_accessed: Optional[float] = field(
        default=None, metadata=config(field_name="percentage_accessed")
    )
    spns_accessed: Optional[List[str]] = field(
        default=None, metadata=config(field_name="spns_accessed")
    )
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LoginFailureDetail:
    """LoginFailureDetail."""

    host: Optional[str] = field(default=None, metadata=config(field_name="host"))
    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    target_address: Optional[str] = field(
        default=None, metadata=config(field_name="target_address")
    )
    successful_auth_event: Optional[str] = field(
        default=None, metadata=config(field_name="successful_auth_event")
    )
    failed_auth_event: Optional[str] = field(
        default=None, metadata=config(field_name="failed_auth_event")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class WhoisSimple:
    """WhoisSimple."""

    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="domainName")
    )
    registrar_name: Optional[str] = field(
        default=None, metadata=config(field_name="registrarName")
    )
    contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="contactEmail")
    )
    whois_server: Optional[str] = field(
        default=None, metadata=config(field_name="whoisServer")
    )
    name_servers: Optional[str] = field(
        default=None, metadata=config(field_name="nameServers")
    )
    created_date: Optional[str] = field(
        default=None, metadata=config(field_name="createdDate")
    )
    updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="updatedDate")
    )
    expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="expiresDate")
    )
    standard_reg_created_date: Optional[str] = field(
        default=None, metadata=config(field_name="standardRegCreatedDate")
    )
    standard_reg_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="standardRegUpdatedDate")
    )
    standard_reg_expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="standardRegExpiresDate")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    audit_audit_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="Audit_auditUpdatedDate")
    )
    registrant_email: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_email")
    )
    registrant_name: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_name")
    )
    registrant_organization: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_organization")
    )
    registrant_street1: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street1")
    )
    registrant_street2: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street2")
    )
    registrant_street3: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street3")
    )
    registrant_street4: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street4")
    )
    registrant_city: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_city")
    )
    registrant_state: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_state")
    )
    registrant_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_postalCode")
    )
    registrant_country: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_country")
    )
    registrant_fax: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_fax")
    )
    registrant_fax_ext: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_faxExt")
    )
    registrant_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_telephone")
    )
    registrant_telephone_ext: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_telephoneExt")
    )
    administrative_contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_email")
    )
    administrative_contact_name: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_name")
    )
    administrative_contact_organization: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_organization")
    )
    administrative_contact_street1: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street1")
    )
    administrative_contact_street2: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street2")
    )
    administrative_contact_street3: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street3")
    )
    administrative_contact_street4: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street4")
    )
    administrative_contact_city: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_city")
    )
    administrative_contact_state: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_state")
    )
    administrative_contact_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_postalCode")
    )
    administrative_contact_country: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_country")
    )
    administrative_contact_fax: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_fax")
    )
    administrative_contact_fax_ext: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_faxExt")
    )
    administrative_contact_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_telephone")
    )
    administrative_contact_telephone_ext: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_telephoneExt")
    )
    reg_created_date_usec: Optional[int] = field(
        default=None, metadata=config(field_name="reg_created_date_usec")
    )
    reg_updated_date_usec: Optional[int] = field(
        default=None, metadata=config(field_name="reg_updated_date_usec")
    )
    reg_expires_date_usec: Optional[int] = field(
        default=None, metadata=config(field_name="reg_expires_date_usec")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DnsExfilEnrichment:
    """DnsExfilEnrichment."""

    num_queries: Optional[int] = field(
        default=None, metadata=config(field_name="num_queries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DDosIpAddressOccurrenceCount:
    """DDosIpAddressOccurrenceCount."""

    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NetworkConnection:
    """NetworkConnection."""

    source_ip: Optional[str] = field(
        default=None, metadata=config(field_name="source_ip")
    )
    destination_ip: Optional[str] = field(
        default=None, metadata=config(field_name="destination_ip")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MitreAttackDetails:
    """MitreAttackDetails."""

    technique_id: Optional[str] = field(
        default=None, metadata=config(field_name="technique_id")
    )
    technique: Optional[str] = field(
        default=None, metadata=config(field_name="technique")
    )
    tactics: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tactics")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    platform: Optional[List[str]] = field(
        default=None, metadata=config(field_name="platform")
    )
    system_requirements: Optional[List[str]] = field(
        default=None, metadata=config(field_name="system_requirements")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))
    data_sources: Optional[List[str]] = field(
        default=None, metadata=config(field_name="data_sources")
    )
    defence_bypassed: Optional[List[str]] = field(
        default=None, metadata=config(field_name="defence_bypassed")
    )
    contributors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="contributors")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MatchDetails:
    """MatchDetails."""

    list_name: Optional[str] = field(
        default=None, metadata=config(field_name="list_name")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    attacks: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attacks")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BruteForceAuth:
    """BruteForceAuth."""

    win_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="win_event_id")
    )
    action: Optional[str] = field(default=None, metadata=config(field_name="action"))
    domain: Optional[str] = field(default=None, metadata=config(field_name="domain"))
    target_username: Optional[str] = field(
        default=None, metadata=config(field_name="target_username")
    )
    event_timestamp: Optional[int] = field(
        default=None, metadata=config(field_name="event_timestamp")
    )
    resource_record_identifier: Optional[str] = field(
        default=None, metadata=config(field_name="resource_record_identifier")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PasswordSprayAffectedUser:
    """PasswordSprayAffectedUser."""

    target_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_user_name")
    )
    target_domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_domain_name")
    )
    user_had_auth_success: Optional[bool] = field(
        default=None, metadata=config(field_name="user_had_auth_success")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuthScanLogonAttempt:
    """AuthScanLogonAttempt."""

    target_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_user_name")
    )
    has_logon_success: Optional[bool] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "see list in successful_logon_attempts",
            },
            field_name="has_logon_success",
        ),
    )
    num_attempts: Optional[int] = field(
        default=None, metadata=config(field_name="num_attempts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AccountCompromiseDetectorDetail:
    """AccountCompromiseDetectorDetail."""

    user_name: Optional[str] = field(
        default=None, metadata=config(field_name="user_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_ASN:
    """GeoSummary_ASN."""

    autonomous_system_no: Optional[int] = field(
        default=None, metadata=config(field_name="autonomous_system_no")
    )
    autonomous_system_org: Optional[str] = field(
        default=None, metadata=config(field_name="autonomous_system_org")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_Continent:
    """GeoSummary_Continent."""

    geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="geoname_id")
    )
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_Country:
    """GeoSummary_Country."""

    geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="geoname_id")
    )
    iso_code: Optional[str] = field(
        default=None, metadata=config(field_name="iso_code")
    )
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_Location:
    """GeoSummary_Location."""

    radius: Optional[int] = field(default=None, metadata=config(field_name="radius"))
    latitude: Optional[float] = field(
        default=None, metadata=config(field_name="latitude")
    )
    longitude: Optional[float] = field(
        default=None, metadata=config(field_name="longitude")
    )
    us_metro_code: Optional[int] = field(
        default=None, metadata=config(field_name="us_metro_code")
    )
    timezone: Optional[str] = field(
        default=None, metadata=config(field_name="timezone")
    )
    gmt_offset: Optional[int] = field(
        default=None, metadata=config(field_name="gmt_offset")
    )
    metro_code: Optional[int] = field(
        default=None, metadata=config(field_name="metro_code")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KeyAndValues:
    """KeyAndValues."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    values: Optional[List[str]] = field(
        default=None, metadata=config(field_name="values")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KeyValueRecordIndexed:
    """KeyValueRecordIndexed."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantV4:
    """TenantV4."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuxiliaryEvent:
    """AuxiliaryEvent."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Observation:
    """Observation."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Investigation:
    """Investigation."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Collection:
    """Collection."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityAuthDomainSnapshot:
    """EntityAuthDomainSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    auth_domain: Optional[str] = field(
        default=None, metadata=config(field_name="auth_domain")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityCertificateSnapshot:
    """EntityCertificateSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    cert_issuer: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer")
    )
    cert_serial_number: Optional[str] = field(
        default=None, metadata=config(field_name="cert_serial_number")
    )
    cert_issuer_c: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_c")
    )
    cert_issuer_cn: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_cn")
    )
    cert_issuer_e: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_e")
    )
    cert_issuer_l: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_l")
    )
    cert_issuer_o: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_o")
    )
    cert_issuer_order: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_order")
    )
    cert_issuer_ou: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_ou")
    )
    cert_issuer_s: Optional[str] = field(
        default=None, metadata=config(field_name="cert_issuer_s")
    )
    cert_ja3: Optional[str] = field(
        default=None, metadata=config(field_name="cert_ja3")
    )
    cert_ja3s: Optional[str] = field(
        default=None, metadata=config(field_name="cert_ja3s")
    )
    cert_subject: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject")
    )
    cert_subject_c: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_c")
    )
    cert_subject_cn: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_cn")
    )
    cert_subject_e: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_e")
    )
    cert_subject_l: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_l")
    )
    cert_subject_o: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_o")
    )
    cert_subject_order: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_order")
    )
    cert_subject_ou: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_ou")
    )
    cert_subject_s: Optional[str] = field(
        default=None, metadata=config(field_name="cert_subject_s")
    )
    cert_valid_from: Optional[str] = field(
        default=None, metadata=config(field_name="cert_valid_from")
    )
    cert_valid_through: Optional[str] = field(
        default=None, metadata=config(field_name="cert_valid_through")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityCloudObjectSnapshot:
    """EntityCloudObjectSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    cloud_object_bucket: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_object_bucket")
    )
    cloud_object_key: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_object_key")
    )
    cloud_object_prefix: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_object_prefix")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityCloudResourceSnapshot:
    """EntityCloudResourceSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    cloud_resource_account_id: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_resource_account_id")
    )
    cloud_resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_resource_id")
    )
    cloud_resource_type: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_resource_type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityCloudUserSnapshot:
    """EntityCloudUserSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    cloud_user_id: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_user_id")
    )
    cloud_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_user_name")
    )
    cloud_user_type: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_user_type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityDnsServerSnapshot:
    """EntityDnsServerSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address")
    )
    ip_address_type: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address_type")
    )
    ip_classification: Optional[str] = field(
        default=None, metadata=config(field_name="ip_classification")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityDomainNameSnapshot:
    """EntityDomainNameSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="domain_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityEmailSnapshot:
    """EntityEmailSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    email_message_id: Optional[str] = field(
        default=None, metadata=config(field_name="email_message_id")
    )
    email_message_size: Optional[int] = field(
        default=None, metadata=config(field_name="email_message_size")
    )
    email_quarantine_reason: Optional[str] = field(
        default=None, metadata=config(field_name="email_quarantine_reason")
    )
    reply_to_email_address: Optional[str] = field(
        default=None, metadata=config(field_name="reply_to_email_address")
    )
    vendor_alert_url: Optional[str] = field(
        default=None, metadata=config(field_name="vendor_alert_url")
    )
    vendor_email_spam_score: Optional[int] = field(
        default=None, metadata=config(field_name="vendor_email_spam_score")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityEmailAddressSnapshot:
    """EntityEmailAddressSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    email_address: Optional[str] = field(
        default=None, metadata=config(field_name="email_address")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityFileSnapshot:
    """EntityFileSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    file_name: Optional[str] = field(
        default=None, metadata=config(field_name="file_name")
    )
    file_path: Optional[str] = field(
        default=None, metadata=config(field_name="file_path")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    email_attachment_sandbox_status: Optional[str] = field(
        default=None, metadata=config(field_name="email_attachment_sandbox_status")
    )
    file_create_time: Optional[int] = field(
        default=None, metadata=config(field_name="file_create_time")
    )
    file_group_owner: Optional[str] = field(
        default=None, metadata=config(field_name="file_group_owner")
    )
    file_modified_time: Optional[int] = field(
        default=None, metadata=config(field_name="file_modified_time")
    )
    file_owner: Optional[str] = field(
        default=None, metadata=config(field_name="file_owner")
    )
    file_size: Optional[int] = field(
        default=None, metadata=config(field_name="file_size")
    )
    file_type: Optional[str] = field(
        default=None, metadata=config(field_name="file_type")
    )
    file_type_detected: Optional[str] = field(
        default=None, metadata=config(field_name="file_type_detected")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityFileHashSnapshot:
    """EntityFileHashSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    hash_type: Optional[str] = field(
        default=None, metadata=config(field_name="hash_type")
    )
    hash_value: Optional[str] = field(
        default=None, metadata=config(field_name="hash_value")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityFunctionSnapshot:
    """EntityFunctionSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    function_name: Optional[str] = field(
        default=None, metadata=config(field_name="function_name")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityHostSnapshot:
    """EntityHostSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    computer_name: Optional[str] = field(
        default=None, metadata=config(field_name="computer_name")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    hostname_fqdn: Optional[str] = field(
        default=None, metadata=config(field_name="hostname_fqdn")
    )
    mac_address: Optional[str] = field(
        default=None, metadata=config(field_name="mac_address")
    )
    os: Optional[str] = field(default=None, metadata=config(field_name="os"))
    os_arch: Optional[str] = field(default=None, metadata=config(field_name="os_arch"))
    sensor_id: Optional[str] = field(
        default=None, metadata=config(field_name="sensor_id")
    )
    sensor_type: Optional[str] = field(
        default=None, metadata=config(field_name="sensor_type")
    )
    vendor_agent_device_id: Optional[str] = field(
        default=None, metadata=config(field_name="vendor_agent_device_id")
    )
    vendor_agent_device_score: Optional[int] = field(
        default=None, metadata=config(field_name="vendor_agent_device_score")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityIpAddressSnapshot:
    """EntityIpAddressSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address")
    )
    asn: Optional[int] = field(default=None, metadata=config(field_name="asn"))
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    ip_address_type: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address_type")
    )
    ip_classification: Optional[str] = field(
        default=None, metadata=config(field_name="ip_classification")
    )
    is_nat_ip: Optional[bool] = field(
        default=None, metadata=config(field_name="is_nat_ip")
    )
    ip_geo_auto_system_org: Optional[str] = field(
        default=None, metadata=config(field_name="ip_geo_auto_system_org")
    )
    ip_geo_city_name: Optional[str] = field(
        default=None, metadata=config(field_name="ip_geo_city_name")
    )
    ip_geo_continent_code: Optional[str] = field(
        default=None, metadata=config(field_name="ip_geo_continent_code")
    )
    ip_geo_country_code: Optional[str] = field(
        default=None, metadata=config(field_name="ip_geo_country_code")
    )
    ip_geo_country_geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="ip_geo_country_geoname_id")
    )
    ip_geo_latitude: Optional[float] = field(
        default=None, metadata=config(field_name="ip_geo_latitude")
    )
    ip_geo_longitude: Optional[float] = field(
        default=None, metadata=config(field_name="ip_geo_longitude")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityProcessSnapshot:
    """EntityProcessSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    process_correlation_id: Optional[str] = field(
        default=None, metadata=config(field_name="process_correlation_id")
    )
    process_id: Optional[str] = field(
        default=None, metadata=config(field_name="process_id")
    )
    process_name: Optional[str] = field(
        default=None, metadata=config(field_name="process_name")
    )
    process_uuid: Optional[str] = field(
        default=None, metadata=config(field_name="process_uuid")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    process_create_time: Optional[int] = field(
        default=None, metadata=config(field_name="process_create_time")
    )
    process_image_path: Optional[str] = field(
        default=None, metadata=config(field_name="process_image_path")
    )
    process_is_admin: Optional[bool] = field(
        default=None, metadata=config(field_name="process_is_admin")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityRegistryKeySnapshot:
    """EntityRegistryKeySnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    registry_path: Optional[str] = field(
        default=None, metadata=config(field_name="registry_path")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityScheduledTaskSnapshot:
    """EntityScheduledTaskSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    task_name: Optional[str] = field(
        default=None, metadata=config(field_name="task_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityScriptSnapshot:
    """EntityScriptSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    hash_value: Optional[str] = field(
        default=None, metadata=config(field_name="hash_value")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    script_name: Optional[str] = field(
        default=None, metadata=config(field_name="script_name")
    )
    interpreter: Optional[str] = field(
        default=None, metadata=config(field_name="interpreter")
    )
    is_truncated: Optional[bool] = field(
        default=None, metadata=config(field_name="is_truncated")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityServiceSnapshot:
    """EntityServiceSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    service_dll: Optional[str] = field(
        default=None, metadata=config(field_name="service_dll")
    )
    service_main: Optional[str] = field(
        default=None, metadata=config(field_name="service_main")
    )
    service_name: Optional[str] = field(
        default=None, metadata=config(field_name="service_name")
    )
    service_start_type: Optional[int] = field(
        default=None, metadata=config(field_name="service_start_type")
    )
    service_type: Optional[int] = field(
        default=None, metadata=config(field_name="service_type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityTaskActionSnapshot:
    """EntityTaskActionSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    task_action_id: Optional[str] = field(
        default=None, metadata=config(field_name="task_action_id")
    )
    task_action_path: Optional[str] = field(
        default=None, metadata=config(field_name="task_action_path")
    )
    task_action_args: Optional[str] = field(
        default=None, metadata=config(field_name="task_action_args")
    )
    task_action_class_id: Optional[str] = field(
        default=None, metadata=config(field_name="task_action_class_id")
    )
    task_action_type: Optional[str] = field(
        default=None, metadata=config(field_name="task_action_type")
    )
    task_action_working_directory: Optional[str] = field(
        default=None, metadata=config(field_name="task_action_working_directory")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityUserSnapshot:
    """EntityUserSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    auth_domain: Optional[str] = field(
        default=None, metadata=config(field_name="auth_domain")
    )
    computer_name: Optional[str] = field(
        default=None, metadata=config(field_name="computer_name")
    )
    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="domain_name")
    )
    group: Optional[str] = field(default=None, metadata=config(field_name="group"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    user_id: Optional[str] = field(default=None, metadata=config(field_name="user_id"))
    user_name: Optional[str] = field(
        default=None, metadata=config(field_name="user_name")
    )
    cloud_user_type: Optional[str] = field(
        default=None, metadata=config(field_name="cloud_user_type")
    )
    original_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="original_user_name")
    )
    user_is_admin: Optional[bool] = field(
        default=None, metadata=config(field_name="user_is_admin")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityUrlSnapshot:
    """EntityUrlSnapshot."""

    property_type: Optional[str] = field(
        default=None, metadata=config(field_name="property_type")
    )
    full_url: Optional[str] = field(
        default=None, metadata=config(field_name="full_url")
    )
    uri_scheme: Optional[str] = field(
        default=None, metadata=config(field_name="uri_scheme")
    )
    uri_host: Optional[str] = field(
        default=None, metadata=config(field_name="uri_host")
    )
    uri_path: Optional[str] = field(
        default=None, metadata=config(field_name="uri_path")
    )
    uri_query: Optional[str] = field(
        default=None, metadata=config(field_name="uri_query")
    )
    uri_fragment: Optional[str] = field(
        default=None, metadata=config(field_name="uri_fragment")
    )
    uri_port: Optional[str] = field(
        default=None, metadata=config(field_name="uri_port")
    )
    uri_userinfo: Optional[str] = field(
        default=None, metadata=config(field_name="uri_userinfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Timestamp:
    """Timestamp."""

    seconds: Optional[int] = field(default=None, metadata=config(field_name="seconds"))
    nanos: Optional[int] = field(default=None, metadata=config(field_name="nanos"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Detector:
    """Detector."""

    detector_id: Optional[str] = field(
        default=None, metadata=config(field_name="detector_id")
    )
    detector_name: Optional[str] = field(
        default=None, metadata=config(field_name="detector_name")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreationRule:
    """CreationRule."""

    rule_id: Optional[str] = field(default=None, metadata=config(field_name="rule_id"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Engine:
    """Engine."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertRuleReference:
    """AlertRuleReference."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Relationship:
    """Relationship."""

    from_entity: Optional[str] = field(
        default=None, metadata=config(field_name="from_entity")
    )
    to_entity: Optional[str] = field(
        default=None, metadata=config(field_name="to_entity")
    )
    relationship: Optional[str] = field(
        default=None, metadata=config(field_name="relationship")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityMetadata:
    """EntityMetadata."""

    entity: Optional[str] = field(default=None, metadata=config(field_name="entity"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Reference:
    """Reference."""

    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DDosIpCount:
    """DDosIpCount."""

    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    date: Optional[Timestamp] = field(default=None, metadata=config(field_name="date"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RareProgramRareIpDetail:
    """RareProgramRareIpDetail."""

    host: Optional[str] = field(default=None, metadata=config(field_name="host"))
    programs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="programs")
    )
    connections: Optional[List[NetworkConnection]] = field(
        default=None, metadata=config(field_name="connections")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class StolenCredsTrustFeatures:
    """StolenCredsTrustFeatures."""

    network_unknown_asn: Optional[bool] = field(
        default=None, metadata=config(field_name="network_unknown_asn")
    )
    network_unknown_ip: Optional[bool] = field(
        default=None, metadata=config(field_name="network_unknown_ip")
    )
    user_unknown_ip: Optional[bool] = field(
        default=None, metadata=config(field_name="user_unknown_ip")
    )
    user_unknown_asn: Optional[bool] = field(
        default=None, metadata=config(field_name="user_unknown_asn")
    )
    prior_event_time_sec: Optional[int] = field(
        default=None, metadata=config(field_name="prior_event_time_sec")
    )
    current_event_time_sec: Optional[int] = field(
        default=None, metadata=config(field_name="current_event_time_sec")
    )
    prior_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="prior_event_id")
    )
    current_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="current_event_id")
    )
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    location: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="location")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TacticGraphDetail:
    """TacticGraphDetail."""

    graph_id: Optional[str] = field(
        default=None, metadata=config(field_name="graph_id")
    )
    events: Optional[List[KeyAndValues]] = field(
        default=None, metadata=config(field_name="events")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class WatchlistMatches:
    """WatchlistMatches."""

    entity: Optional[str] = field(default=None, metadata=config(field_name="entity"))
    details: Optional[List[MatchDetails]] = field(
        default=None, metadata=config(field_name="details")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PasswordSprayDetail:
    """PasswordSprayDetail."""

    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    num_auth_failures: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_failures")
    )
    num_auth_successes: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_successes")
    )
    all_affected_users: Optional[List[PasswordSprayAffectedUser]] = field(
        default=None, metadata=config(field_name="all_affected_users")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MatchedYaraRule:
    """MatchedYaraRule."""

    rule_name: Optional[str] = field(
        default=None, metadata=config(field_name="rule_name")
    )
    rule_description: Optional[str] = field(
        default=None, metadata=config(field_name="rule_description")
    )
    classification: Optional[str] = field(
        default=None, metadata=config(field_name="classification")
    )
    confidence: Optional[float] = field(
        default=None, metadata=config(field_name="confidence")
    )
    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    attack_technique_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attack_technique_ids")
    )
    vid: Optional[str] = field(default=None, metadata=config(field_name="vid"))
    rule_created_date: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="rule_created_date")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KeyValuePairsIndexed:
    """KeyValuePairsIndexed."""

    record: Optional[List[KeyValueRecordIndexed]] = field(
        default=None, metadata=config(field_name="record")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SeverityUpdate:
    """SeverityUpdate."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    changed_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="changed_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityRelationships:
    """EntityRelationships."""

    entities: Optional[List[str]] = field(
        default=None, metadata=config(field_name="entities")
    )
    relationships: Optional[List[Relationship]] = field(
        default=None, metadata=config(field_name="relationships")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ReferenceDetail:
    """ReferenceDetail."""

    reference: Optional[Reference] = field(
        default=None, metadata=config(field_name="reference")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertPriority:
    """AlertPriority."""

    value: Optional[float] = field(default=None, metadata=config(field_name="value"))
    prioritizer: Optional[str] = field(
        default=None, metadata=config(field_name="prioritizer")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    model_name: Optional[str] = field(
        default=None, metadata=config(field_name="model_name")
    )
    model_version: Optional[str] = field(
        default=None, metadata=config(field_name="model_version")
    )
    evidence: Optional[List[str]] = field(
        default=None, metadata=config(field_name="evidence")
    )
    applied_time: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="applied_time")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails_MatchedProcess:
    """HandsOnKeyboardDetails_MatchedProcess."""

    process_resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="process_resource_id")
    )
    num_matched_features: Optional[int] = field(
        default=None, metadata=config(field_name="num_matched_features")
    )
    event_time_sec: Optional[int] = field(
        default=None, metadata=config(field_name="event_time_sec")
    )
    score: Optional[float] = field(default=None, metadata=config(field_name="score"))
    severity: Optional[str] = field(
        default=None, metadata=config(field_name="severity")
    )
    image: Optional[HandsOnKeyboardDetails_Image] = field(
        default=None, metadata=config(field_name="image")
    )
    commandline: Optional[HandsOnKeyboardDetails_Commandline] = field(
        default=None, metadata=config(field_name="commandline")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DDosSourceIpCountDetail:
    """DDosSourceIpCountDetail."""

    hour_partition: Optional[str] = field(
        default=None, metadata=config(field_name="hour_partition")
    )
    sensor_id: Optional[str] = field(
        default=None, metadata=config(field_name="sensor_id")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    event_observable_count: Optional[int] = field(
        default=None, metadata=config(field_name="event_observable_count")
    )
    event_observable_count_std_dev: Optional[float] = field(
        default=None, metadata=config(field_name="event_observable_count_std_dev")
    )
    baseline_observable_count_std_dev: Optional[float] = field(
        default=None, metadata=config(field_name="baseline_observable_count_std_dev")
    )
    baseline_observable_count_mean: Optional[float] = field(
        default=None, metadata=config(field_name="baseline_observable_count_mean")
    )
    baseline_observable_count_median: Optional[int] = field(
        default=None, metadata=config(field_name="baseline_observable_count_median")
    )
    baseline_num_days: Optional[int] = field(
        default=None, metadata=config(field_name="baseline_num_days")
    )
    analytic_observable_std_dev_threshold: Optional[float] = field(
        default=None,
        metadata=config(field_name="analytic_observable_std_dev_threshold"),
    )
    analytic_observable_min_count: Optional[int] = field(
        default=None, metadata=config(field_name="analytic_observable_min_count")
    )
    analytic_time_threshold: Optional[int] = field(
        default=None, metadata=config(field_name="analytic_time_threshold")
    )
    historical_ip_counts: Optional[List[DDosIpCount]] = field(
        default=None, metadata=config(field_name="historical_ip_counts")
    )
    top_destination_ips: Optional[List[DDosIpAddressOccurrenceCount]] = field(
        default=None, metadata=config(field_name="top_destination_ips")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class StolenCredsTravelFeatures:
    """StolenCredsTravelFeatures."""

    accurate_geo: Optional[bool] = field(
        default=None, metadata=config(field_name="accurate_geo")
    )
    foreign_travel: Optional[bool] = field(
        default=None, metadata=config(field_name="foreign_travel")
    )
    long_distance_travel: Optional[bool] = field(
        default=None, metadata=config(field_name="long_distance_travel")
    )
    travel_hours: Optional[float] = field(
        default=None, metadata=config(field_name="travel_hours")
    )
    travel_km_min: Optional[float] = field(
        default=None, metadata=config(field_name="travel_km_min")
    )
    travel_km_h_min: Optional[float] = field(
        default=None, metadata=config(field_name="travel_km_h_min")
    )
    travel_speed_impossible: Optional[bool] = field(
        default=None, metadata=config(field_name="travel_speed_impossible")
    )
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    current_location: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="current_location")
    )
    prior_location: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="prior_location")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BruteForceDetails:
    """BruteForceDetails."""

    num_auth_failures: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_failures")
    )
    num_auth_successes: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_successes")
    )
    last_successful_auth: Optional[BruteForceAuth] = field(
        default=None, metadata=config(field_name="last_successful_auth")
    )
    most_recent_auths_failures: Optional[List[BruteForceAuth]] = field(
        default=None, metadata=config(field_name="most_recent_auths_failures")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuthScanDetail:
    """AuthScanDetail."""

    total_attempts: Optional[int] = field(
        default=None, metadata=config(field_name="total_attempts")
    )
    successful_logon_attempts: Optional[List[AuthScanLogonAttempt]] = field(
        default=None, metadata=config(field_name="successful_logon_attempts")
    )
    failed_logon_attempts: Optional[List[AuthScanLogonAttempt]] = field(
        default=None, metadata=config(field_name="failed_logon_attempts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Creator:
    """Creator."""

    detector: Optional[Detector] = field(
        default=None, metadata=config(field_name="detector")
    )
    rule: Optional[CreationRule] = field(
        default=None, metadata=config(field_name="rule")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ResolutionMetadataHistory:
    """ResolutionMetadataHistory."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    user_id: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "moving to uuid user id",
            },
            field_name="user_id",
        ),
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    num_alerts_affected: Optional[int] = field(
        default=None, metadata=config(field_name="num_alerts_affected")
    )
    uuid_user_id: Optional[str] = field(
        default=None, metadata=config(field_name="uuid_user_id")
    )
    timestamp: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    status: Optional[Union[ResolutionStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ResolutionStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TuningUpdate:
    """TuningUpdate."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    field_name: Optional[str] = field(
        default=None, metadata=config(field_name="field_name")
    )
    severity_value: Optional[float] = field(
        default=None, metadata=config(field_name="severity_value")
    )
    suppressed_value: Optional[bool] = field(
        default=None, metadata=config(field_name="suppressed_value")
    )
    origin_value: Optional[Union[Origin, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(Origin, x),
            field_name="origin_value",
        ),
    )
    changed_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="changed_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ImprobableLogonDetail:
    """ImprobableLogonDetail."""

    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    feature_name: Optional[Union[ImprobableLogonDetail_FeatureName, TaegisEnum]] = (
        field(
            default=None,
            metadata=config(
                encoder=encode_enum,
                decoder=lambda x: decode_enum(ImprobableLogonDetail_FeatureName, x),
                field_name="feature_name",
            ),
        )
    )
    logon_anomaly: Optional[LogonAnomaly] = field(
        default=None, metadata=config(field_name="logon_anomaly")
    )
    user_logon_baselines: Optional[List[UserLogonBaseline]] = field(
        default=None, metadata=config(field_name="user_logon_baselines")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertEventMetadata:
    """AlertEventMetadata."""

    first_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="first_event_id")
    )
    last_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="last_event_id")
    )
    total_events: Optional[int] = field(
        default=None, metadata=config(field_name="total_events")
    )
    updated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    began_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="began_at")
    )
    ended_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="ended_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertSnapshotMetadata:
    """AlertSnapshotMetadata."""

    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    confidence: Optional[float] = field(
        default=None, metadata=config(field_name="confidence")
    )
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    full_title: Optional[str] = field(
        default=None, metadata=config(field_name="full_title")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    creator: Optional[Creator] = field(
        default=None, metadata=config(field_name="creator")
    )
    engine: Optional[Engine] = field(default=None, metadata=config(field_name="engine"))
    severity_updated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="severity_updated_at")
    )
    began_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="began_at")
    )
    ended_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="ended_at")
    )
    created_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="created_at")
    )
    inserted_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="inserted_at")
    )
    updated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    first_seen_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="first_seen_at")
    )
    first_investigated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="first_investigated_at")
    )
    first_resolved_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="first_resolved_at")
    )
    origin: Optional[Union[Origin, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(Origin, x),
            field_name="origin",
        ),
    )


PropertiesSnapshot = Union[
    EntityAuthDomainSnapshot,
    EntityCertificateSnapshot,
    EntityCloudObjectSnapshot,
    EntityCloudResourceSnapshot,
    EntityCloudUserSnapshot,
    EntityDnsServerSnapshot,
    EntityDomainNameSnapshot,
    EntityEmailSnapshot,
    EntityEmailAddressSnapshot,
    EntityFileSnapshot,
    EntityFileHashSnapshot,
    EntityFunctionSnapshot,
    EntityHostSnapshot,
    EntityIpAddressSnapshot,
    EntityProcessSnapshot,
    EntityRegistryKeySnapshot,
    EntityScheduledTaskSnapshot,
    EntityScriptSnapshot,
    EntityServiceSnapshot,
    EntityTaskActionSnapshot,
    EntityUserSnapshot,
    EntityUrlSnapshot,
]


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GenericDetail:
    """GenericDetail."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    generic: Optional[KeyValuePairsIndexed] = field(
        default=None, metadata=config(field_name="generic")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails:
    """HandsOnKeyboardDetails."""

    total_num_events: Optional[int] = field(
        default=None, metadata=config(field_name="total_num_events")
    )
    matched_num_events: Optional[int] = field(
        default=None, metadata=config(field_name="matched_num_events")
    )
    num_admin_events: Optional[int] = field(
        default=None, metadata=config(field_name="num_admin_events")
    )
    common_parent_image_path: Optional[str] = field(
        default=None, metadata=config(field_name="common_parent_image_path")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    matched_process: Optional[List[HandsOnKeyboardDetails_MatchedProcess]] = field(
        default=None, metadata=config(field_name="matched_process")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FileAnalysisDetail:
    """FileAnalysisDetail."""

    matched_yara_rule: Optional[List[MatchedYaraRule]] = field(
        default=None, metadata=config(field_name="matched_yara_rule")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_City:
    """GeoSummary_City."""

    geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="geoname_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    locale_names: Optional[KeyValuePairsIndexed] = field(
        default=None, metadata=config(field_name="locale_names")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThirdPartyDetail:
    """ThirdPartyDetail."""

    generic: Optional[GenericDetail] = field(
        default=None, metadata=config(field_name="generic")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class StructuredEntitySnapshot:
    """StructuredEntitySnapshot."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    identifiers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="identifiers")
    )
    perspective: Optional[Union[EntityPerspective, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityPerspective, x),
            field_name="perspective",
        ),
    )
    properties: Optional[PropertiesSnapshot] = field(
        default=None,
        metadata=config(
            decoder=lambda x: parse_union_result(PropertiesSnapshot, x),
            field_name="properties",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary:
    """GeoSummary."""

    location: Optional[GeoSummary_Location] = field(
        default=None, metadata=config(field_name="location")
    )
    city: Optional[GeoSummary_City] = field(
        default=None, metadata=config(field_name="city")
    )
    continent: Optional[GeoSummary_Continent] = field(
        default=None, metadata=config(field_name="continent")
    )
    country: Optional[GeoSummary_Country] = field(
        default=None, metadata=config(field_name="country")
    )
    asn: Optional[GeoSummary_ASN] = field(
        default=None, metadata=config(field_name="asn")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BusinessEmailCompromiseDetail:
    """BusinessEmailCompromiseDetail."""

    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    user_name: Optional[str] = field(
        default=None, metadata=config(field_name="user_name")
    )
    source_address_geo_summary: Optional[GeoSummary] = field(
        default=None, metadata=config(field_name="source_address_geo_summary")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EnrichmentDetail:
    """EnrichmentDetail."""

    geo_ip: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="geo_ip")
    )
    whois: Optional[WhoisSimple] = field(
        default=None, metadata=config(field_name="whois")
    )
    dns_exfil: Optional[DnsExfilEnrichment] = field(
        default=None, metadata=config(field_name="dns_exfil")
    )
    ddos_source_ip: Optional[DDosSourceIpCountDetail] = field(
        default=None, metadata=config(field_name="ddos_source_ip")
    )
    login_failure: Optional[LoginFailureDetail] = field(
        default=None, metadata=config(field_name="login_failure")
    )
    rare_program_rare_ip: Optional[RareProgramRareIpDetail] = field(
        default=None, metadata=config(field_name="rare_program_rare_ip")
    )
    travel_features: Optional[StolenCredsTravelFeatures] = field(
        default=None, metadata=config(field_name="travel_features")
    )
    trust_features: Optional[StolenCredsTrustFeatures] = field(
        default=None, metadata=config(field_name="trust_features")
    )
    tactic_graph_detail: Optional[TacticGraphDetail] = field(
        default=None, metadata=config(field_name="tactic_graph_detail")
    )
    mitre_attack_info: Optional[MitreAttackDetails] = field(
        default=None, metadata=config(field_name="mitre_attack_info")
    )
    watchlist_matches: Optional[WatchlistMatches] = field(
        default=None, metadata=config(field_name="watchlist_matches")
    )
    kerberoasting: Optional[Kerberoasting] = field(
        default=None, metadata=config(field_name="kerberoasting")
    )
    brute_force_detail: Optional[BruteForceDetails] = field(
        default=None, metadata=config(field_name="brute_force_detail")
    )
    password_spray_detail: Optional[PasswordSprayDetail] = field(
        default=None, metadata=config(field_name="password_spray_detail")
    )
    improbable_logon_detail: Optional[ImprobableLogonDetail] = field(
        default=None, metadata=config(field_name="improbable_logon_detail")
    )
    auth_scan_detail: Optional[AuthScanDetail] = field(
        default=None, metadata=config(field_name="auth_scan_detail")
    )
    hands_on_keyboard_details: Optional[HandsOnKeyboardDetails] = field(
        default=None, metadata=config(field_name="hands_on_keyboard_details")
    )
    business_email_compromise: Optional[BusinessEmailCompromiseDetail] = field(
        default=None, metadata=config(field_name="business_email_compromise")
    )
    account_compromise_detector_detail: Optional[AccountCompromiseDetectorDetail] = (
        field(
            default=None,
            metadata=config(field_name="account_compromise_detector_detail"),
        )
    )
    file_analysis_detail: Optional[FileAnalysisDetail] = field(
        default=None, metadata=config(field_name="file_analysis_detail")
    )
    generic: Optional[GenericDetail] = field(
        default=None, metadata=config(field_name="generic")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertSnapshot:
    """AlertSnapshot."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    group_key: Optional[List[str]] = field(
        default=None, metadata=config(field_name="group_key")
    )
    attack_technique_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attack_technique_ids")
    )
    tenant_id: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "being replaced with Tenant field",
            },
            field_name="tenant_id",
        ),
    )
    parent_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="parent_tenant_id")
    )
    suppressed: Optional[bool] = field(
        default=None, metadata=config(field_name="suppressed")
    )
    resolution_reason: Optional[str] = field(
        default=None, metadata=config(field_name="resolution_reason")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    sensor_types: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sensor_types")
    )
    threat_score: Optional[float] = field(
        default=None, metadata=config(field_name="threat_score")
    )
    threat_score_v2: Optional[float] = field(
        default=None, metadata=config(field_name="threat_score_v2")
    )
    observation: Optional[bool] = field(
        default=None, metadata=config(field_name="observation")
    )
    metadata: Optional[AlertSnapshotMetadata] = field(
        default=None, metadata=config(field_name="metadata")
    )
    visibility: Optional[Union[Visibility, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(Visibility, x),
            field_name="visibility",
        ),
    )
    tenant: Optional[TenantV4] = field(
        default=None, metadata=config(field_name="tenant")
    )
    suppression_rules: Optional[List[AlertRuleReference]] = field(
        default=None, metadata=config(field_name="suppression_rules")
    )
    alerting_rules: Optional[List[AlertRuleReference]] = field(
        default=None, metadata=config(field_name="alerting_rules")
    )
    status: Optional[Union[ResolutionStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ResolutionStatus, x),
            field_name="status",
        ),
    )
    resolution_history: Optional[List[ResolutionMetadataHistory]] = field(
        default=None, metadata=config(field_name="resolution_history")
    )
    severity_history: Optional[List[SeverityUpdate]] = field(
        default=None, metadata=config(field_name="severity_history")
    )
    tuning_history: Optional[List[TuningUpdate]] = field(
        default=None, metadata=config(field_name="tuning_history")
    )
    entities: Optional[EntityRelationships] = field(
        default=None, metadata=config(field_name="entities")
    )
    key_entities: Optional[List[EntityMetadata]] = field(
        default=None, metadata=config(field_name="key_entities")
    )
    source_entities: Optional[List[StructuredEntitySnapshot]] = field(
        default=None, metadata=config(field_name="source_entities")
    )
    target_entities: Optional[List[StructuredEntitySnapshot]] = field(
        default=None, metadata=config(field_name="target_entities")
    )
    event_ids: Optional[List[AuxiliaryEvent]] = field(
        default=None, metadata=config(field_name="event_ids")
    )
    observation_ids: Optional[List[Observation]] = field(
        default=None, metadata=config(field_name="observation_ids")
    )
    investigation_ids: Optional[List[Investigation]] = field(
        default=None, metadata=config(field_name="investigation_ids")
    )
    collection_ids: Optional[List[Collection]] = field(
        default=None, metadata=config(field_name="collection_ids")
    )
    enrichment_details: Optional[List[EnrichmentDetail]] = field(
        default=None, metadata=config(field_name="enrichment_details")
    )
    third_party_details: Optional[List[ThirdPartyDetail]] = field(
        default=None, metadata=config(field_name="third_party_details")
    )
    reference_details: Optional[List[ReferenceDetail]] = field(
        default=None, metadata=config(field_name="reference_details")
    )
    priority: Optional[AlertPriority] = field(
        default=None, metadata=config(field_name="priority")
    )
    events_metadata: Optional[AlertEventMetadata] = field(
        default=None, metadata=config(field_name="events_metadata")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertChangeRecord:
    """AlertChangeRecord."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    time: Optional[Timestamp] = field(default=None, metadata=config(field_name="time"))
    type: Optional[Union[AlertOperationType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AlertOperationType, x),
            field_name="type",
        ),
    )
    alert: Optional[AlertSnapshot] = field(
        default=None, metadata=config(field_name="alert")
    )
