"""IngestStats Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.ingest_stats.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.ingest_stats import IngestStatsService

log = logging.getLogger(__name__)


class TaegisSDKIngestStatsQuery:
    """Taegis Ingest_stats Query operations."""

    def __init__(self, service: IngestStatsService):
        self.service = service

    def tenant_volume(self, range_: DateRange) -> List[TenantDailyVolume]:
        """TenantVolume Given a Date range return the volume of data in the data lake."""
        endpoint = "TenantVolume"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "range": prepare_input(range_),
            },
            output=build_output_string(TenantDailyVolume),
        )
        if result.get(endpoint) is not None:
            return TenantDailyVolume.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query TenantVolume")

    def host_volume(self, range_: DateRange) -> List[HostDailyVolume]:
        """HostVolume description."""
        endpoint = "HostVolume"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "range": prepare_input(range_),
            },
            output=build_output_string(HostDailyVolume),
        )
        if result.get(endpoint) is not None:
            return HostDailyVolume.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query HostVolume")

    def top_schemas(self, range_: DateRange, top_k: int) -> List[TopKSchema]:
        """TopSchemas description."""
        endpoint = "TopSchemas"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "range": prepare_input(range_),
                "topK": prepare_input(top_k),
            },
            output=build_output_string(TopKSchema),
        )
        if result.get(endpoint) is not None:
            return TopKSchema.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query TopSchemas")

    def top_schemas_by_date(
        self, range_: DateRange, top_k: int
    ) -> List[TopKSchemasByDate]:
        """TopSchemasByDate description."""
        endpoint = "TopSchemasByDate"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "range": prepare_input(range_),
                "topK": prepare_input(top_k),
            },
            output=build_output_string(TopKSchemasByDate),
        )
        if result.get(endpoint) is not None:
            return TopKSchemasByDate.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query TopSchemasByDate")

    def tenant_sensor_types(self, range_: DateRange) -> TenantSensorType:
        """TenantSensorTypes description."""
        endpoint = "TenantSensorTypes"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "range": prepare_input(range_),
            },
            output=build_output_string(TenantSensorType),
        )
        if result.get(endpoint) is not None:
            return TenantSensorType.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query TenantSensorTypes")
