"""Investigations2 Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.investigations2.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.investigations2 import Investigations2Service

log = logging.getLogger(__name__)


class TaegisSDKInvestigations2Mutation:
    """Taegis Investigations2 Mutation operations."""

    def __init__(self, service: Investigations2Service):
        self.service = service

    def create_investigation_v2(
        self, input_: CreateInvestigationInput
    ) -> InvestigationV2:
        """createInvestigationV2 creates new investigation with the provided arguments.."""
        endpoint = "createInvestigationV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createInvestigationV2")

    def update_investigation_v2(
        self, input_: UpdateInvestigationV2Input
    ) -> InvestigationV2:
        """updateInvestigationV2 updates an existing investigation.
        This is a PATCH style mutation, only fields that are send in the input will be updated..
        """
        endpoint = "updateInvestigationV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateInvestigationV2")

    def add_evidence_to_investigation(
        self, input_: AddEvidenceToInvestigationInput
    ) -> AddEvidenceToInvestigationResult:
        """addEvidenceToInvestigation will add more evidence to an existing investigation.
        Evidence added through this mutation will not be considered genesis evidence.
        The response will include the evidence that the service will attempt to add to the investigation.

        Adding evidence to investigations is an asynchronous operation.
        It will typically finish pretty quickly, but added alerts/events will may not show up in the returned investigation until the async job is fully complete.
        The processing status, that is found on the investigation type will reflect the state of the processing job.
        Once the status is set to 'SUCCESS' the background job is complete and requesting the investigation will return the related evidence.

        Adding, removing or updating evidence (closing an investigation) while other jobs are processing for a given investigation will cause the jobs to queue.
        Jobs will be worked through in the order they were received.."""
        endpoint = "addEvidenceToInvestigation"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(AddEvidenceToInvestigationResult),
        )
        if result.get(endpoint) is not None:
            return AddEvidenceToInvestigationResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation addEvidenceToInvestigation")

    def remove_evidence_from_investigation(
        self, input_: RemoveEvidenceFromInvestigationInput
    ) -> RemoveEvidenceFromInvestigationResult:
        """removeEvidenceFromInvestigation will remove evidence from an existing investigation.
        The response will include the evidence that the service will attempt to remove from the investigation.

        Removing evidence from investigations is an asynchronous operation.
        It will typically finish pretty quickly, but removed alerts/events will can remain attached to the investigation until the async job is fully complete.
        The processing status, that is found on the investigation type will reflect the state of the processing job.
        Once the status is set to 'SUCCESS' the background job is complete and requesting the investigation will only return evidence that was not removed.

        Adding, removing or updating evidence (closing an investigation) while other jobs are processing for a given investigation will cause the jobs to queue.
        Jobs will be worked through in the order they were received.."""
        endpoint = "removeEvidenceFromInvestigation"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(RemoveEvidenceFromInvestigationResult),
        )
        if result.get(endpoint) is not None:
            return RemoveEvidenceFromInvestigationResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for mutation removeEvidenceFromInvestigation"
        )

    def close_investigation(self, input_: CloseInvestigationInput) -> InvestigationV2:
        """closeInvestigation will close an existing investigation.
        If the investigation has alerts attached to it, the alertsResolutionStatus field is required and alerts will be resolved based on the provided status.
        Once an investigation is closed, it can no longer be edited or have evidence added to it while in the closed state, it can only be archived.
        A closed investigation can be reopened if changes are needed after closing.

        Resolving evidence in an investigation is an asynchronous operation.
        It will typically finish pretty quickly, but resolving alerts will may not reflect the updated status until the async job is fully complete.
        The processing status, that is found on the investigation type will reflect the state of the processing job.
        Once the status is set to 'SUCCESS' the background job is complete and the alerts will have been updated.

        Adding, removing or updating evidence (closing an investigation) while other jobs are processing for a given investigation will cause the jobs to queue.
        Jobs will be worked through in the order they were received.."""
        endpoint = "closeInvestigation"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation closeInvestigation")

    def create_investigation_rule(
        self, input_: CreateInvestigationRuleInput
    ) -> InvestigationRule:
        """createInvestigationRule accepts input to create a new auto-investigation rule.."""
        endpoint = "createInvestigationRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationRule),
        )
        if result.get(endpoint) is not None:
            return InvestigationRule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createInvestigationRule")

    def update_investigation_rule(
        self, input_: UpdateInvestigationRuleInput
    ) -> InvestigationRule:
        """updateInvestigationRule accepts input to update an existing auto-investigation rule.."""
        endpoint = "updateInvestigationRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationRule),
        )
        if result.get(endpoint) is not None:
            return InvestigationRule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateInvestigationRule")

    def delete_investigation_rule(
        self, input_: DeleteInvestigationRuleInput
    ) -> InvestigationRule:
        """deleteInvestigationRule removes an existing investigation rule.
        This is a hard delete. Data will not be recoverable.."""
        endpoint = "deleteInvestigationRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationRule),
        )
        if result.get(endpoint) is not None:
            return InvestigationRule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteInvestigationRule")

    def create_investigation_template(
        self, input_: CreateInvestigationTemplateInput
    ) -> InvestigationTemplate:
        """createInvestigationTemplate accepts input to create a new auto-investigation template.."""
        endpoint = "createInvestigationTemplate"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationTemplate),
        )
        if result.get(endpoint) is not None:
            return InvestigationTemplate.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createInvestigationTemplate")

    def update_investigation_template(
        self, input_: UpdateInvestigationTemplateInput
    ) -> InvestigationTemplate:
        """updateInvestigationTemplate accepts input to update an existing auto-investigation template.."""
        endpoint = "updateInvestigationTemplate"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationTemplate),
        )
        if result.get(endpoint) is not None:
            return InvestigationTemplate.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateInvestigationTemplate")

    def delete_investigation_template(
        self, input_: DeleteInvestigationTemplateInput
    ) -> InvestigationTemplate:
        """deleteInvestigationTemplate removes an existing investigation template.
        This is a hard delete. Data will not be recoverable.."""
        endpoint = "deleteInvestigationTemplate"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationTemplate),
        )
        if result.get(endpoint) is not None:
            return InvestigationTemplate.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteInvestigationTemplate")

    def import_investigation_resources(
        self, input_: ImportInvestigationResourcesInput
    ) -> List[InvestigationResource]:
        """importInvestigationResources will import investigation resources (rules & templates) from a YAML file.
        The input YAML structure can be retrieved from a YAML string exported from the exportInvestigationResources query..
        """
        endpoint = "importInvestigationResources"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationResource),
        )
        if result.get(endpoint) is not None:
            return [
                parse_union_result(InvestigationResource, r)
                for r in result.get(endpoint)
            ]
        raise GraphQLNoRowsInResultSetError("for mutation importInvestigationResources")

    def add_comment_to_investigation(
        self, input_: AddCommentToInvestigationInput
    ) -> CommentV2:
        """addCommentToInvestigation adds a comment to an existing investigation.."""
        endpoint = "addCommentToInvestigation"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(CommentV2),
        )
        if result.get(endpoint) is not None:
            return CommentV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation addCommentToInvestigation")

    def update_investigation_comment(
        self, input_: UpdateInvestigationCommentInput
    ) -> CommentV2:
        """updateInvestigationComment updates an existing comment on an investigation.
        This is a PATCH style mutation, only fields that are send in the input will be updated.
        Only the user who created the comment can update it.
        Updating a comment and adding new @mentions will trigger new notifications but will not send notifications to @mentions that are already present in the comment..
        """
        endpoint = "updateInvestigationComment"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(CommentV2),
        )
        if result.get(endpoint) is not None:
            return CommentV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateInvestigationComment")

    def delete_investigation_comment(
        self, input_: DeleteInvestigationCommentInput
    ) -> CommentV2:
        """deleteInvestigationComment removes an existing comment from an investigation.
        This is a hard delete. Data will not be recoverable.."""
        endpoint = "deleteInvestigationComment"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(CommentV2),
        )
        if result.get(endpoint) is not None:
            return CommentV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteInvestigationComment")

    def archive_investigation_v2(
        self, input_: ArchiveInvestigationInput
    ) -> InvestigationV2:
        """archiveInvestigationV2 archives an existing investigation.
        Only investigations that are closed can be archived.
        There may be some investigations that are archived but not in closed states, these are legacy investigations that were archived before the "closed" requirement was introduced..
        """
        endpoint = "archiveInvestigationV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation archiveInvestigationV2")

    def unarchive_investigation_v2(
        self, input_: UnarchiveInvestigationInput
    ) -> InvestigationV2:
        """unarchiveInvestigationV2 unarchives an archived investigation.."""
        endpoint = "unarchiveInvestigationV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation unarchiveInvestigationV2")

    def archive_investigations_v2(
        self, input_: ArchiveInvestigationsInput
    ) -> ArchivedInvestigations:
        """archiveInvestigationsV2 archives a set of existing investigations.
        Only investigations that are closed can be archived.
        The response will include the ids of the investigations that were successfully archived and will not return errors for investigations that could not be archived..
        """
        endpoint = "archiveInvestigationsV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(ArchivedInvestigations),
        )
        if result.get(endpoint) is not None:
            return ArchivedInvestigations.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation archiveInvestigationsV2")

    def unarchive_investigations_v2(
        self, input_: UnarchiveInvestigationsInput
    ) -> UnarchivedInvestigations:
        """unarchiveInvestigationsV2 unarchives a set of archived investigations.
        The response will include the ids of the investigations that were successfully unarchived and will not return errors for investigations that could not be unarchived..
        """
        endpoint = "unarchiveInvestigationsV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(UnarchivedInvestigations),
        )
        if result.get(endpoint) is not None:
            return UnarchivedInvestigations.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation unarchiveInvestigationsV2")

    def init_investigation_file_upload(
        self, input_: InitInvestigationFileUploadInput
    ) -> InvestigationFileUpload:
        """initInvestigationFileUpload initializes a file upload for an investigation.
        The response will include a pre-signed URL that can be used to upload a file to the investigation..
        """
        endpoint = "initInvestigationFileUpload"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationFileUpload),
        )
        if result.get(endpoint) is not None:
            return InvestigationFileUpload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation initInvestigationFileUpload")

    def delete_investigation_file(
        self, input_: DeleteInvestigationFileInput
    ) -> InvestigationFileV2:
        """deleteInvestigationFile removes an existing file from an investigation.
        This is a hard delete. Data will not be recoverable.."""
        endpoint = "deleteInvestigationFile"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(InvestigationFileV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationFileV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteInvestigationFile")
