"""Preferences Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.preferences.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.preferences import PreferencesService

log = logging.getLogger(__name__)


class TaegisSDKPreferencesQuery:
    """Taegis Preferences Query operations."""

    def __init__(self, service: PreferencesService):
        self.service = service

    def user_preference_by_id(self, id_: str) -> UserPreference:
        """None."""
        endpoint = "userPreferenceByID"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(UserPreference),
        )
        if result.get(endpoint) is not None:
            return UserPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query userPreferenceByID")

    def user_notification_preference(self, user_id: str) -> UserPreference:
        """None."""
        endpoint = "userNotificationPreference"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "userID": prepare_input(user_id),
            },
            output=build_output_string(UserPreference),
        )
        if result.get(endpoint) is not None:
            return UserPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query userNotificationPreference")

    def user_notification_preferences(
        self, arguments: UserNotificationPreferencesArguments
    ) -> UserNotificationPreferences:
        """None."""
        endpoint = "userNotificationPreferences"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(UserNotificationPreferences),
        )
        if result.get(endpoint) is not None:
            return UserNotificationPreferences.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query userNotificationPreferences")

    def user_preference_by_key(self, key: str) -> UserPreference:
        """None."""
        endpoint = "userPreferenceByKey"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "key": prepare_input(key),
            },
            output=build_output_string(UserPreference),
        )
        if result.get(endpoint) is not None:
            return UserPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query userPreferenceByKey")

    def tenant_preference_by_id(self, id_: str) -> TenantPreference:
        """None."""
        endpoint = "tenantPreferenceByID"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TenantPreference),
        )
        if result.get(endpoint) is not None:
            return TenantPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query tenantPreferenceByID")

    def tenant_preference_by_key(self, key: str) -> TenantPreference:
        """None."""
        endpoint = "tenantPreferenceByKey"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "key": prepare_input(key),
            },
            output=build_output_string(TenantPreference),
        )
        if result.get(endpoint) is not None:
            return TenantPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query tenantPreferenceByKey")

    def list_tenant_preferences_by_key(self, key: str) -> List[TenantPreference]:
        """None."""
        endpoint = "listTenantPreferencesByKey"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "key": prepare_input(key),
            },
            output=build_output_string(TenantPreference),
        )
        if result.get(endpoint) is not None:
            return TenantPreference.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query listTenantPreferencesByKey")

    def list_all_tenant_preferences(
        self, filter_: listAllTenantPreferencesInput
    ) -> List[TenantPreference]:
        """None."""
        endpoint = "listAllTenantPreferences"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "filter": prepare_input(filter_),
            },
            output=build_output_string(TenantPreference),
        )
        if result.get(endpoint) is not None:
            return TenantPreference.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query listAllTenantPreferences")

    def ticketing_settings(self) -> List[TicketingSettings]:
        """None."""
        endpoint = "ticketingSettings"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(TicketingSettings),
        )
        if result.get(endpoint) is not None:
            return TicketingSettings.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query ticketingSettings")

    def partner_preferences(self) -> PartnerPreference:
        """None."""
        endpoint = "partnerPreferences"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(PartnerPreference),
        )
        if result.get(endpoint) is not None:
            return PartnerPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query partnerPreferences")

    def get_preferences(
        self, get_preference_selector: Optional[GetPreferenceSelector] = None
    ) -> List[UserPreferenceDictionary]:
        """None."""
        endpoint = "getPreferences"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "getPreferenceSelector": prepare_input(get_preference_selector),
            },
            output=build_output_string(UserPreferenceDictionary),
        )
        if result.get(endpoint) is not None:
            return UserPreferenceDictionary.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getPreferences")
