"""Threat Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.threat.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.threat import ThreatService

log = logging.getLogger(__name__)


class TaegisSDKThreatQuery:
    """Taegis Threat Query operations."""

    def __init__(self, service: ThreatService):
        self.service = service

    def threat_publication(self, id_: str) -> ThreatPublication:
        """Retreives a publication by ID.."""
        endpoint = "threatPublication"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatPublication),
        )
        if result.get(endpoint) is not None:
            return ThreatPublication.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatPublication")

    def threat_publications(self, text: str) -> List[ThreatPublication]:
        """Searches publications for text.."""
        endpoint = "threatPublications"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "text": prepare_input(text),
            },
            output=build_output_string(ThreatPublication),
        )
        if result.get(endpoint) is not None:
            return ThreatPublication.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatPublications")

    def threat_publications_search(self, text: List[str]) -> List[ThreatPublication]:
        """Gets publications for multiple indicators.."""
        endpoint = "threatPublicationsSearch"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "text": prepare_input(text),
            },
            output=build_output_string(ThreatPublication),
        )
        if result.get(endpoint) is not None:
            return ThreatPublication.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatPublicationsSearch")

    def threat_latest_publications(
        self, from_: int, size: int
    ) -> List[ThreatPublication]:
        """Gets the latest publications from an offset with a size.."""
        endpoint = "threatLatestPublications"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "from": prepare_input(from_),
                "size": prepare_input(size),
            },
            output=build_output_string(ThreatPublication),
        )
        if result.get(endpoint) is not None:
            return ThreatPublication.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatLatestPublications")

    def threat_identities_by_confidence(self, confidence: int) -> List[ThreatResult]:
        """Gets identities by confidence score.."""
        endpoint = "threatIdentitiesByConfidence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "confidence": prepare_input(confidence),
            },
            output=build_output_string(ThreatResult),
        )
        if result.get(endpoint) is not None:
            return [parse_union_result(ThreatResult, r) for r in result.get(endpoint)]
        raise GraphQLNoRowsInResultSetError("for query threatIdentitiesByConfidence")

    def threat_watchlist(
        self, type_: Union[ThreatParentType, TaegisEnum]
    ) -> List[ThreatRelationship]:
        """Gets a watchlist by type. All results are considered **high confidence**.
        Only IP and DOMAIN types are supported. FILE type has been removed from this endpoint.
        Instead, use the paged endpoint threatTimsMalwareFiles for FILE types.."""
        endpoint = "threatWatchlist"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "type": prepare_input(type_),
            },
            output=build_output_string(ThreatRelationship),
        )
        if result.get(endpoint) is not None:
            return ThreatRelationship.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatWatchlist")

    def threat_tims_malware_files(
        self, last_created: Optional[str] = None
    ) -> PagedMalwareFiles:
        """Get all TIMS 2.0 Malware file hashes. All results are considered **high confidence**.
        This is a paged service, requiring repeated queries. Total number of results can number over 750k.
        For the initial query, do not provide any search parameters or set 'last_created' to null.
        Subsequent queries should include the previous query's 'last_created' result from 'PagedMalwareFiles.last_created'
        as the input parameter. Returns pages of 10,000 at a time, sorted by the indicators field 'created' in desc order.
        The returned field 'has_more' will be false when the last page is returned.
        * Note: 'created' refers to an internal field associated with the indicator, not the time the indicator was first found.
        It is only used for sorting.."""
        endpoint = "threatTimsMalwareFiles"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "last_created": prepare_input(last_created),
            },
            output=build_output_string(PagedMalwareFiles),
        )
        if result.get(endpoint) is not None:
            return PagedMalwareFiles.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatTimsMalwareFiles")

    def threat_indicator_publications(self, id_: str) -> List[ThreatReport]:
        """Gets publications related to indicators.."""
        endpoint = "threatIndicatorPublications"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatReport),
        )
        if result.get(endpoint) is not None:
            return ThreatReport.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatIndicatorPublications")

    def threat_publications_indicators(self, id_: List[str]) -> List[ThreatIndicator]:
        """Get list of indicators related to list of publications."""
        endpoint = "threatPublicationsIndicators"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatIndicator),
        )
        if result.get(endpoint) is not None:
            return ThreatIndicator.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatPublicationsIndicators")

    def threat_indicator_intelligence(self, id_: str) -> ThreatIndicatorIntelligence:
        """Retrieves all intelligence associated with an indicator.."""
        endpoint = "threatIndicatorIntelligence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatIndicatorIntelligence),
        )
        if result.get(endpoint) is not None:
            return ThreatIndicatorIntelligence.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatIndicatorIntelligence")

    def threat_relationship(self, id_: str) -> ThreatRelationship:
        """Gets relationship by `id`.."""
        endpoint = "threatRelationship"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatRelationship),
        )
        if result.get(endpoint) is not None:
            return ThreatRelationship.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatRelationship")

    def threat_identity(self, id_: str) -> ThreatIdentity:
        """Gets identity by `id`.."""
        endpoint = "threatIdentity"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatIdentity),
        )
        if result.get(endpoint) is not None:
            return ThreatIdentity.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatIdentity")

    def threat_malware(self, id_: str) -> ThreatMalware:
        """Gets malware by `id`.."""
        endpoint = "threatMalware"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatMalware),
        )
        if result.get(endpoint) is not None:
            return ThreatMalware.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatMalware")

    def threat_identities(
        self, confidence: Optional[int] = None
    ) -> List[ThreatIdentity]:
        """Gets identities by confidence score.."""
        endpoint = "threatIdentities"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "confidence": prepare_input(confidence),
            },
            output=build_output_string(ThreatIdentity),
        )
        if result.get(endpoint) is not None:
            return ThreatIdentity.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatIdentities")

    def threat_vid_intelligence(self, vid: str) -> ThreatVidIntelligence:
        """Retrieves all intelligence associated with a `VID`.."""
        endpoint = "threatVidIntelligence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "vid": prepare_input(vid),
            },
            output=build_output_string(ThreatVidIntelligence),
        )
        if result.get(endpoint) is not None:
            return ThreatVidIntelligence.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatVidIntelligence")

    def threat_indicators_intelligence(
        self, id_: Optional[List[str]] = None
    ) -> List[ThreatIndicatorIntelligence]:
        """Retrieves all intelligence associated with a list of indicators.."""
        endpoint = "threatIndicatorsIntelligence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatIndicatorIntelligence),
        )
        if result.get(endpoint) is not None:
            return ThreatIndicatorIntelligence.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatIndicatorsIntelligence")

    def threat_rule_vid_intelligence(self, rule_id: str) -> List[ThreatVidIntelligence]:
        """Retrieves all intelligence associated with a `Rule ID`.."""
        endpoint = "threatRuleVidIntelligence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ruleID": prepare_input(rule_id),
            },
            output=build_output_string(ThreatVidIntelligence),
        )
        if result.get(endpoint) is not None:
            return ThreatVidIntelligence.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatRuleVidIntelligence")

    def threat_malware_intelligence(self, id_: str) -> ThreatMalwareIntelligence:
        """Retrieves all intelligence associated with a malware.."""
        endpoint = "threatMalwareIntelligence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
            },
            output=build_output_string(ThreatMalwareIntelligence),
        )
        if result.get(endpoint) is not None:
            return ThreatMalwareIntelligence.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatMalwareIntelligence")

    def threat_intelligence(
        self,
        object_type: Union[ThreatFacetObject, TaegisEnum],
        filters: Optional[ThreatFilter] = None,
        page: Optional[ThreatPageInput] = None,
    ) -> ThreatIntelligence:
        """Retrieves all intelligence based on input threat object type and filters."""
        endpoint = "threatIntelligence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "objectType": prepare_input(object_type),
                "filters": prepare_input(filters),
                "page": prepare_input(page),
            },
            output=build_output_string(ThreatIntelligence),
        )
        if result.get(endpoint) is not None:
            return ThreatIntelligence.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query threatIntelligence")

    def threat_facet_info(
        self,
        object_type: Union[ThreatFacetObject, TaegisEnum],
        filters: Optional[ThreatFilter] = None,
        facet_objs: Optional[List[str]] = None,
    ) -> List[FacetInfo]:
        """Retrieves facet count based on object type and filters."""
        endpoint = "threatFacetInfo"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "objectType": prepare_input(object_type),
                "filters": prepare_input(filters),
                "facetObjs": prepare_input(facet_objs),
            },
            output=build_output_string(FacetInfo),
        )
        if result.get(endpoint) is not None:
            return FacetInfo.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatFacetInfo")

    def threat_associated_indicators(
        self, id_: str, page: Optional[ThreatPageInput] = None
    ) -> List[ThreatIndicator]:
        """Retrives all associated indicators to a malware or threat_group."""
        endpoint = "threatAssociatedIndicators"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ID": prepare_input(id_),
                "page": prepare_input(page),
            },
            output=build_output_string(ThreatIndicator),
        )
        if result.get(endpoint) is not None:
            return ThreatIndicator.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query threatAssociatedIndicators")
