"""Threat Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class ThreatFacetObject(str, Enum):
    """ThreatFacetObject."""

    THREAT_GROUP = "threat_group"
    MALWARE = "malware"
    REPORT = "report"


class ThreatParentType(str, Enum):
    """ThreatParentType."""

    IP = "IP"
    DOMAIN = "DOMAIN"


class ThreatIndicatorClass(str, Enum):
    """ThreatIndicatorClass."""

    IPV4 = "ipv4"
    IPV6 = "ipv6"
    CIDR = "cidr"
    URL = "url"
    DOMAIN = "domain"
    MD5 = "md5"
    SHA256 = "sha256"
    SHA1 = "sha1"
    UNKNOWN = "unknown"


class ThreatPatternType(str, Enum):
    """ThreatPatternType."""

    STIX = "stix"
    PCRE = "pcre"
    SIGMA = "sigma"
    SNORT = "snort"
    SURICATA = "suricata"
    YARA = "yara"


class ThreatIdentityClass(str, Enum):
    """ThreatIdentityClass."""

    INDIVIDUAL = "individual"
    GROUP = "group"
    SYSTEM = "system"
    ORGANIZATION = "organization"
    CLASS = "class"
    UNSPECIFIED = "unspecified"


class ThreatIndustrySectors(str, Enum):
    """ThreatIndustrySectors."""

    AGRICULTURE = "agriculture"
    AEROSPACE = "aerospace"
    AUTOMOTIVE = "automotive"
    CHEMICAL = "chemical"
    COMMERCIAL = "commercial"
    COMMUNICATIONS = "communications"
    CONSTRUCTION = "construction"
    DEFENSE = "defense"
    EDUCATION = "education"
    ENERGY = "energy"
    ENTERTAINMENT = "entertainment"
    FINANCIAL_SERVICES = "financial_services"
    EMERGENCY_SERVICES = "emergency_services"
    GOVERNMENT_LOCAL = "government_local"
    GOVERNMENT_NATIONAL = "government_national"
    GOVERNMENT_PUBLIC_SERVICES = "government_public_services"
    GOVERNMENT_REGIONAL = "government_regional"
    HEALTHCARE = "healthcare"
    HOSPITALITY_LEISURE = "hospitality_leisure"
    INFRASTRUCTURE_DAMS = "infrastructure_dams"
    INFRASTRUCTURE_NUCLEAR = "infrastructure_nuclear"
    INFRASTRUCTURE_WATER = "infrastructure_water"
    INSURANCE = "insurance"
    MANUFACTURING = "manufacturing"
    MINING = "mining"
    NON_PROFIT = "non_profit"
    PHARMACEUTICALS = "pharmaceuticals"
    RETAIL = "retail"
    TECHNOLOGY = "technology"
    TELECOMMUNICATIONS = "telecommunications"
    TRANSPORTATION = "transportation"
    UTILITIES = "utilities"


class ThreatIndicatorType(str, Enum):
    """ThreatIndicatorType."""

    ANOMALOUS_ACTIVITY = "anomalous_activity"
    ANONYMIZATION = "anonymization"
    BENIGN = "benign"
    COMPROMISED = "compromised"
    MALICIOUS_ACTIVITY = "malicious_activity"
    ATTRIBUTION = "attribution"
    UNKNOWN = "unknown"


class ThreatRelationshipType(str, Enum):
    """ThreatRelationshipType."""

    TARGETS = "targets"
    USES = "uses"
    ATTRIBUTED_TO = "attributed_to"
    COMPROMISES = "compromises"
    ORIGINATES_FROM = "originates_from"
    INVESTIGATES = "investigates"
    MITIGATES = "mitigates"
    REMEDIATES = "remediates"
    LOCATED_AT = "located_at"
    IMPERSONATES = "impersonates"
    BASED_ON = "based_on"
    COMMUNICATES_WITH = "communicates_with"
    CONSISTS_OF = "consists_of"
    CONTROLS = "controls"
    DELIVERS = "delivers"
    HAS = "has"
    HOSTS = "hosts"
    BEACONS_TO = "beacons_to"
    EXFILTRATES_TO = "exfiltrates_to"
    OWNS = "owns"
    INDICATES = "indicates"
    AUTHORED_BY = "authored_by"
    DOWNLOADS = "downloads"
    DROPS = "drops"
    EXPLOITS = "exploits"
    VARIANT_OF = "variant_of"
    CHARACTERIZES = "characterizes"
    ANALYSIS_OF = "analysis_of"
    STATIC_ANALYSIS_OF = "static_analysis_of"
    DYNAMIC_ANALYSIS_OF = "dynamic_analysis_of"
    LISTS = "lists"
    LISTED_ON = "listed_on"
    RELATED_TO = "related_to"
    INDIRECT = "indirect"
    HAS_VID = "has_vid"
    HOSTED_ON = "hosted_on"
    LINKED_TO = "linked_to"
    GEOLOCATES_TO = "geolocates_to"
    AFFILIATED_WITH = "affiliated_with"
    CHILD_OF = "child_of"


class ThreatMalwareType(str, Enum):
    """ThreatMalwareType."""

    ADWARE = "adware"
    BACKDOOR = "backdoor"
    BOT = "bot"
    BOOTKIT = "bootkit"
    DDOS = "ddos"
    DOWNLOADER = "downloader"
    DROPPER = "dropper"
    EXPLOIT_KIT = "exploit_kit"
    IRC_BOTNET = "irc_botnet"
    KEYLOGGER = "keylogger"
    RANSOMWARE = "ransomware"
    REMOTE_ACCESS_TROJAN = "remote_access_trojan"
    RESOURCE_EXPLOITATION = "resource_exploitation"
    ROGUE_SECURITY_SOFTWARE = "rogue_security_software"
    ROOTKIT = "rootkit"
    SCREEN_CAPTURE = "screen_capture"
    SPYWARE = "spyware"
    TROJAN = "trojan"
    UNKNOWN = "unknown"
    VIRUS = "virus"
    WEBSHELL = "webshell"
    WIPER = "wiper"
    WORM = "worm"


class ThreatCapabilities(str, Enum):
    """ThreatCapabilities."""

    ACCESSES_REMOTE_MACHINES = "accesses_remote_machines"
    ANTI_DEBUGGING = "anti_debugging"
    ANTI_DISASSEMBLY = "anti_disassembly"
    ANTI_EMULATION = "anti_emulation"
    ANTI_MEMORY_FORENSICS = "anti_memory_forensics"
    ANTI_SANDBOX = "anti_sandbox"
    ANTI_VM = "anti_vm"
    CAPTURES_INPUT_PERIPHERALS = "captures_input_peripherals"
    CAPTURES_OUTPUT_PERIPHERALS = "captures_output_peripherals"
    CAPTURES_SYSTEM_STATE_DATA = "captures_system_state_data"
    CLEANS_TRACES_OF_INFECTION = "cleans_traces_of_infection"
    COMMITS_FRAUD = "commits_fraud"
    COMMUNICATES_WITH_C2 = "communicates_with_c2"
    COMPROMISES_DATA_AVAILABILITY = "compromises_data_availability"
    COMPROMISES_DATA_INTEGRITY = "compromises_data_integrity"
    COMPROMISES_SYSTEM_AVAILABILITY = "compromises_system_availability"
    CONTROLS_LOCAL_MACHINE = "controls_local_machine"
    DEGRADES_SECURITY_SOFTWARE = "degrades_security_software"
    DEGRADES_SYSTEM_UPDATES = "degrades_system_updates"
    DETERMINES_C2_SERVER = "determines_c2_server"
    EMAILS_SPAM = "emails_spam"
    ESCALATES_PRIVILEGES = "escalates_privileges"
    EVADES_AV = "evades_av"
    EXFILTRATES_DATA = "exfiltrates_data"
    FINGERPRINTS_HOST = "fingerprints_host"
    HIDES_ARTIFACTS = "hides_artifacts"
    HIDES_EXECUTING_CODE = "hides_executing_code"
    INFECTS_FILES = "infects_files"
    INFECTS_REMOTE_MACHINES = "infects_remote_machines"
    INSTALLS_OTHER_COMPONENTS = "installs_other_components"
    PERSISTS_AFTER_SYSTEM_REBOOT = "persists_after_system_reboot"
    PREVENTS_ARTIFACT_ACCESS = "prevents_artifact_access"
    PREVENTS_ARTIFACT_DELETION = "prevents_artifact_deletion"
    PROBES_NETWORK_ENVIRONMENT = "probes_network_environment"
    SELF_MODIFIES = "self_modifies"
    STEALS_AUTHENTICATION_CREDENTIALS = "steals_authentication_credentials"
    VIOLATES_SYSTEM_OPERATIONAL_INTEGRITY = "violates_system_operational_integrity"


class ThreatArchitectureExecutionEnvs(str, Enum):
    """ThreatArchitectureExecutionEnvs."""

    ALPHA = "alpha"
    ARM = "arm"
    IA_64 = "ia_64"
    MIPS = "mips"
    POWERPC = "powerpc"
    SPARC = "sparc"
    X86 = "x86"
    X86_64 = "x86_64"


class ThreatImplementationLanguages(str, Enum):
    """ThreatImplementationLanguages."""

    APPLESCRIPT = "applescript"
    BASH = "bash"
    C = "c"
    C_PLUS_PLUS = "c_plus_plus"
    C_SHARP = "c_sharp"
    GO = "go"
    JAVA = "java"
    JAVASCRIPT = "javascript"
    LUA = "lua"
    OBJECTIVE_C = "objective_c"
    PERL = "perl"
    PHP = "php"
    POWERSHELL = "powershell"
    PYTHON = "python"
    RUBY = "ruby"
    SCALA = "scala"
    SWIFT = "swift"
    TYPESCRIPT = "typescript"
    VISUAL_BASIC = "visual_basic"
    X86_32 = "x86_32"
    X86_64 = "x86_64"


class ThreatObjectType(str, Enum):
    """ThreatObjectType."""

    INDICATOR = "indicator"
    IDENTITY = "identity"
    RELATIONSHIP = "relationship"
    MALWARE = "malware"
    INTRUSIONSET = "intrusionset"
    REPORT = "report"
    COUNTRY = "country"
    CVE = "CVE"
    SWID = "swid"
    XDR_EVENT_FILTER = "xdr_event_filter"
    ATTACK_TACTIC = "attack_tactic"
    ATTACK_TECHNIQUE = "attack_technique"
    RED_CLOAK_WATCH_LIST = "red_cloak_watch_list"
    RED_CLOAK_INSPECTOR_RULE = "red_cloak_inspector_rule"
    RED_CLOAK_YARA_RULE = "red_cloak_yara_rule"
    TAEGIS_YARA_RULE = "taegis_yara_rule"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatPageInput:
    """ThreatPageInput."""

    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Facet:
    """Facet."""

    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    facet: Optional[str] = field(default=None, metadata=config(field_name="facet"))
    search_only: Optional[bool] = field(
        default=None, metadata=config(field_name="searchOnly")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FacetFieldInfo:
    """FacetFieldInfo."""

    field_: Optional[str] = field(default=None, metadata=config(field_name="field"))
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PageInfo:
    """PageInfo."""

    end_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="endCursor")
    )
    has_next_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasNextPage")
    )
    start_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="startCursor")
    )
    has_previous_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasPreviousPage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatKillChainPhase:
    """ThreatKillChainPhase."""

    kill_chain_name: Optional[str] = field(
        default=None, metadata=config(field_name="kill_chain_name")
    )
    phase_name: Optional[str] = field(
        default=None, metadata=config(field_name="phase_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatHashes:
    """ThreatHashes."""

    md5: Optional[str] = field(default=None, metadata=config(field_name="MD5"))
    sha256: Optional[str] = field(default=None, metadata=config(field_name="SHA256"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatDNSInfo:
    """ThreatDNSInfo."""

    domain: Optional[str] = field(default=None, metadata=config(field_name="Domain"))
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="Hostname")
    )
    subdomain: Optional[str] = field(
        default=None, metadata=config(field_name="Subdomain")
    )
    tld: Optional[str] = field(default=None, metadata=config(field_name="Tld"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatURLInfo:
    """ThreatURLInfo."""

    query: Optional[str] = field(default=None, metadata=config(field_name="Query"))
    scheme: Optional[str] = field(default=None, metadata=config(field_name="Scheme"))
    port: Optional[str] = field(default=None, metadata=config(field_name="Port"))
    path: Optional[str] = field(default=None, metadata=config(field_name="Path"))
    request_uri: Optional[str] = field(
        default=None, metadata=config(field_name="RequestURI")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatTip:
    """ThreatTip."""

    id: Optional[str] = field(default=None, metadata=config(field_name="ID"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    active: Optional[bool] = field(default=None, metadata=config(field_name="Active"))
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="UpdatedAt")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatSwidInput:
    """ThreatSwidInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="Id"))
    author: Optional[str] = field(default=None, metadata=config(field_name="Author"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    engine_group_name: Optional[str] = field(
        default=None, metadata=config(field_name="EngineGroupName")
    )
    file_name: Optional[str] = field(
        default=None, metadata=config(field_name="FileName")
    )
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="Priority")
    )
    priority_value: Optional[str] = field(
        default=None, metadata=config(field_name="PriorityValue")
    )
    revision: Optional[int] = field(
        default=None, metadata=config(field_name="Revision")
    )
    swid: Optional[int] = field(default=None, metadata=config(field_name="Swid"))
    swid_name: Optional[str] = field(
        default=None, metadata=config(field_name="SwidName")
    )
    text: Optional[str] = field(default=None, metadata=config(field_name="Text"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatGroupInput:
    """ThreatGroupInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    is_active: Optional[bool] = field(
        default=None, metadata=config(field_name="IsActive")
    )
    thematic_area: Optional[str] = field(
        default=None, metadata=config(field_name="ThematicArea")
    )
    objectives: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Objectives")
    )
    aliases: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Aliases")
    )
    tools: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Tools")
    )
    motivation: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Motivation")
    )
    region: Optional[str] = field(default=None, metadata=config(field_name="Region"))
    target_geography: Optional[List[str]] = field(
        default=None, metadata=config(field_name="TargetGeography")
    )
    intended_effect: Optional[List[str]] = field(
        default=None, metadata=config(field_name="IntendedEffect")
    )
    target_sectors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="TargetSectors")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="Description")
    )
    active_since: Optional[str] = field(
        default=None, metadata=config(field_name="ActiveSince")
    )
    last_known_activity: Optional[str] = field(
        default=None, metadata=config(field_name="LastKnownActivity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EventFilter:
    """EventFilter."""

    key_string: Optional[str] = field(
        default=None, metadata=config(field_name="key_string")
    )
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    is_case_sensitive: Optional[bool] = field(
        default=None, metadata=config(field_name="is_case_sensitive")
    )
    is_inverted: Optional[bool] = field(
        default=None, metadata=config(field_name="is_inverted")
    )
    test_should: Optional[List[str]] = field(
        default=None, metadata=config(field_name="test_should")
    )
    test_should_not: Optional[List[str]] = field(
        default=None, metadata=config(field_name="test_should_not")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ReferenceList:
    """ReferenceList."""

    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatAnalysis:
    """ThreatAnalysis."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    publication_date: Optional[str] = field(
        default=None, metadata=config(field_name="PublicationDate")
    )
    tlp: Optional[str] = field(default=None, metadata=config(field_name="TLP"))
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="ReportID")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatLocation:
    """ThreatLocation."""

    longitude: Optional[float] = field(
        default=None, metadata=config(field_name="Longitude")
    )
    latitude: Optional[float] = field(
        default=None, metadata=config(field_name="Latitude")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TimsMalwareFile:
    """TimsMalwareFile."""

    file_hash: Optional[str] = field(
        default=None, metadata=config(field_name="file_hash")
    )
    information_source: Optional[str] = field(
        default=None, metadata=config(field_name="information_source")
    )
    threat_description: Optional[str] = field(
        default=None, metadata=config(field_name="threat_description")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    source_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="source_internal")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatTags:
    """ThreatTags."""

    group_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupTag")
    )
    malware_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="malwareTag")
    )
    vid_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="vidTag")
    )
    report_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reportTag")
    )
    country_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="countryTag")
    )
    cve_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="cveTag")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatWhois:
    """ThreatWhois."""

    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="DomainName")
    )
    registrar_name: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrarName")
    )
    contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="ContactEmail")
    )
    whois_server: Optional[str] = field(
        default=None, metadata=config(field_name="WhoisServer")
    )
    name_servers: Optional[str] = field(
        default=None, metadata=config(field_name="NameServers")
    )
    created_date: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedDate")
    )
    updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="UpdatedDate")
    )
    expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="ExpiresDate")
    )
    standard_reg_created_date: Optional[str] = field(
        default=None, metadata=config(field_name="StandardRegCreatedDate")
    )
    standard_reg_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="StandardRegUpdatedDate")
    )
    standard_reg_expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="StandardRegExpiresDate")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="Status"))
    audit_audit_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="AuditAuditUpdatedDate")
    )
    registrant_email: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantEmail")
    )
    registrant_name: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantName")
    )
    registrant_organization: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantOrganization")
    )
    registrant_street1: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantStreet1")
    )
    registrant_city: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantCity")
    )
    registrant_state: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantState")
    )
    registrant_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantPostalCode")
    )
    registrant_country: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantCountry")
    )
    registrant_fax: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantFax")
    )
    registrant_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantTelephone")
    )
    administrative_contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactEmail")
    )
    administrative_contact_name: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactName")
    )
    administrative_contact_organization: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactOrganization")
    )
    administrative_contact_street1: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactStreet1")
    )
    administrative_contact_city: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactCity")
    )
    administrative_contact_state: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactState")
    )
    administrative_contact_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactPostalCode")
    )
    administrative_contact_country: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactCountry")
    )
    administrative_contact_fax: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactFax")
    )
    administrative_contact_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactTelephone")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatHashesInput:
    """ThreatHashesInput."""

    md5: Optional[str] = field(default=None, metadata=config(field_name="MD5"))
    sha256: Optional[str] = field(default=None, metadata=config(field_name="SHA256"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatKillChainPhaseInput:
    """ThreatKillChainPhaseInput."""

    kill_chain_name: Optional[str] = field(
        default=None, metadata=config(field_name="kill_chain_name")
    )
    phase_name: Optional[str] = field(
        default=None, metadata=config(field_name="phase_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatAdvisory:
    """ThreatAdvisory."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    publication_date: Optional[str] = field(
        default=None, metadata=config(field_name="PublicationDate")
    )
    tlp: Optional[str] = field(default=None, metadata=config(field_name="TLP"))
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="ReportID")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatPublication:
    """ThreatPublication."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    type: Optional[str] = field(default=None, metadata=config(field_name="Type"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="Description")
    )
    published: Optional[str] = field(
        default=None, metadata=config(field_name="Published")
    )
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    tlp: Optional[str] = field(default=None, metadata=config(field_name="TLP"))
    vid: Optional[str] = field(default=None, metadata=config(field_name="VID"))
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="ReportID")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )
    category: Optional[str] = field(
        default=None, metadata=config(field_name="Category")
    )
    language: Optional[str] = field(
        default=None, metadata=config(field_name="Language")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatReportInput:
    """ThreatReportInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    report_type: Optional[str] = field(
        default=None, metadata=config(field_name="reportType")
    )
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="reportID")
    )
    category: Optional[str] = field(
        default=None, metadata=config(field_name="category")
    )
    threat_type: Optional[str] = field(
        default=None, metadata=config(field_name="threatType")
    )
    threat_actor_type: Optional[List[str]] = field(
        default=None, metadata=config(field_name="threatActorType")
    )
    target_geography: Optional[List[str]] = field(
        default=None, metadata=config(field_name="targetGeography")
    )
    target_sectors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="targetSectors")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    published: Optional[str] = field(
        default=None, metadata=config(field_name="published")
    )
    object_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="object_refs")
    )
    content: Optional[str] = field(default=None, metadata=config(field_name="content"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FacetInfo:
    """FacetInfo."""

    display_name: Optional[str] = field(
        default=None, metadata=config(field_name="displayName")
    )
    facet: Optional[str] = field(default=None, metadata=config(field_name="facet"))
    fields: Optional[List[FacetFieldInfo]] = field(
        default=None, metadata=config(field_name="fields")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatSwid:
    """ThreatSwid."""

    id: Optional[str] = field(default=None, metadata=config(field_name="Id"))
    author: Optional[str] = field(default=None, metadata=config(field_name="Author"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    engine_group_name: Optional[str] = field(
        default=None, metadata=config(field_name="EngineGroupName")
    )
    file_name: Optional[str] = field(
        default=None, metadata=config(field_name="FileName")
    )
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="Priority")
    )
    priority_value: Optional[str] = field(
        default=None, metadata=config(field_name="PriorityValue")
    )
    revision: Optional[int] = field(
        default=None, metadata=config(field_name="Revision")
    )
    swid: Optional[int] = field(default=None, metadata=config(field_name="Swid"))
    swid_name: Optional[str] = field(
        default=None, metadata=config(field_name="SwidName")
    )
    text: Optional[str] = field(default=None, metadata=config(field_name="Text"))
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatGroup:
    """ThreatGroup."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    is_active: Optional[bool] = field(
        default=None, metadata=config(field_name="IsActive")
    )
    thematic_area: Optional[str] = field(
        default=None, metadata=config(field_name="ThematicArea")
    )
    region: Optional[str] = field(default=None, metadata=config(field_name="Region"))
    target_geography: Optional[List[str]] = field(
        default=None, metadata=config(field_name="TargetGeography")
    )
    objectives: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Objectives")
    )
    aliases: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Aliases")
    )
    tools: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Tools")
    )
    motivation: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Motivation")
    )
    intended_effect: Optional[List[str]] = field(
        default=None, metadata=config(field_name="IntendedEffect")
    )
    target_sectors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="TargetSectors")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="Description")
    )
    active_since: Optional[str] = field(
        default=None, metadata=config(field_name="ActiveSince")
    )
    last_known_activity: Optional[str] = field(
        default=None, metadata=config(field_name="LastKnownActivity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    group_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupTag")
    )
    malware_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="malwareTag")
    )
    vid_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="vidTag")
    )
    report_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reportTag")
    )
    country_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="countryTag")
    )
    cve_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="cveTag")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Country:
    """Country."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    country_name: Optional[str] = field(
        default=None, metadata=config(field_name="country_name")
    )
    country_code: Optional[str] = field(
        default=None, metadata=config(field_name="country_code")
    )
    geopoint: Optional[List[float]] = field(
        default=None, metadata=config(field_name="geopoint")
    )
    region: Optional[str] = field(default=None, metadata=config(field_name="region"))
    country_name_official: Optional[str] = field(
        default=None, metadata=config(field_name="country_name_official")
    )
    country_name_alternatives: Optional[List[str]] = field(
        default=None, metadata=config(field_name="country_name_alternatives")
    )
    country_code_alpha3: Optional[str] = field(
        default=None, metadata=config(field_name="country_code_alpha3")
    )
    country_code_numeric3: Optional[str] = field(
        default=None, metadata=config(field_name="country_code_numeric3")
    )
    capitals: Optional[List[str]] = field(
        default=None, metadata=config(field_name="capitals")
    )
    subregion: Optional[str] = field(
        default=None, metadata=config(field_name="subregion")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CVE:
    """CVE."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    cve_number: Optional[str] = field(
        default=None, metadata=config(field_name="cve_number")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AttackTactic:
    """AttackTactic."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    attack_tactic_id: Optional[str] = field(
        default=None, metadata=config(field_name="attack_tactic_id")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    author: Optional[str] = field(default=None, metadata=config(field_name="author"))
    creation_date: Optional[str] = field(
        default=None, metadata=config(field_name="creation_date")
    )
    modified_date: Optional[str] = field(
        default=None, metadata=config(field_name="modified_date")
    )
    references: Optional[List[str]] = field(
        default=None, metadata=config(field_name="references")
    )
    related_attack: Optional[List[str]] = field(
        default=None, metadata=config(field_name="related_attack")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AttackTechnique:
    """AttackTechnique."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    attack_technique_id: Optional[str] = field(
        default=None, metadata=config(field_name="attack_technique_id")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    author: Optional[str] = field(default=None, metadata=config(field_name="author"))
    creation_date: Optional[str] = field(
        default=None, metadata=config(field_name="creation_date")
    )
    modified_date: Optional[str] = field(
        default=None, metadata=config(field_name="modified_date")
    )
    references: Optional[List[str]] = field(
        default=None, metadata=config(field_name="references")
    )
    related_attack: Optional[List[str]] = field(
        default=None, metadata=config(field_name="related_attack")
    )
    related_capec: Optional[List[str]] = field(
        default=None, metadata=config(field_name="related_capec")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RedCloakWatchList:
    """RedCloakWatchList."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    classification: Optional[str] = field(
        default=None, metadata=config(field_name="classification")
    )
    confidence_value: Optional[str] = field(
        default=None, metadata=config(field_name="confidence_value")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="created_by")
    )
    last_modified_by: Optional[str] = field(
        default=None, metadata=config(field_name="last_modified_by")
    )
    creation_time: Optional[str] = field(
        default=None, metadata=config(field_name="creation_time")
    )
    criteria: Optional[List[str]] = field(
        default=None, metadata=config(field_name="criteria")
    )
    doc_type: Optional[str] = field(
        default=None, metadata=config(field_name="doc_type")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    endpoint_platform: Optional[str] = field(
        default=None, metadata=config(field_name="endpoint_platform")
    )
    countermeasure_visibility: Optional[int] = field(
        default=None, metadata=config(field_name="countermeasure_visibility")
    )
    resources: Optional[List[str]] = field(
        default=None, metadata=config(field_name="resources")
    )
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))
    domains: Optional[List[str]] = field(
        default=None, metadata=config(field_name="domains")
    )
    allowed_domains: Optional[List[str]] = field(
        default=None, metadata=config(field_name="allowed_domains")
    )
    day: Optional[str] = field(default=None, metadata=config(field_name="day"))
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RedCloakInspectorRule:
    """RedCloakInspectorRule."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    rule_type: Optional[str] = field(
        default=None, metadata=config(field_name="rule_type")
    )
    rule: Optional[str] = field(default=None, metadata=config(field_name="rule"))
    threat_groups: Optional[List[str]] = field(
        default=None, metadata=config(field_name="threat_groups")
    )
    active: Optional[bool] = field(default=None, metadata=config(field_name="active"))
    classification: Optional[str] = field(
        default=None, metadata=config(field_name="classification")
    )
    resources: Optional[List[str]] = field(
        default=None, metadata=config(field_name="resources")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RedCloakYaraRule:
    """RedCloakYaraRule."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    yara_id: Optional[str] = field(default=None, metadata=config(field_name="yara_id"))
    event_description: Optional[str] = field(
        default=None, metadata=config(field_name="event_description")
    )
    author: Optional[str] = field(default=None, metadata=config(field_name="author"))
    metadata: Optional[str] = field(
        default=None, metadata=config(field_name="metadata")
    )
    metadata_ver: Optional[str] = field(
        default=None, metadata=config(field_name="metadata_ver")
    )
    strings: Optional[str] = field(default=None, metadata=config(field_name="strings"))
    condition: Optional[str] = field(
        default=None, metadata=config(field_name="condition")
    )
    threat_group: Optional[str] = field(
        default=None, metadata=config(field_name="threat_group")
    )
    rule_severity: Optional[str] = field(
        default=None, metadata=config(field_name="rule_severity")
    )
    tlp: Optional[str] = field(default=None, metadata=config(field_name="tlp"))
    mss: Optional[str] = field(default=None, metadata=config(field_name="mss"))
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TaegisYaraRule:
    """TaegisYaraRule."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    event_description: Optional[str] = field(
        default=None, metadata=config(field_name="event_description")
    )
    author: Optional[str] = field(default=None, metadata=config(field_name="author"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    classification: Optional[str] = field(
        default=None, metadata=config(field_name="classification")
    )
    yara_id: Optional[str] = field(default=None, metadata=config(field_name="yara_id"))
    attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attack_categories")
    )
    severity_float: Optional[float] = field(
        default=None, metadata=config(field_name="severity_float")
    )
    confidence_float: Optional[float] = field(
        default=None, metadata=config(field_name="confidence_float")
    )
    active: Optional[bool] = field(default=None, metadata=config(field_name="active"))
    creation_date: Optional[str] = field(
        default=None, metadata=config(field_name="creation_date")
    )
    modified_date: Optional[str] = field(
        default=None, metadata=config(field_name="modified_date")
    )
    taegis_alert_visibility: Optional[str] = field(
        default=None, metadata=config(field_name="taegis_alert_visibility")
    )
    taegis_create_alert: Optional[bool] = field(
        default=None, metadata=config(field_name="taegis_create_alert")
    )
    metadata_ver: Optional[str] = field(
        default=None, metadata=config(field_name="metadata_ver")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PagedMalwareFiles:
    """PagedMalwareFiles."""

    last_created: Optional[str] = field(
        default=None, metadata=config(field_name="last_created")
    )
    has_more: Optional[bool] = field(
        default=None, metadata=config(field_name="has_more")
    )
    files: Optional[List[TimsMalwareFile]] = field(
        default=None, metadata=config(field_name="files")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatReport:
    """ThreatReport."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    report_type: Optional[str] = field(
        default=None, metadata=config(field_name="reportType")
    )
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="reportID")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    published: Optional[str] = field(
        default=None, metadata=config(field_name="published")
    )
    category: Optional[str] = field(
        default=None, metadata=config(field_name="category")
    )
    threat_type: Optional[str] = field(
        default=None, metadata=config(field_name="threatType")
    )
    threat_actor_type: Optional[List[str]] = field(
        default=None, metadata=config(field_name="threatActorType")
    )
    target_geography: Optional[List[str]] = field(
        default=None, metadata=config(field_name="targetGeography")
    )
    target_sectors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="targetSectors")
    )
    object_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="object_refs")
    )
    content: Optional[str] = field(default=None, metadata=config(field_name="content"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    group_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupTag")
    )
    malware_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="malwareTag")
    )
    vid_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="vidTag")
    )
    report_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reportTag")
    )
    country_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="countryTag")
    )
    cve_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="cveTag")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIdentityInput:
    """ThreatIdentityInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    roles: Optional[List[str]] = field(
        default=None, metadata=config(field_name="roles")
    )
    contact_information: Optional[str] = field(
        default=None, metadata=config(field_name="contact_information")
    )
    natural_key: Optional[str] = field(
        default=None, metadata=config(field_name="natural_key")
    )
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="download_URL")
    )
    internal: Optional[bool] = field(
        default=None, metadata=config(field_name="internal")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    reason: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reason")
    )
    identity_class: Optional[Union[ThreatIdentityClass, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIdentityClass, x),
            field_name="identity_class",
        ),
    )
    sectors: Optional[List[Union[ThreatIndustrySectors, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIndustrySectors, x),
            field_name="sectors",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatWhereInput:
    """ThreatWhereInput."""

    threat_group: Optional[str] = field(
        default=None, metadata=config(field_name="threatGroup")
    )
    threat_group_contains: Optional[str] = field(
        default=None, metadata=config(field_name="threatGroup_contains")
    )
    malware: Optional[str] = field(default=None, metadata=config(field_name="malware"))
    malware_contains: Optional[str] = field(
        default=None, metadata=config(field_name="malware_contains")
    )
    cve: Optional[str] = field(default=None, metadata=config(field_name="cve"))
    cve_contains: Optional[str] = field(
        default=None, metadata=config(field_name="cve_contains")
    )
    target_sectors_group: Optional[str] = field(
        default=None, metadata=config(field_name="targetSectorsGroup")
    )
    target_sectors_group_contains: Optional[str] = field(
        default=None, metadata=config(field_name="targetSectorsGroup_contains")
    )
    target_sectors_report: Optional[str] = field(
        default=None, metadata=config(field_name="targetSectorsReport")
    )
    target_sectors_report_contains: Optional[str] = field(
        default=None, metadata=config(field_name="targetSectorsReport_contains")
    )
    motivation: Optional[str] = field(
        default=None, metadata=config(field_name="motivation")
    )
    motivation_contains: Optional[str] = field(
        default=None, metadata=config(field_name="motivation_contains")
    )
    region: Optional[str] = field(default=None, metadata=config(field_name="region"))
    region_contains: Optional[str] = field(
        default=None, metadata=config(field_name="region_contains")
    )
    target_geography_group: Optional[str] = field(
        default=None, metadata=config(field_name="targetGeographyGroup")
    )
    target_geography_group_contains: Optional[str] = field(
        default=None, metadata=config(field_name="targetGeographyGroup_contains")
    )
    target_geography_report: Optional[str] = field(
        default=None, metadata=config(field_name="targetGeographyReport")
    )
    target_geography_report_contains: Optional[str] = field(
        default=None, metadata=config(field_name="targetGeographyReport_contains")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    type_contains: Optional[str] = field(
        default=None, metadata=config(field_name="type_contains")
    )
    category: Optional[str] = field(
        default=None, metadata=config(field_name="category")
    )
    category_contains: Optional[str] = field(
        default=None, metadata=config(field_name="category_contains")
    )
    threat_type: Optional[str] = field(
        default=None, metadata=config(field_name="threatType")
    )
    threat_type_contains: Optional[str] = field(
        default=None, metadata=config(field_name="threatType_contains")
    )
    threat_actor_type: Optional[str] = field(
        default=None, metadata=config(field_name="threatActorType")
    )
    threat_actor_type_contains: Optional[str] = field(
        default=None, metadata=config(field_name="threatActorType_contains")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    status_contains: Optional[str] = field(
        default=None, metadata=config(field_name="status_contains")
    )
    objectives: Optional[str] = field(
        default=None, metadata=config(field_name="objectives")
    )
    objectives_contains: Optional[str] = field(
        default=None, metadata=config(field_name="objectives_contains")
    )
    country: Optional[str] = field(default=None, metadata=config(field_name="country"))
    country_contains: Optional[str] = field(
        default=None, metadata=config(field_name="country_contains")
    )
    vid: Optional[str] = field(default=None, metadata=config(field_name="vid"))
    vid_contains: Optional[str] = field(
        default=None, metadata=config(field_name="vid_contains")
    )
    aliases: Optional[str] = field(default=None, metadata=config(field_name="aliases"))
    aliases_contains: Optional[str] = field(
        default=None, metadata=config(field_name="aliases_contains")
    )
    thematic_area: Optional[str] = field(
        default=None, metadata=config(field_name="thematicArea")
    )
    thematic_area_contains: Optional[str] = field(
        default=None, metadata=config(field_name="thematicArea_contains")
    )
    tips: Optional[str] = field(default=None, metadata=config(field_name="tips"))
    tips_contains: Optional[str] = field(
        default=None, metadata=config(field_name="tips_contains")
    )
    ta: Optional[str] = field(default=None, metadata=config(field_name="ta"))
    ta_contains: Optional[str] = field(
        default=None, metadata=config(field_name="ta_contains")
    )
    ca: Optional[str] = field(default=None, metadata=config(field_name="ca"))
    ca_contains: Optional[str] = field(
        default=None, metadata=config(field_name="ca_contains")
    )
    tools: Optional[str] = field(default=None, metadata=config(field_name="tools"))
    tools_contains: Optional[str] = field(
        default=None, metadata=config(field_name="tools_contains")
    )
    report_type: Optional[str] = field(
        default=None, metadata=config(field_name="reportType")
    )
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="reportID")
    )
    report_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="reportID_contains")
    )
    and_: Optional[List["ThreatWhereInput"]] = field(
        default=None, metadata=config(field_name="and")
    )
    or_: Optional[List["ThreatWhereInput"]] = field(
        default=None, metadata=config(field_name="or")
    )
    not_: Optional["ThreatWhereInput"] = field(
        default=None, metadata=config(field_name="not")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatVid:
    """ThreatVid."""

    id: Optional[str] = field(default=None, metadata=config(field_name="ID"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    swids: Optional[List[ThreatSwid]] = field(
        default=None, metadata=config(field_name="Swids")
    )
    threat_analyses: Optional[List[ThreatAnalysis]] = field(
        default=None, metadata=config(field_name="ThreatAnalyses")
    )
    threat_groups: Optional[List[ThreatGroup]] = field(
        default=None, metadata=config(field_name="ThreatGroups")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class XdrEventFilter:
    """XdrEventFilter."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    id_string: Optional[str] = field(
        default=None, metadata=config(field_name="id_string")
    )
    event_type: Optional[str] = field(
        default=None, metadata=config(field_name="event_type")
    )
    visibility: Optional[str] = field(
        default=None, metadata=config(field_name="visibility")
    )
    result_visibility: Optional[str] = field(
        default=None, metadata=config(field_name="result_visibility")
    )
    severity_float: Optional[float] = field(
        default=None, metadata=config(field_name="severity_float")
    )
    confidence_float: Optional[float] = field(
        default=None, metadata=config(field_name="confidence_float")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    create_alert: Optional[bool] = field(
        default=None, metadata=config(field_name="create_alert")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    related_attack: Optional[List[str]] = field(
        default=None, metadata=config(field_name="related_attack")
    )
    endpoint_platforms: Optional[List[str]] = field(
        default=None, metadata=config(field_name="endpoint_platforms")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )
    references_list: Optional[List[ReferenceList]] = field(
        default=None, metadata=config(field_name="references_list")
    )
    event_filters: Optional[List[EventFilter]] = field(
        default=None, metadata=config(field_name="event_filters")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIdentity:
    """ThreatIdentity."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    roles: Optional[List[str]] = field(
        default=None, metadata=config(field_name="roles")
    )
    contact_information: Optional[str] = field(
        default=None, metadata=config(field_name="contact_information")
    )
    natural_key: Optional[str] = field(
        default=None, metadata=config(field_name="natural_key")
    )
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="download_URL")
    )
    internal: Optional[bool] = field(
        default=None, metadata=config(field_name="internal")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    reason: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reason")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )
    identity_class: Optional[Union[ThreatIdentityClass, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIdentityClass, x),
            field_name="identity_class",
        ),
    )
    sectors: Optional[List[Union[ThreatIndustrySectors, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIndustrySectors, x),
            field_name="sectors",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatRelationshipInput:
    """ThreatRelationshipInput."""

    source_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="source_sharing_id")
    )
    target_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="target_sharing_id")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    src_desc: Optional[str] = field(
        default=None, metadata=config(field_name="src_desc")
    )
    tgt_desc: Optional[str] = field(
        default=None, metadata=config(field_name="tgt_desc")
    )
    mitre_attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mitre_attack_categories")
    )
    source_ref: Optional[str] = field(
        default=None, metadata=config(field_name="source_ref")
    )
    target_ref: Optional[str] = field(
        default=None, metadata=config(field_name="target_ref")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    source_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="source_internal")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="reference")
    )
    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="start_time")
    )
    stop_time: Optional[str] = field(
        default=None, metadata=config(field_name="stop_time")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )
    relationship_type: Optional[Union[ThreatRelationshipType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatRelationshipType, x),
            field_name="relationship_type",
        ),
    )
    indicator_class: Optional[Union[ThreatIndicatorClass, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIndicatorClass, x),
            field_name="indicator_class",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatRelationship:
    """ThreatRelationship."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    source_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="source_sharing_id")
    )
    target_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="target_sharing_id")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    src_desc: Optional[str] = field(
        default=None, metadata=config(field_name="src_desc")
    )
    tgt_desc: Optional[str] = field(
        default=None, metadata=config(field_name="tgt_desc")
    )
    mitre_attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mitre_attack_categories")
    )
    source_ref: Optional[str] = field(
        default=None, metadata=config(field_name="source_ref")
    )
    target_ref: Optional[str] = field(
        default=None, metadata=config(field_name="target_ref")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="start_time")
    )
    stop_time: Optional[str] = field(
        default=None, metadata=config(field_name="stop_time")
    )
    source_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="source_internal")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="reference")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )
    relationship_type: Optional[Union[ThreatRelationshipType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatRelationshipType, x),
            field_name="relationship_type",
        ),
    )
    indicator_class: Optional[Union[ThreatIndicatorClass, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIndicatorClass, x),
            field_name="indicator_class",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIndicatorInput:
    """ThreatIndicatorInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    pattern_version: Optional[str] = field(
        default=None, metadata=config(field_name="pattern_version")
    )
    valid_from: Optional[str] = field(
        default=None, metadata=config(field_name="valid_from")
    )
    valid_until: Optional[str] = field(
        default=None, metadata=config(field_name="valid_until")
    )
    score: Optional[int] = field(default=None, metadata=config(field_name="score"))
    indicator_types: Optional[List[Union[ThreatIndicatorType, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIndicatorType, x),
            field_name="indicator_types",
        ),
    )
    pattern_type: Optional[Union[ThreatPatternType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatPatternType, x),
            field_name="pattern_type",
        ),
    )
    kill_chain_phases: Optional[List[ThreatKillChainPhaseInput]] = field(
        default=None, metadata=config(field_name="kill_chain_phases")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatMalware:
    """ThreatMalware."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    family: Optional[str] = field(default=None, metadata=config(field_name="family"))
    aliases: Optional[List[str]] = field(
        default=None, metadata=config(field_name="aliases")
    )
    first_seen: Optional[str] = field(
        default=None, metadata=config(field_name="first_seen")
    )
    last_seen: Optional[str] = field(
        default=None, metadata=config(field_name="last_seen")
    )
    operating_system_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="operating_system_refs")
    )
    sample_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sample_refs")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    public_summary: Optional[str] = field(
        default=None, metadata=config(field_name="public_summary")
    )
    solution: Optional[str] = field(
        default=None, metadata=config(field_name="solution")
    )
    technical_details: Optional[str] = field(
        default=None, metadata=config(field_name="technical_details")
    )
    group_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupTag")
    )
    malware_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="malwareTag")
    )
    vid_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="vidTag")
    )
    report_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reportTag")
    )
    country_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="countryTag")
    )
    cve_tag: Optional[List[str]] = field(
        default=None, metadata=config(field_name="cveTag")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )
    malware_types: Optional[List[Union[ThreatMalwareType, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatMalwareType, x),
            field_name="malware_types",
        ),
    )
    kill_chain_phases: Optional[List[ThreatKillChainPhase]] = field(
        default=None, metadata=config(field_name="kill_chain_phases")
    )
    architecture_execution_envs: Optional[
        List[Union[ThreatArchitectureExecutionEnvs, TaegisEnum]]
    ] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatArchitectureExecutionEnvs, x),
            field_name="architecture_execution_envs",
        ),
    )
    implementation_languages: Optional[
        List[Union[ThreatImplementationLanguages, TaegisEnum]]
    ] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatImplementationLanguages, x),
            field_name="implementation_languages",
        ),
    )
    capabilities: Optional[List[Union[ThreatCapabilities, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatCapabilities, x),
            field_name="capabilities",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIndicator:
    """ThreatIndicator."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    pattern_version: Optional[str] = field(
        default=None, metadata=config(field_name="pattern_version")
    )
    mitre_attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mitre_attack_categories")
    )
    valid_from: Optional[str] = field(
        default=None, metadata=config(field_name="valid_from")
    )
    valid_until: Optional[str] = field(
        default=None, metadata=config(field_name="valid_until")
    )
    score: Optional[int] = field(default=None, metadata=config(field_name="score"))
    original_indicator: Optional[str] = field(
        default=None, metadata=config(field_name="original_indicator")
    )
    ipv4: Optional[str] = field(default=None, metadata=config(field_name="ipv4"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    no_results: Optional[bool] = field(
        default=None, metadata=config(field_name="noResults")
    )
    type: Optional[Union[ThreatObjectType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatObjectType, x),
            field_name="type",
        ),
    )
    indicator_types: Optional[List[Union[ThreatIndicatorType, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIndicatorType, x),
            field_name="indicator_types",
        ),
    )
    pattern_type: Optional[Union[ThreatPatternType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatPatternType, x),
            field_name="pattern_type",
        ),
    )
    kill_chain_phases: Optional[List[ThreatKillChainPhase]] = field(
        default=None, metadata=config(field_name="kill_chain_phases")
    )
    indicator_class: Optional[Union[ThreatIndicatorClass, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatIndicatorClass, x),
            field_name="indicator_class",
        ),
    )
    dns: Optional[ThreatDNSInfo] = field(
        default=None, metadata=config(field_name="dns")
    )
    whois: Optional[ThreatWhois] = field(
        default=None, metadata=config(field_name="whois")
    )
    url_info: Optional[ThreatURLInfo] = field(
        default=None, metadata=config(field_name="url_info")
    )
    location: Optional[ThreatLocation] = field(
        default=None, metadata=config(field_name="location")
    )


ThreatResult = Union[
    ThreatIdentity,
    ThreatIndicator,
    ThreatMalware,
    ThreatRelationship,
]


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatFilter:
    """ThreatFilter."""

    where: Optional[ThreatWhereInput] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIdentityRelationship:
    """ThreatIdentityRelationship."""

    identity: Optional[ThreatIdentity] = field(
        default=None, metadata=config(field_name="identity")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatReportRelationship:
    """ThreatReportRelationship."""

    report: Optional[ThreatReport] = field(
        default=None, metadata=config(field_name="report")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatMalwareRelationship:
    """ThreatMalwareRelationship."""

    malware: Optional[ThreatMalware] = field(
        default=None, metadata=config(field_name="malware")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatGroupRelationship:
    """ThreatGroupRelationship."""

    group: Optional[ThreatGroup] = field(
        default=None, metadata=config(field_name="group")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatObjectIntelligence:
    """ThreatObjectIntelligence."""

    malwares: Optional[List[ThreatMalware]] = field(
        default=None, metadata=config(field_name="malwares")
    )
    groups: Optional[List[ThreatGroup]] = field(
        default=None, metadata=config(field_name="groups")
    )
    reports: Optional[List[ThreatReport]] = field(
        default=None, metadata=config(field_name="reports")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatVidIntelligence:
    """ThreatVidIntelligence."""

    vid: Optional[str] = field(default=None, metadata=config(field_name="vid"))
    reports: Optional[List[ThreatReportRelationship]] = field(
        default=None, metadata=config(field_name="reports")
    )
    malware: Optional[List[ThreatMalwareRelationship]] = field(
        default=None, metadata=config(field_name="malware")
    )
    groups: Optional[List[ThreatGroupRelationship]] = field(
        default=None, metadata=config(field_name="groups")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatMalwareIntelligence:
    """ThreatMalwareIntelligence."""

    malware: Optional[ThreatMalware] = field(
        default=None, metadata=config(field_name="malware")
    )
    groups: Optional[List[ThreatGroup]] = field(
        default=None, metadata=config(field_name="groups")
    )
    reports: Optional[List[ThreatReport]] = field(
        default=None, metadata=config(field_name="reports")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIndicatorIntelligence:
    """ThreatIndicatorIntelligence."""

    indicator: Optional[ThreatIndicator] = field(
        default=None, metadata=config(field_name="indicator")
    )
    identities: Optional[List[ThreatIdentityRelationship]] = field(
        default=None, metadata=config(field_name="identities")
    )
    reports: Optional[List[ThreatReportRelationship]] = field(
        default=None, metadata=config(field_name="reports")
    )
    malware: Optional[List[ThreatMalwareRelationship]] = field(
        default=None, metadata=config(field_name="malware")
    )
    groups: Optional[List[ThreatGroupRelationship]] = field(
        default=None, metadata=config(field_name="groups")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIntelligence:
    """ThreatIntelligence."""

    total_results: Optional[int] = field(
        default=None, metadata=config(field_name="total_results")
    )
    intel: Optional[ThreatObjectIntelligence] = field(
        default=None, metadata=config(field_name="intel")
    )
    threat_object_type: Optional[Union[ThreatFacetObject, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ThreatFacetObject, x),
            field_name="threatObjectType",
        ),
    )
