# coding: utf-8

"""
    trivium-cash

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.2.11
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from trivium_python_sdk.models.account_status import AccountStatus
from trivium_python_sdk.models.account_type import AccountType
from trivium_python_sdk.models.balance import Balance
from trivium_python_sdk.models.deposit_instructions import DepositInstructions
from trivium_python_sdk.models.earnings_to_date import EarningsToDate
from trivium_python_sdk.models.provider_details import ProviderDetails
from typing import Optional, Set
from typing_extensions import Self

class Account(BaseModel):
    """
    Account
    """ # noqa: E501
    account_id: StrictStr = Field(alias="accountId")
    account_type: AccountType = Field(alias="accountType")
    currency_code: StrictStr = Field(alias="currencyCode")
    status: AccountStatus
    provider: ProviderDetails
    earnings_to_date: EarningsToDate = Field(alias="earningsToDate")
    balance: Balance
    deposit_instructions: DepositInstructions = Field(alias="depositInstructions")
    __properties: ClassVar[List[str]] = ["accountId", "accountType", "currencyCode", "status", "provider", "earningsToDate", "balance", "depositInstructions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Account from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of earnings_to_date
        if self.earnings_to_date:
            _dict['earningsToDate'] = self.earnings_to_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance
        if self.balance:
            _dict['balance'] = self.balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deposit_instructions
        if self.deposit_instructions:
            _dict['depositInstructions'] = self.deposit_instructions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Account from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "accountType": obj.get("accountType"),
            "currencyCode": obj.get("currencyCode"),
            "status": obj.get("status"),
            "provider": ProviderDetails.from_dict(obj["provider"]) if obj.get("provider") is not None else None,
            "earningsToDate": EarningsToDate.from_dict(obj["earningsToDate"]) if obj.get("earningsToDate") is not None else None,
            "balance": Balance.from_dict(obj["balance"]) if obj.get("balance") is not None else None,
            "depositInstructions": DepositInstructions.from_dict(obj["depositInstructions"]) if obj.get("depositInstructions") is not None else None
        })
        return _obj


