# coding: utf-8

"""
    trivium-cash

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.2.11
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trivium_python_sdk.models.account_status import AccountStatus
from trivium_python_sdk.models.bank_account_details import BankAccountDetails
from trivium_python_sdk.models.provider_details import ProviderDetails
from typing import Optional, Set
from typing_extensions import Self

class PaymentsAccount(BaseModel):
    """
    PaymentsAccount
    """ # noqa: E501
    account_id: StrictStr = Field(alias="accountId")
    currency_code: StrictStr = Field(alias="currencyCode")
    status: AccountStatus
    provider: ProviderDetails
    deposit_instructions: Optional[List[BankAccountDetails]] = Field(default=None, alias="depositInstructions")
    __properties: ClassVar[List[str]] = ["accountId", "currencyCode", "status", "provider", "depositInstructions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentsAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in deposit_instructions (list)
        _items = []
        if self.deposit_instructions:
            for _item_deposit_instructions in self.deposit_instructions:
                if _item_deposit_instructions:
                    _items.append(_item_deposit_instructions.to_dict())
            _dict['depositInstructions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentsAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "currencyCode": obj.get("currencyCode"),
            "status": obj.get("status"),
            "provider": ProviderDetails.from_dict(obj["provider"]) if obj.get("provider") is not None else None,
            "depositInstructions": [BankAccountDetails.from_dict(_item) for _item in obj["depositInstructions"]] if obj.get("depositInstructions") is not None else None
        })
        return _obj


