# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-03-30 15:37
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Job',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('run_id', models.CharField(blank=True, max_length=256)),
                ('phase', models.PositiveSmallIntegerField(choices=[(1, 'PENDING'), (2, 'QUEUED'), (3, 'EXECUTING'), (4, 'COMPLETED'), (5, 'ERROR'), (6, 'ABORTED'), (7, 'UNKNOWN'), (8, 'HELD'), (9, 'SUSPENDED'), (10, 'ARCHIVED')])),
                ('start_time', models.DateTimeField(blank=True, null=True)),
                ('end_time', models.DateTimeField(blank=True, null=True)),
                ('execution_duration', models.PositiveIntegerField(blank=True, null=True)),
                ('destruction_time', models.DateTimeField(blank=True, null=True)),
                ('job_type', models.PositiveSmallIntegerField(choices=[(1, 'Query')])),
                ('owner', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('start_time',),
                'verbose_name': 'Job',
                'verbose_name_plural': 'Jobs',
                'permissions': (('view_job', 'Can view Job'),),
            },
        ),
    ]
