# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-07-05 10:19
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Column',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, null=True)),
                ('name', models.CharField(max_length=256)),
                ('description', models.TextField(blank=True, null=True)),
                ('unit', models.CharField(blank=True, max_length=256, null=True)),
                ('ucd', models.CharField(blank=True, max_length=256, null=True)),
                ('utype', models.CharField(blank=True, max_length=256, null=True)),
                ('datatype', models.CharField(blank=True, max_length=256, null=True)),
                ('size', models.IntegerField(blank=True, help_text='The length of variable length datatypes, e.g. varchar(256).', null=True)),
                ('principal', models.BooleanField(default=False, help_text='This column is considered a core part of the content.')),
                ('indexed', models.BooleanField(default=False, help_text='This column is indexed.')),
                ('std', models.BooleanField(default=False, help_text='This column is defined by some standard.')),
            ],
            options={
                'ordering': ('table__database__order', 'table__order', 'order'),
                'permissions': (('view_column', 'Can view Column'),),
                'verbose_name_plural': 'Columns',
                'verbose_name': 'Column',
            },
        ),
        migrations.CreateModel(
            name='Database',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, null=True)),
                ('name', models.CharField(max_length=256)),
                ('description', models.TextField(blank=True, null=True)),
                ('utype', models.CharField(blank=True, max_length=256, null=True)),
            ],
            options={
                'ordering': ('order',),
                'permissions': (('view_database', 'Can view Database'),),
                'verbose_name_plural': 'Databases',
                'verbose_name': 'Database',
            },
        ),
        migrations.CreateModel(
            name='Function',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, null=True)),
                ('name', models.CharField(max_length=256)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'ordering': ('order',),
                'permissions': (('view_function', 'Can view Function'),),
                'verbose_name_plural': 'Functions',
                'verbose_name': 'Function',
            },
        ),
        migrations.CreateModel(
            name='Table',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(blank=True, null=True)),
                ('name', models.CharField(max_length=256)),
                ('description', models.TextField(blank=True, null=True)),
                ('type', models.CharField(choices=[('table', 'Table'), ('view', 'View')], max_length=8)),
                ('utype', models.CharField(blank=True, max_length=256, null=True)),
                ('database', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tables', to='daiquiri_metadata.Database')),
            ],
            options={
                'ordering': ('database__order', 'order'),
                'permissions': (('view_table', 'Can view Table'),),
                'verbose_name_plural': 'Tables',
                'verbose_name': 'Table',
            },
        ),
        migrations.AddField(
            model_name='column',
            name='table',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='columns', to='daiquiri_metadata.Table'),
        ),
    ]
