# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-02-16 17:22
from __future__ import unicode_literals
from django.conf import settings

from django.db import migrations, models, connection


def fix_index_name(apps, schema_editor):
    # fix wrong primary key index and sequence name since
    # django does not do it correctly
    # see https://code.djangoproject.com/ticket/23577

    if settings.DATABASES['default']['ENGINE'] == 'django.db.backends.postgresql':
        with connection.cursor() as cursor:
            cursor.execute('ALTER INDEX daiquiri_metadata_database_pkey RENAME TO daiquiri_metadata_schema_pkey;')
            cursor.execute('ALTER SEQUENCE daiquiri_metadata_database_id_seq RENAME TO daiquiri_metadata_schema_id_seq;')


class Migration(migrations.Migration):

    dependencies = [
        ('daiquiri_metadata', '0016_rename_database_to_schema'),
    ]

    operations = [
        migrations.RenameModel(
            old_name='Database',
            new_name='Schema',
        ),
        migrations.AlterModelOptions(
            name='schema',
            options={'ordering': ('order',), 'permissions': (('view_schema', 'Can view Schema'),), 'verbose_name': 'Schema', 'verbose_name_plural': 'Schemas'},
        ),
        migrations.RunPython(fix_index_name)
    ]
