from typing import Dict, Tuple

from colorpedia.hexcodes import HEX_CODE_TO_NAMES

PALETTES: Dict[str, Tuple[str, ...]] = {
    "red": (
        "FFA07A",
        "FA8072",
        "E9967A",
        "F08080",
        "CD5C5C",
        "DC143C",
        "B22222",
        "FF0000",
        "8B0000",
    ),
    "orange": ("FF7F50", "FF6347", "FF4500", "FFD700", "FFA500", "FF8C00"),
    "yellow": (
        "FFFFE0",
        "FFFACD",
        "FAFAD2",
        "FFEFD5",
        "FFE4B5",
        "FFDAB9",
        "EEE8AA",
        "F0E68C",
        "BDB76B",
        "FFFF00",
    ),
    "green": (
        "7CFC00",
        "7FFF00",
        "32CD32",
        "00FF00",
        "228B22",
        "008000",
        "006400",
        "ADFF2F",
        "9ACD32",
        "00FF7F",
        "00FA9A",
        "90EE90",
        "98FB98",
        "8FBC8F",
        "3CB371",
        "2E8B57",
        "808000",
        "556B2F",
        "6B8E23",
    ),
    "cyan": (
        "E0FFFF",
        "00FFFF",
        "7FFFD4",
        "66CDAA",
        "AFEEEE",
        "40E0D0",
        "48D1CC",
        "00CED1",
        "20B2AA",
        "5F9EA0",
        "008B8B",
        "008080",
    ),
    "blue": (
        "B0E0E6",
        "ADD8E6",
        "87CEFA",
        "87CEEB",
        "00BFFF",
        "B0C4DE",
        "1E90FF",
        "6495ED",
        "4682B4",
        "4169E1",
        "0000FF",
        "0000CD",
        "00008B",
        "000080",
        "191970",
        "7B68EE",
        "6A5ACD",
        "483D8B",
    ),
    "purple": (
        "E6E6FA",
        "D8BFD8",
        "DDA0DD",
        "EE82EE",
        "DA70D6",
        "FF00FF",
        "BA55D3",
        "9370DB",
        "8A2BE2",
        "9400D3",
        "9932CC",
        "8B008B",
        "800080",
        "4B0082",
    ),
    "pink": ("FFC0CB", "FFB6C1", "FF69B4", "FF1493", "DB7093", "C71585"),
    "white": (
        "FFFFFF",
        "FFFAFA",
        "F0FFF0",
        "F5FFFA",
        "F0FFFF",
        "F0F8FF",
        "F8F8FF",
        "F5F5F5",
        "FFF5EE",
        "F5F5DC",
        "FDF5E6",
        "FFFAF0",
        "FFFFF0",
        "FAEBD7",
        "FAF0E6",
        "FFF0F5",
        "FFE4E1",
    ),
    "gray": (
        "DCDCDC",
        "D3D3D3",
        "C0C0C0",
        "A9A9A9",
        "808080",
        "696969",
        "778899",
        "708090",
        "2F4F4F",
        "000000",
    ),
    "grey": (
        "DCDCDC",
        "D3D3D3",
        "C0C0C0",
        "A9A9A9",
        "808080",
        "696969",
        "778899",
        "708090",
        "2F4F4F",
        "000000",
    ),
    "brown": (
        "FFF8DC",
        "FFEBCD",
        "FFE4C4",
        "FFDEAD",
        "F5DEB3",
        "DEB887",
        "D2B48C",
        "BC8F8F",
        "F4A460",
        "DAA520",
        "CD853F",
        "D2691E",
        "8B4513",
        "A0522D",
        "A52A2A",
        "800000",
    ),
    "amazon": ("FFFFFF", "FF9900", "232F3E", "000000"),
    "apple": ("000000", "A3AAAE", "F9F6EF"),
    "boynton": (
        "0000FF",
        "FF0000",
        "00FF00",
        "FFFF00",
        "FF00FF",
        "FF8080",
        "808080",
        "800000",
        "FF8000",
    ),
    "cappuccino": ("4B3832", "854442", "FFF4E6", "3C2F2F", "BE9B7B"),
    "darcula": (
        "282A36",
        "44475A",
        "F8F8F2",
        "6272A4",
        "8BE9FD",
        "50FA7B",
        "FFB86C",
        "FF79C6",
        "BD93F9",
        "FF5555",
        "F1FA8C",
    ),
    "facebook": ("3B5998", "8B9DC3", "DFE3EE", "F7F7F7", "FFFFFF"),
    "github": (
        "4078C0",
        "6CC644",
        "BD2C00",
        "C9510C",
        "6E5494",
        "FAFAFA",
        "F5F5F5",
        "333333",
    ),
    "google": ("4285F4", "DB4437", "F4B400", "0F9D58"),
    "kelly": (
        "FFB300",
        "803E75",
        "FF6800",
        "A6BDD7",
        "C10020",
        "CEA262",
        "817066",
        "007D34",
        "F6768E",
        "00538A",
        "FF7A5C",
        "53377A",
        "FF8E00",
        "B32851",
        "F4C800",
        "7F180D",
        "93AA00",
        "593315",
        "F13A13",
        "232C16",
    ),
    "microsoft": ("F25022", "7FBA00", "00A4EF", "FFB900", "737373"),
    "molokai": (
        "2E2E2E",
        "F8F8F2",
        "75715E",
        "F92672",
        "FD971F",
        "E69F66",
        "E6DB74",
        "A6E22E",
        "66D9EF",
        "AE81FF",
    ),
    "monokai": (
        "2E2E2E",
        "F8F8F2",
        "75715E",
        "F92672",
        "FD971F",
        "E69F66",
        "E6DB74",
        "A6E22E",
        "66D9EF",
        "AE81FF",
    ),
    "pastel": ("E1F7D5", "FFBDBD", "C9C9FF", "FFFFFF", "F1CBFF"),
    "rainbow": (
        "9400D3",
        "4B0082",
        "0000FF",
        "00FF00",
        "FFFF00",
        "FFA500",
        "FF0000",
    ),
    "solarized": (
        "002B36",
        "073642",
        "586E75",
        "657B83",
        "839496",
        "93A1A1",
        "EEE8D5",
        "FDF6E3",
        "B58900",
        "CB4B16",
        "DC322F",
        "D33682",
        "6C71C4",
        "268BD2",
        "2AA198",
        "859900",
    ),
    "tomorrow": (
        "1D1F21",
        "282A2E",
        "373B41",
        "C5C8C6",
        "969896",
        "CC6666",
        "DE935F",
        "F0C674",
        "B5BD68",
        "8ABEB7",
        "81A2BE",
        "B294BB",
    ),
    "zenburn": ("3F3F3F", "8FAF9F", "DCA3A3", "F0DFAF", "EFEFEF"),
}
PALETTES["aqua"] = PALETTES["cyan"]
PALETTES["css3"] = tuple(HEX_CODE_TO_NAMES.keys())
