"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Servicecatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [servicecatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservicecatalog.html).
 *
 * @experimental
 */
class Servicecatalog extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [servicecatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservicecatalog.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'servicecatalog';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AcceptPortfolioShare",
                "AssociateAttributeGroup",
                "AssociateBudgetWithResource",
                "AssociatePrincipalWithPortfolio",
                "AssociateProductWithPortfolio",
                "AssociateResource",
                "AssociateServiceActionWithProvisioningArtifact",
                "AssociateTagOptionWithResource",
                "BatchAssociateServiceActionWithProvisioningArtifact",
                "BatchDisassociateServiceActionFromProvisioningArtifact",
                "CopyProduct",
                "CreateApplication",
                "CreateAttributeGroup",
                "CreateConstraint",
                "CreatePortfolio",
                "CreateProduct",
                "CreateProvisionedProductPlan",
                "CreateProvisioningArtifact",
                "CreateServiceAction",
                "CreateTagOption",
                "DeleteApplication",
                "DeleteAttributeGroup",
                "DeleteConstraint",
                "DeletePortfolio",
                "DeleteProduct",
                "DeleteProvisionedProductPlan",
                "DeleteProvisioningArtifact",
                "DeleteServiceAction",
                "DeleteTagOption",
                "DisableAWSOrganizationsAccess",
                "DisassociateAttributeGroup",
                "DisassociateBudgetFromResource",
                "DisassociatePrincipalFromPortfolio",
                "DisassociateProductFromPortfolio",
                "DisassociateResource",
                "DisassociateServiceActionFromProvisioningArtifact",
                "DisassociateTagOptionFromResource",
                "EnableAWSOrganizationsAccess",
                "ExecuteProvisionedProductPlan",
                "ExecuteProvisionedProductServiceAction",
                "ImportAsProvisionedProduct",
                "ProvisionProduct",
                "RejectPortfolioShare",
                "SyncResource",
                "TerminateProvisionedProduct",
                "UpdateApplication",
                "UpdateAttributeGroup",
                "UpdateConstraint",
                "UpdatePortfolio",
                "UpdateProduct",
                "UpdateProvisionedProduct",
                "UpdateProvisionedProductProperties",
                "UpdateProvisioningArtifact",
                "UpdateServiceAction",
                "UpdateTagOption"
            ],
            "Permissions management": [
                "CreatePortfolioShare",
                "DeletePortfolioShare"
            ],
            "Read": [
                "DescribeConstraint",
                "DescribeCopyProductStatus",
                "DescribePortfolio",
                "DescribePortfolioShareStatus",
                "DescribeProduct",
                "DescribeProductAsAdmin",
                "DescribeProductView",
                "DescribeProvisionedProduct",
                "DescribeProvisionedProductPlan",
                "DescribeProvisioningArtifact",
                "DescribeProvisioningParameters",
                "DescribeRecord",
                "DescribeServiceAction",
                "DescribeServiceActionExecutionParameters",
                "DescribeTagOption",
                "GetAWSOrganizationsAccessStatus",
                "GetApplication",
                "GetAttributeGroup"
            ],
            "List": [
                "ListAcceptedPortfolioShares",
                "ListApplications",
                "ListAssociatedAttributeGroups",
                "ListAssociatedResources",
                "ListAttributeGroups",
                "ListBudgetsForResource",
                "ListConstraintsForPortfolio",
                "ListLaunchPaths",
                "ListOrganizationPortfolioAccess",
                "ListPortfolioAccess",
                "ListPortfolios",
                "ListPortfoliosForProduct",
                "ListPrincipalsForPortfolio",
                "ListProvisionedProductPlans",
                "ListProvisioningArtifacts",
                "ListProvisioningArtifactsForServiceAction",
                "ListRecordHistory",
                "ListResourcesForTagOption",
                "ListServiceActions",
                "ListServiceActionsForProvisioningArtifact",
                "ListStackInstancesForProvisionedProduct",
                "ListTagOptions",
                "ListTagsForResource",
                "ScanProvisionedProducts",
                "SearchProducts",
                "SearchProductsAsAdmin",
                "SearchProvisionedProducts"
            ],
            "Tagging": [
                "TagResource",
                "UntagResource"
            ]
        };
    }
    /**
     * (experimental) Grants permission to accept a portfolio that has been shared with you.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AcceptPortfolioShare.html
     *
     * @experimental
     */
    toAcceptPortfolioShare() {
        return this.to('AcceptPortfolioShare');
    }
    /**
     * (experimental) Grants permission to associate an attribute group with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_AssociateAttributeGroup.html
     *
     * @experimental
     */
    toAssociateAttributeGroup() {
        return this.to('AssociateAttributeGroup');
    }
    /**
     * (experimental) Grants permission to associate a budget with a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateBudgetWithResource.html
     *
     * @experimental
     */
    toAssociateBudgetWithResource() {
        return this.to('AssociateBudgetWithResource');
    }
    /**
     * (experimental) Grants permission to associate an IAM principal with a portfolio, giving the specified principal access to any products associated with the specified portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociatePrincipalWithPortfolio.html
     *
     * @experimental
     */
    toAssociatePrincipalWithPortfolio() {
        return this.to('AssociatePrincipalWithPortfolio');
    }
    /**
     * (experimental) Grants permission to associate a product with a portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateProductWithPortfolio.html
     *
     * @experimental
     */
    toAssociateProductWithPortfolio() {
        return this.to('AssociateProductWithPortfolio');
    }
    /**
     * (experimental) Grants permission to associate a resource with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_AssociateResource.html
     *
     * @experimental
     */
    toAssociateResource() {
        return this.to('AssociateResource');
    }
    /**
     * (experimental) Grants permission to associate an action with a provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateServiceActionWithProvisioningArtifact.html
     *
     * @experimental
     */
    toAssociateServiceActionWithProvisioningArtifact() {
        return this.to('AssociateServiceActionWithProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to associate the specified TagOption with the specified portfolio or product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateTagOptionWithResource.html
     *
     * @experimental
     */
    toAssociateTagOptionWithResource() {
        return this.to('AssociateTagOptionWithResource');
    }
    /**
     * (experimental) Grants permission to associate multiple self-service actions with provisioning artifacts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchAssociateServiceActionWithProvisioningArtifact.html
     *
     * @experimental
     */
    toBatchAssociateServiceActionWithProvisioningArtifact() {
        return this.to('BatchAssociateServiceActionWithProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to disassociate a batch of self-service actions from the specified provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchDisassociateServiceActionFromProvisioningArtifact.html
     *
     * @experimental
     */
    toBatchDisassociateServiceActionFromProvisioningArtifact() {
        return this.to('BatchDisassociateServiceActionFromProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to copy the specified source product to the specified target product or a new product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CopyProduct.html
     *
     * @experimental
     */
    toCopyProduct() {
        return this.to('CopyProduct');
    }
    /**
     * (experimental) Grants permission to create an application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateApplication.html
     *
     * @experimental
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * (experimental) Grants permission to create an attribute group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateAttributeGroup.html
     *
     * @experimental
     */
    toCreateAttributeGroup() {
        return this.to('CreateAttributeGroup');
    }
    /**
     * (experimental) Grants permission to create a constraint on an associated product and portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateConstraint.html
     *
     * @experimental
     */
    toCreateConstraint() {
        return this.to('CreateConstraint');
    }
    /**
     * (experimental) Grants permission to create a portfolio.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolio.html
     *
     * @experimental
     */
    toCreatePortfolio() {
        return this.to('CreatePortfolio');
    }
    /**
     * (experimental) Grants permission to share a portfolio you own with another AWS account.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolioShare.html
     *
     * @experimental
     */
    toCreatePortfolioShare() {
        return this.to('CreatePortfolioShare');
    }
    /**
     * (experimental) Grants permission to create a product and that product's first provisioning artifact.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html
     *
     * @experimental
     */
    toCreateProduct() {
        return this.to('CreateProduct');
    }
    /**
     * (experimental) Grants permission to add a new provisioned product plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisionedProductPlan.html
     *
     * @experimental
     */
    toCreateProvisionedProductPlan() {
        return this.to('CreateProvisionedProductPlan');
    }
    /**
     * (experimental) Grants permission to add a new provisioning artifact to an existing product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisioningArtifact.html
     *
     * @experimental
     */
    toCreateProvisioningArtifact() {
        return this.to('CreateProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to create a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateServiceAction.html
     *
     * @experimental
     */
    toCreateServiceAction() {
        return this.to('CreateServiceAction');
    }
    /**
     * (experimental) Grants permission to create a TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateTagOption.html
     *
     * @experimental
     */
    toCreateTagOption() {
        return this.to('CreateTagOption');
    }
    /**
     * (experimental) Grants permission to delete an application if all associations have been removed from the application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DeleteApplication.html
     *
     * @experimental
     */
    toDeleteApplication() {
        return this.to('DeleteApplication');
    }
    /**
     * (experimental) Grants permission to delete an attribute group if all associations have been removed from the attribute group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DeleteAttributeGroup.html
     *
     * @experimental
     */
    toDeleteAttributeGroup() {
        return this.to('DeleteAttributeGroup');
    }
    /**
     * (experimental) Grants permission to remove and delete an existing constraint from an associated product and portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteConstraint.html
     *
     * @experimental
     */
    toDeleteConstraint() {
        return this.to('DeleteConstraint');
    }
    /**
     * (experimental) Grants permission to delete a portfolio if all associations and shares have been removed from the portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolio.html
     *
     * @experimental
     */
    toDeletePortfolio() {
        return this.to('DeletePortfolio');
    }
    /**
     * (experimental) Grants permission to unshare a portfolio you own from an AWS account you previously shared the portfolio with.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolioShare.html
     *
     * @experimental
     */
    toDeletePortfolioShare() {
        return this.to('DeletePortfolioShare');
    }
    /**
     * (experimental) Grants permission to delete a product if all associations have been removed from the product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProduct.html
     *
     * @experimental
     */
    toDeleteProduct() {
        return this.to('DeleteProduct');
    }
    /**
     * (experimental) Grants permission to delete a provisioned product plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisionedProductPlan.html
     *
     * @experimental
     */
    toDeleteProvisionedProductPlan() {
        return this.to('DeleteProvisionedProductPlan');
    }
    /**
     * (experimental) Grants permission to delete a provisioning artifact from a product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisioningArtifact.html
     *
     * @experimental
     */
    toDeleteProvisioningArtifact() {
        return this.to('DeleteProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to delete a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteServiceAction.html
     *
     * @experimental
     */
    toDeleteServiceAction() {
        return this.to('DeleteServiceAction');
    }
    /**
     * (experimental) Grants permission to delete the specified TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteTagOption.html
     *
     * @experimental
     */
    toDeleteTagOption() {
        return this.to('DeleteTagOption');
    }
    /**
     * (experimental) Grants permission to describe a constraint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeConstraint.html
     *
     * @experimental
     */
    toDescribeConstraint() {
        return this.to('DescribeConstraint');
    }
    /**
     * (experimental) Grants permission to get the status of the specified copy product operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeCopyProductStatus.html
     *
     * @experimental
     */
    toDescribeCopyProductStatus() {
        return this.to('DescribeCopyProductStatus');
    }
    /**
     * (experimental) Grants permission to describe a portfolio.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolio.html
     *
     * @experimental
     */
    toDescribePortfolio() {
        return this.to('DescribePortfolio');
    }
    /**
     * (experimental) Grants permission to get the status of the specified portfolio share operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolioShareStatus.html
     *
     * @experimental
     */
    toDescribePortfolioShareStatus() {
        return this.to('DescribePortfolioShareStatus');
    }
    /**
     * (experimental) Grants permission to describe a product as an end-user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProduct.html
     *
     * @experimental
     */
    toDescribeProduct() {
        return this.to('DescribeProduct');
    }
    /**
     * (experimental) Grants permission to describe a product as an admin.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductAsAdmin.html
     *
     * @experimental
     */
    toDescribeProductAsAdmin() {
        return this.to('DescribeProductAsAdmin');
    }
    /**
     * (experimental) Grants permission to describe a product as an end-user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductView.html
     *
     * @experimental
     */
    toDescribeProductView() {
        return this.to('DescribeProductView');
    }
    /**
     * (experimental) Grants permission to describe a provisioned product.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProduct.html
     *
     * @experimental
     */
    toDescribeProvisionedProduct() {
        return this.to('DescribeProvisionedProduct');
    }
    /**
     * (experimental) Grants permission to describe a provisioned product plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProductPlan.html
     *
     * @experimental
     */
    toDescribeProvisionedProductPlan() {
        return this.to('DescribeProvisionedProductPlan');
    }
    /**
     * (experimental) Grants permission to describe a provisioning artifact.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningArtifact.html
     *
     * @experimental
     */
    toDescribeProvisioningArtifact() {
        return this.to('DescribeProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to describe the parameters that you need to specify to successfully provision a specified provisioning artifact.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningParameters.html
     *
     * @experimental
     */
    toDescribeProvisioningParameters() {
        return this.to('DescribeProvisioningParameters');
    }
    /**
     * (experimental) Grants permission to describe a record and lists any outputs.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeRecord.html
     *
     * @experimental
     */
    toDescribeRecord() {
        return this.to('DescribeRecord');
    }
    /**
     * (experimental) Grants permission to describe a self-service action.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceAction.html
     *
     * @experimental
     */
    toDescribeServiceAction() {
        return this.to('DescribeServiceAction');
    }
    /**
     * (experimental) Grants permission to get the default parameters if you executed the specified Service Action on the specified Provisioned Product.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceActionExecutionParameters.html
     *
     * @experimental
     */
    toDescribeServiceActionExecutionParameters() {
        return this.to('DescribeServiceActionExecutionParameters');
    }
    /**
     * (experimental) Grants permission to get information about the specified TagOption.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeTagOption.html
     *
     * @experimental
     */
    toDescribeTagOption() {
        return this.to('DescribeTagOption');
    }
    /**
     * (experimental) Grants permission to disable portfolio sharing through AWS Organizations feature.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisableAWSOrganizationsAccess.html
     *
     * @experimental
     */
    toDisableAWSOrganizationsAccess() {
        return this.to('DisableAWSOrganizationsAccess');
    }
    /**
     * (experimental) Grants permission to disassociate an attribute group from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DisassociateAttributeGroup.html
     *
     * @experimental
     */
    toDisassociateAttributeGroup() {
        return this.to('DisassociateAttributeGroup');
    }
    /**
     * (experimental) Grants permission to disassociate a budget from a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateBudgetFromResource.html
     *
     * @experimental
     */
    toDisassociateBudgetFromResource() {
        return this.to('DisassociateBudgetFromResource');
    }
    /**
     * (experimental) Grants permission to disassociate an IAM principal from a portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociatePrincipalFromPortfolio.html
     *
     * @experimental
     */
    toDisassociatePrincipalFromPortfolio() {
        return this.to('DisassociatePrincipalFromPortfolio');
    }
    /**
     * (experimental) Grants permission to disassociate a product from a portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateProductFromPortfolio.html
     *
     * @experimental
     */
    toDisassociateProductFromPortfolio() {
        return this.to('DisassociateProductFromPortfolio');
    }
    /**
     * (experimental) Grants permission to disassociate a resource from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DisassociateResource.html
     *
     * @experimental
     */
    toDisassociateResource() {
        return this.to('DisassociateResource');
    }
    /**
     * (experimental) Grants permission to disassociate the specified self-service action association from the specified provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateServiceActionFromProvisioningArtifact.html
     *
     * @experimental
     */
    toDisassociateServiceActionFromProvisioningArtifact() {
        return this.to('DisassociateServiceActionFromProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to disassociate the specified TagOption from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateTagOptionFromResource.html
     *
     * @experimental
     */
    toDisassociateTagOptionFromResource() {
        return this.to('DisassociateTagOptionFromResource');
    }
    /**
     * (experimental) Grants permission to enable portfolio sharing feature through AWS Organizations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_EnableAWSOrganizationsAccess.html
     *
     * @experimental
     */
    toEnableAWSOrganizationsAccess() {
        return this.to('EnableAWSOrganizationsAccess');
    }
    /**
     * (experimental) Grants permission to execute a provisioned product plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductPlan.html
     *
     * @experimental
     */
    toExecuteProvisionedProductPlan() {
        return this.to('ExecuteProvisionedProductPlan');
    }
    /**
     * (experimental) Grants permission to executes a provisioned product plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductServiceAction.html
     *
     * @experimental
     */
    toExecuteProvisionedProductServiceAction() {
        return this.to('ExecuteProvisionedProductServiceAction');
    }
    /**
     * (experimental) Grants permission to get the access status of AWS Organization portfolio share feature.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetAWSOrganizationsAccessStatus.html
     *
     * @experimental
     */
    toGetAWSOrganizationsAccessStatus() {
        return this.to('GetAWSOrganizationsAccessStatus');
    }
    /**
     * (experimental) Grants permission to get an application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_GetApplication.html
     *
     * @experimental
     */
    toGetApplication() {
        return this.to('GetApplication');
    }
    /**
     * (experimental) Grants permission to get an attribute group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_GetAttributeGroup.html
     *
     * @experimental
     */
    toGetAttributeGroup() {
        return this.to('GetAttributeGroup');
    }
    /**
     * (experimental) Grants permission to import a resource into a provisioned product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ImportAsProvisionedProduct.html
     *
     * @experimental
     */
    toImportAsProvisionedProduct() {
        return this.to('ImportAsProvisionedProduct');
    }
    /**
     * (experimental) Grants permission to list the portfolios that have been shared with you and you have accepted.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAcceptedPortfolioShares.html
     *
     * @experimental
     */
    toListAcceptedPortfolioShares() {
        return this.to('ListAcceptedPortfolioShares');
    }
    /**
     * (experimental) Grants permission to list the applications in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListApplications.html
     *
     * @experimental
     */
    toListApplications() {
        return this.to('ListApplications');
    }
    /**
     * (experimental) Grants permission to list the attribute groups associated with an application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListAssociatedAttributeGroups.html
     *
     * @experimental
     */
    toListAssociatedAttributeGroups() {
        return this.to('ListAssociatedAttributeGroups');
    }
    /**
     * (experimental) Grants permission to list the resources associated with an application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListAssociatedResources.html
     *
     * @experimental
     */
    toListAssociatedResources() {
        return this.to('ListAssociatedResources');
    }
    /**
     * (experimental) Grants permission to list the attribute groups in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListAttributeGroups.html
     *
     * @experimental
     */
    toListAttributeGroups() {
        return this.to('ListAttributeGroups');
    }
    /**
     * (experimental) Grants permission to list all the budgets associated to a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListBudgetsForResource.html
     *
     * @experimental
     */
    toListBudgetsForResource() {
        return this.to('ListBudgetsForResource');
    }
    /**
     * (experimental) Grants permission to list constraints associated with a given portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListConstraintsForPortfolio.html
     *
     * @experimental
     */
    toListConstraintsForPortfolio() {
        return this.to('ListConstraintsForPortfolio');
    }
    /**
     * (experimental) Grants permission to list the different ways to launch a given product as an end-user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html
     *
     * @experimental
     */
    toListLaunchPaths() {
        return this.to('ListLaunchPaths');
    }
    /**
     * (experimental) Grants permission to list the organization nodes that have access to the specified portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListOrganizationPortfolioAccess.html
     *
     * @experimental
     */
    toListOrganizationPortfolioAccess() {
        return this.to('ListOrganizationPortfolioAccess');
    }
    /**
     * (experimental) Grants permission to list the AWS accounts you have shared a given portfolio with.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolioAccess.html
     *
     * @experimental
     */
    toListPortfolioAccess() {
        return this.to('ListPortfolioAccess');
    }
    /**
     * (experimental) Grants permission to list the portfolios in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolios.html
     *
     * @experimental
     */
    toListPortfolios() {
        return this.to('ListPortfolios');
    }
    /**
     * (experimental) Grants permission to list the portfolios associated with a given product.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfoliosForProduct.html
     *
     * @experimental
     */
    toListPortfoliosForProduct() {
        return this.to('ListPortfoliosForProduct');
    }
    /**
     * (experimental) Grants permission to list the IAM principals associated with a given portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPrincipalsForPortfolio.html
     *
     * @experimental
     */
    toListPrincipalsForPortfolio() {
        return this.to('ListPrincipalsForPortfolio');
    }
    /**
     * (experimental) Grants permission to list the provisioned product plans.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisionedProductPlans.html
     *
     * @experimental
     */
    toListProvisionedProductPlans() {
        return this.to('ListProvisionedProductPlans');
    }
    /**
     * (experimental) Grants permission to list the provisioning artifacts associated with a given product.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifacts.html
     *
     * @experimental
     */
    toListProvisioningArtifacts() {
        return this.to('ListProvisioningArtifacts');
    }
    /**
     * (experimental) Grants permission to list all provisioning artifacts for the specified self-service action.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifactsForServiceAction.html
     *
     * @experimental
     */
    toListProvisioningArtifactsForServiceAction() {
        return this.to('ListProvisioningArtifactsForServiceAction');
    }
    /**
     * (experimental) Grants permission to list all the records in your account or all the records related to a given provisioned product.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListRecordHistory.html
     *
     * @experimental
     */
    toListRecordHistory() {
        return this.to('ListRecordHistory');
    }
    /**
     * (experimental) Grants permission to list the resources associated with the specified TagOption.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListResourcesForTagOption.html
     *
     * @experimental
     */
    toListResourcesForTagOption() {
        return this.to('ListResourcesForTagOption');
    }
    /**
     * (experimental) Grants permission to list all self-service actions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActions.html
     *
     * @experimental
     */
    toListServiceActions() {
        return this.to('ListServiceActions');
    }
    /**
     * (experimental) Grants permission to list all the service actions associated with the specified provisioning artifact in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActionsForProvisioningArtifact.html
     *
     * @experimental
     */
    toListServiceActionsForProvisioningArtifact() {
        return this.to('ListServiceActionsForProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to list account, region and status of each stack instances that are associated with a CFN_STACKSET type provisioned product.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListStackInstancesForProvisionedProduct.html
     *
     * @experimental
     */
    toListStackInstancesForProvisionedProduct() {
        return this.to('ListStackInstancesForProvisionedProduct');
    }
    /**
     * (experimental) Grants permission to list the specified TagOptions or all TagOptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListTagOptions.html
     *
     * @experimental
     */
    toListTagOptions() {
        return this.to('ListTagOptions');
    }
    /**
     * (experimental) Grants permission to list the tags for a service catalog appregistry resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to provision a product with a specified provisioning artifact and launch parameters.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisionProduct.html
     *
     * @experimental
     */
    toProvisionProduct() {
        return this.to('ProvisionProduct');
    }
    /**
     * (experimental) Grants permission to reject a portfolio that has been shared with you that you previously accepted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_RejectPortfolioShare.html
     *
     * @experimental
     */
    toRejectPortfolioShare() {
        return this.to('RejectPortfolioShare');
    }
    /**
     * (experimental) Grants permission to list all the provisioned products in your account.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ScanProvisionedProducts.html
     *
     * @experimental
     */
    toScanProvisionedProducts() {
        return this.to('ScanProvisionedProducts');
    }
    /**
     * (experimental) Grants permission to list the products available to you as an end-user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProducts.html
     *
     * @experimental
     */
    toSearchProducts() {
        return this.to('SearchProducts');
    }
    /**
     * (experimental) Grants permission to list all the products in your account or all the products associated with a given portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProductsAsAdmin.html
     *
     * @experimental
     */
    toSearchProductsAsAdmin() {
        return this.to('SearchProductsAsAdmin');
    }
    /**
     * (experimental) Grants permission to list all the provisioned products in your account.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProvisionedProducts.html
     *
     * @experimental
     */
    toSearchProvisionedProducts() {
        return this.to('SearchProvisionedProducts');
    }
    /**
     * (experimental) Grants permission to sync a resource with its current state in AppRegistry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_SyncResource.html
     *
     * @experimental
     */
    toSyncResource() {
        return this.to('SyncResource');
    }
    /**
     * (experimental) Grants permission to tag a service catalog appregistry resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to terminate an existing provisioned product.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_TerminateProvisionedProduct.html
     *
     * @experimental
     */
    toTerminateProvisionedProduct() {
        return this.to('TerminateProvisionedProduct');
    }
    /**
     * (experimental) Grants permission to remove a tag from a service catalog appregistry resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update the attributes of an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_UpdateApplication.html
     *
     * @experimental
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
    /**
     * (experimental) Grants permission to update the attributes of an existing attribute group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_UpdateAttributeGroup.html
     *
     * @experimental
     */
    toUpdateAttributeGroup() {
        return this.to('UpdateAttributeGroup');
    }
    /**
     * (experimental) Grants permission to update the metadata fields of an existing constraint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateConstraint.html
     *
     * @experimental
     */
    toUpdateConstraint() {
        return this.to('UpdateConstraint');
    }
    /**
     * (experimental) Grants permission to update the metadata fields and/or tags of an existing portfolio.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdatePortfolio.html
     *
     * @experimental
     */
    toUpdatePortfolio() {
        return this.to('UpdatePortfolio');
    }
    /**
     * (experimental) Grants permission to update the metadata fields and/or tags of an existing product.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProduct.html
     *
     * @experimental
     */
    toUpdateProduct() {
        return this.to('UpdateProduct');
    }
    /**
     * (experimental) Grants permission to update an existing provisioned product.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProduct.html
     *
     * @experimental
     */
    toUpdateProvisionedProduct() {
        return this.to('UpdateProvisionedProduct');
    }
    /**
     * (experimental) Grants permission to update the properties of an existing provisioned product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProductProperties.html
     *
     * @experimental
     */
    toUpdateProvisionedProductProperties() {
        return this.to('UpdateProvisionedProductProperties');
    }
    /**
     * (experimental) Grants permission to update the metadata fields of an existing provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisioningArtifact.html
     *
     * @experimental
     */
    toUpdateProvisioningArtifact() {
        return this.to('UpdateProvisioningArtifact');
    }
    /**
     * (experimental) Grants permission to update a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateServiceAction.html
     *
     * @experimental
     */
    toUpdateServiceAction() {
        return this.to('UpdateServiceAction');
    }
    /**
     * (experimental) Grants permission to update the specified TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateTagOption.html
     *
     * @experimental
     */
    toUpdateTagOption() {
        return this.to('UpdateTagOption');
    }
    /**
     * (experimental) Adds a resource of type Application to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateApplication.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApplication(applicationId, account, region, partition) {
        var arn = 'arn:${Partition}:servicecatalog:${Region}:${Account}:/applications/${ApplicationId}';
        arn = arn.replace('${ApplicationId}', applicationId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type AttributeGroup to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateAttributeGroup.html
     *
     * @param attributeGroupId - Identifier for the attributeGroupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAttributeGroup(attributeGroupId, account, region, partition) {
        var arn = 'arn:${Partition}:servicecatalog:${Region}:${Account}:/attribute-groups/${AttributeGroupId}';
        arn = arn.replace('${AttributeGroupId}', attributeGroupId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type Portfolio to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_PortfolioDetail.html
     *
     * @param portfolioId - Identifier for the portfolioId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPortfolio(portfolioId, account, region, partition) {
        var arn = 'arn:${Partition}:catalog:${Region}:${Account}:portfolio/${PortfolioId}';
        arn = arn.replace('${PortfolioId}', portfolioId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type Product to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProductViewDetail.html
     *
     * @param productId - Identifier for the productId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onProduct(productId, account, region, partition) {
        var arn = 'arn:${Partition}:catalog:${Region}:${Account}:product/${ProductId}';
        arn = arn.replace('${ProductId}', productId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Filters users to see and perform actions on resources created by anyone in the account.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .toDescribeRecord()
     * - .toListRecordHistory()
     * - .toScanProvisionedProducts()
     * - .toSearchProvisionedProducts()
     * - .toTerminateProvisionedProduct()
     * - .toUpdateProvisionedProduct()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAccountLevel(value, operator) {
        return this.if(`accountLevel`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters users to see and perform actions on resources created either by them or by anyone federating into the same role as them.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .toDescribeRecord()
     * - .toListRecordHistory()
     * - .toScanProvisionedProducts()
     * - .toSearchProvisionedProducts()
     * - .toTerminateProvisionedProduct()
     * - .toUpdateProvisionedProduct()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRoleLevel(value, operator) {
        return this.if(`roleLevel`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters users to see and perform actions on only resources that they created.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .toDescribeRecord()
     * - .toListRecordHistory()
     * - .toScanProvisionedProducts()
     * - .toSearchProvisionedProducts()
     * - .toTerminateProvisionedProduct()
     * - .toUpdateProvisionedProduct()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifUserLevel(value, operator) {
        return this.if(`userLevel`, value, operator || 'StringLike');
    }
}
exports.Servicecatalog = Servicecatalog;
_a = JSII_RTTI_SYMBOL_1;
Servicecatalog[_a] = { fqn: "cdk-iam-floyd.Servicecatalog", version: "0.147.0" };
//# sourceMappingURL=data:application/json;base64,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