"""
    ModelAccounts API

    Allow clients to fetch ModelAccounts Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: 3
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.Portfolio.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.Portfolio.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.Portfolio.exceptions import ApiException
from fds.sdk.Portfolio.model.client_error_response import ClientErrorResponse
from fds.sdk.Portfolio.model.data_and_meta_model import DataAndMetaModel
from fds.sdk.Portfolio.model.model_account_fields_root import ModelAccountFieldsRoot





class ModelAccountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.create_or_update_model_account_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}',
                'operation_id': 'create_or_update_model_account',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'model_account_fields_root',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'model_account_fields_root':
                        (ModelAccountFieldsRoot,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                    'model_account_fields_root': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

        self.delete_a_model_account_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}',
                'operation_id': 'delete_a_model_account',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.delete_model_account_by_date_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}/dates/{date}',
                'operation_id': 'delete_model_account_by_date',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'date',
                    'symbols',
                ],
                'required': [
                    'name',
                    'date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'date':
                        (str,),
                    'symbols':
                        ([str],),
                },
                'attribute_map': {
                    'name': 'name',
                    'date': 'date',
                    'symbols': 'symbols',
                },
                'location_map': {
                    'name': 'path',
                    'date': 'path',
                    'symbols': 'query',
                },
                'collection_format_map': {
                    'symbols': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.delete_model_account_by_symbol_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}/symbols/{symbol}',
                'operation_id': 'delete_model_account_by_symbol',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'symbol',
                    'dates',
                ],
                'required': [
                    'name',
                    'symbol',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'symbol':
                        (str,),
                    'dates':
                        ([str],),
                },
                'attribute_map': {
                    'name': 'name',
                    'symbol': 'symbol',
                    'dates': 'dates',
                },
                'location_map': {
                    'name': 'path',
                    'symbol': 'path',
                    'dates': 'query',
                },
                'collection_format_map': {
                    'dates': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_account_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataAndMetaModel,), 400: (ClientErrorResponse,), 404: (ClientErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}',
                'operation_id': 'get_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'format',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'format': 'format',
                },
                'location_map': {
                    'name': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_account_for_date_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataAndMetaModel,), 400: (ClientErrorResponse,), 404: (ClientErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}/dates/{date}',
                'operation_id': 'get_account_for_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'date',
                    'format',
                ],
                'required': [
                    'name',
                    'date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'date':
                        (str,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'date': 'date',
                    'format': 'format',
                },
                'location_map': {
                    'name': 'path',
                    'date': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_account_for_date_and_symbol_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataAndMetaModel,), 400: (ClientErrorResponse,), 404: (ClientErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}/dates/{date}/symbols/{symbol}',
                'operation_id': 'get_account_for_date_and_symbol',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'symbol',
                    'date',
                    'format',
                ],
                'required': [
                    'name',
                    'symbol',
                    'date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'symbol':
                        (str,),
                    'date':
                        (str,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'symbol': 'symbol',
                    'date': 'date',
                    'format': 'format',
                },
                'location_map': {
                    'name': 'path',
                    'symbol': 'path',
                    'date': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_account_for_symbol_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataAndMetaModel,), 400: (ClientErrorResponse,), 404: (ClientErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}/symbols/{symbol}',
                'operation_id': 'get_account_for_symbol',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'symbol',
                    'format',
                ],
                'required': [
                    'name',
                    'symbol',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'symbol':
                        (str,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'symbol': 'symbol',
                    'format': 'format',
                },
                'location_map': {
                    'name': 'path',
                    'symbol': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_account_schema_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataAndMetaModel,), 400: (ClientErrorResponse,), 404: (ClientErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/analytics/accounts/v3/models/{name}/schema',
                'operation_id': 'get_account_schema',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def create_or_update_model_account(
        self,
        name,
        **kwargs
    ) -> None:
        """Create or update an existing model account  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The path and filename of the model account to create or update

        Keyword Args:
            model_account_fields_root (ModelAccountFieldsRoot): The object containing the input values. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        return self.create_or_update_model_account_endpoint.call_with_http_info(**kwargs)

    def create_or_update_model_account_with_http_info(
        self,
        name,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Create or update an existing model account  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The path and filename of the model account to create or update

        Keyword Args:
            model_account_fields_root (ModelAccountFieldsRoot): The object containing the input values. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        return self.create_or_update_model_account_endpoint.call_with_http_info(**kwargs)

    def create_or_update_model_account_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[None]":
        """Create or update an existing model account  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the model account to create or update

        Keyword Args:
            model_account_fields_root (ModelAccountFieldsRoot): The object containing the input values. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        return self.create_or_update_model_account_endpoint.call_with_http_info(**kwargs)

    def create_or_update_model_account_with_http_info_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Create or update an existing model account  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the model account to create or update

        Keyword Args:
            model_account_fields_root (ModelAccountFieldsRoot): The object containing the input values. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        return self.create_or_update_model_account_endpoint.call_with_http_info(**kwargs)


    def delete_a_model_account(
        self,
        name,
        **kwargs
    ) -> None:
        """Delete model account, takes an account path and name and deletes it.  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The path and filename of model account to delete

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        return self.delete_a_model_account_endpoint.call_with_http_info(**kwargs)

    def delete_a_model_account_with_http_info(
        self,
        name,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Delete model account, takes an account path and name and deletes it.  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The path and filename of model account to delete

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        return self.delete_a_model_account_endpoint.call_with_http_info(**kwargs)

    def delete_a_model_account_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[None]":
        """Delete model account, takes an account path and name and deletes it.  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The path and filename of model account to delete

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        return self.delete_a_model_account_endpoint.call_with_http_info(**kwargs)

    def delete_a_model_account_with_http_info_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Delete model account, takes an account path and name and deletes it.  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The path and filename of model account to delete

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        return self.delete_a_model_account_endpoint.call_with_http_info(**kwargs)


    def delete_model_account_by_date(
        self,
        name,
        date,
        **kwargs
    ) -> None:
        """Delete all entries for a date or specific symbol entries for a date from a previously created account.  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The filename of model account to delete
            date (str): The date from the given file name to delete

        Keyword Args:
            symbols ([str]): The symbols from the given file name and date to delete (Maximum 10 symbols are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.delete_model_account_by_date_endpoint.call_with_http_info(**kwargs)

    def delete_model_account_by_date_with_http_info(
        self,
        name,
        date,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Delete all entries for a date or specific symbol entries for a date from a previously created account.  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The filename of model account to delete
            date (str): The date from the given file name to delete

        Keyword Args:
            symbols ([str]): The symbols from the given file name and date to delete (Maximum 10 symbols are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.delete_model_account_by_date_endpoint.call_with_http_info(**kwargs)

    def delete_model_account_by_date_async(
        self,
        name,
        date,
        **kwargs
    ) -> "ApplyResult[None]":
        """Delete all entries for a date or specific symbol entries for a date from a previously created account.  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The filename of model account to delete
            date (str): The date from the given file name to delete

        Keyword Args:
            symbols ([str]): The symbols from the given file name and date to delete (Maximum 10 symbols are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.delete_model_account_by_date_endpoint.call_with_http_info(**kwargs)

    def delete_model_account_by_date_with_http_info_async(
        self,
        name,
        date,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Delete all entries for a date or specific symbol entries for a date from a previously created account.  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The filename of model account to delete
            date (str): The date from the given file name to delete

        Keyword Args:
            symbols ([str]): The symbols from the given file name and date to delete (Maximum 10 symbols are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.delete_model_account_by_date_endpoint.call_with_http_info(**kwargs)


    def delete_model_account_by_symbol(
        self,
        name,
        symbol,
        **kwargs
    ) -> None:
        """Delete all entries for a symbol or specific date entries for a symbol from a previously created account.  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The filename of model account to delete
            symbol (str): The symbol from the given file name to delete

        Keyword Args:
            dates ([str]): The dates from the given file name and symbol to delete (Maximum 10 dates are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.delete_model_account_by_symbol_endpoint.call_with_http_info(**kwargs)

    def delete_model_account_by_symbol_with_http_info(
        self,
        name,
        symbol,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Delete all entries for a symbol or specific date entries for a symbol from a previously created account.  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The filename of model account to delete
            symbol (str): The symbol from the given file name to delete

        Keyword Args:
            dates ([str]): The dates from the given file name and symbol to delete (Maximum 10 dates are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.delete_model_account_by_symbol_endpoint.call_with_http_info(**kwargs)

    def delete_model_account_by_symbol_async(
        self,
        name,
        symbol,
        **kwargs
    ) -> "ApplyResult[None]":
        """Delete all entries for a symbol or specific date entries for a symbol from a previously created account.  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The filename of model account to delete
            symbol (str): The symbol from the given file name to delete

        Keyword Args:
            dates ([str]): The dates from the given file name and symbol to delete (Maximum 10 dates are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.delete_model_account_by_symbol_endpoint.call_with_http_info(**kwargs)

    def delete_model_account_by_symbol_with_http_info_async(
        self,
        name,
        symbol,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Delete all entries for a symbol or specific date entries for a symbol from a previously created account.  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The filename of model account to delete
            symbol (str): The symbol from the given file name to delete

        Keyword Args:
            dates ([str]): The dates from the given file name and symbol to delete (Maximum 10 dates are allowed). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.delete_model_account_by_symbol_endpoint.call_with_http_info(**kwargs)


    def get_account(
        self,
        name,
        **kwargs
    ) -> DataAndMetaModel:
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The path and filename of the account to get

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        return self.get_account_endpoint.call_with_http_info(**kwargs)

    def get_account_with_http_info(
        self,
        name,
        **kwargs
    ) -> typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]:
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The path and filename of the account to get

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        return self.get_account_endpoint.call_with_http_info(**kwargs)

    def get_account_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[DataAndMetaModel]":
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataAndMetaModel]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        return self.get_account_endpoint.call_with_http_info(**kwargs)

    def get_account_with_http_info_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]]":
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataAndMetaModel, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        return self.get_account_endpoint.call_with_http_info(**kwargs)


    def get_account_for_date(
        self,
        name,
        date,
        **kwargs
    ) -> DataAndMetaModel:
        """Get account endpoint, takes an account name, date and returns underlying data for that date  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The path and filename of the account to get
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.get_account_for_date_endpoint.call_with_http_info(**kwargs)

    def get_account_for_date_with_http_info(
        self,
        name,
        date,
        **kwargs
    ) -> typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]:
        """Get account endpoint, takes an account name, date and returns underlying data for that date  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The path and filename of the account to get
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.get_account_for_date_endpoint.call_with_http_info(**kwargs)

    def get_account_for_date_async(
        self,
        name,
        date,
        **kwargs
    ) -> "ApplyResult[DataAndMetaModel]":
        """Get account endpoint, takes an account name, date and returns underlying data for that date  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataAndMetaModel]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.get_account_for_date_endpoint.call_with_http_info(**kwargs)

    def get_account_for_date_with_http_info_async(
        self,
        name,
        date,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]]":
        """Get account endpoint, takes an account name, date and returns underlying data for that date  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataAndMetaModel, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        kwargs['date'] = \
            date
        return self.get_account_for_date_endpoint.call_with_http_info(**kwargs)


    def get_account_for_date_and_symbol(
        self,
        name,
        symbol,
        date,
        **kwargs
    ) -> DataAndMetaModel:
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        kwargs['date'] = \
            date
        return self.get_account_for_date_and_symbol_endpoint.call_with_http_info(**kwargs)

    def get_account_for_date_and_symbol_with_http_info(
        self,
        name,
        symbol,
        date,
        **kwargs
    ) -> typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]:
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        kwargs['date'] = \
            date
        return self.get_account_for_date_and_symbol_endpoint.call_with_http_info(**kwargs)

    def get_account_for_date_and_symbol_async(
        self,
        name,
        symbol,
        date,
        **kwargs
    ) -> "ApplyResult[DataAndMetaModel]":
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataAndMetaModel]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        kwargs['date'] = \
            date
        return self.get_account_for_date_and_symbol_endpoint.call_with_http_info(**kwargs)

    def get_account_for_date_and_symbol_with_http_info_async(
        self,
        name,
        symbol,
        date,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]]":
        """Get account endpoint, takes an account name and returns underlying data  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated
            date (str): The date for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataAndMetaModel, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        kwargs['date'] = \
            date
        return self.get_account_for_date_and_symbol_endpoint.call_with_http_info(**kwargs)


    def get_account_for_symbol(
        self,
        name,
        symbol,
        **kwargs
    ) -> DataAndMetaModel:
        """Get account endpoint, takes an account name, symbol and returns underlying data for that symbol  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.get_account_for_symbol_endpoint.call_with_http_info(**kwargs)

    def get_account_for_symbol_with_http_info(
        self,
        name,
        symbol,
        **kwargs
    ) -> typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]:
        """Get account endpoint, takes an account name, symbol and returns underlying data for that symbol  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.get_account_for_symbol_endpoint.call_with_http_info(**kwargs)

    def get_account_for_symbol_async(
        self,
        name,
        symbol,
        **kwargs
    ) -> "ApplyResult[DataAndMetaModel]":
        """Get account endpoint, takes an account name, symbol and returns underlying data for that symbol  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataAndMetaModel]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.get_account_for_symbol_endpoint.call_with_http_info(**kwargs)

    def get_account_for_symbol_with_http_info_async(
        self,
        name,
        symbol,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]]":
        """Get account endpoint, takes an account name, symbol and returns underlying data for that symbol  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get
            symbol (str): The symbol for which data needs to be updated

        Keyword Args:
            format (str): Optional format for the response, supported formats are JsonStach and AccountModel. [optional] if omitted the server will use the default value of "JsonStach"
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataAndMetaModel, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        kwargs['symbol'] = \
            symbol
        return self.get_account_for_symbol_endpoint.call_with_http_info(**kwargs)


    def get_account_schema(
        self,
        name,
        **kwargs
    ) -> DataAndMetaModel:
        """Get account schema endpoint, takes an account name and returns its schema  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): The path and filename of the account to get its schema

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        return self.get_account_schema_endpoint.call_with_http_info(**kwargs)

    def get_account_schema_with_http_info(
        self,
        name,
        **kwargs
    ) -> typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]:
        """Get account schema endpoint, takes an account name and returns its schema  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): The path and filename of the account to get its schema

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataAndMetaModel
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        return self.get_account_schema_endpoint.call_with_http_info(**kwargs)

    def get_account_schema_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[DataAndMetaModel]":
        """Get account schema endpoint, takes an account name and returns its schema  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get its schema

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataAndMetaModel]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        return self.get_account_schema_endpoint.call_with_http_info(**kwargs)

    def get_account_schema_with_http_info_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataAndMetaModel, int, typing.MutableMapping]]":
        """Get account schema endpoint, takes an account name and returns its schema  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): The path and filename of the account to get its schema

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataAndMetaModel, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        return self.get_account_schema_endpoint.call_with_http_info(**kwargs)


