# AUTOGENERATED! DO NOT EDIT! File to edit: product-sdk.ipynb (unless otherwise specified).

__all__ = ['FunctionNames', 'ProductSdk']

# Cell
from botocore.config import Config
from s3bz.s3bz import S3, Requests
from lambdasdk.lambdasdk import Lambda
import bz2, json, boto3, base64, logging
logging.basicConfig(level=logging.INFO)

# Cell
class FunctionNames:
  '''determine function and resources name based on branchName'''
  def __init__(self, branchName = 'dev-manual'):
    self.branchName = branchName
  dumpToS3 = lambda self: f'product-dump-s3-{self.branchName}'
  updateProduct = lambda self: f'product-update-{self.branchName}'
  updateS3 = lambda self: f'product-update-s3-{self.branchName}'
  singleQuery = lambda self: f'product-update-s3-{self.branchName}'
  allQuery = lambda self: f'product-get-all-{self.branchName}'
  inputBucket = lambda self: f'input-product-bucket-{self.branchName}'
  inventoryBucket = lambda self: f'product-bucket-{self.branchName}'


# Cell
class ProductSdk:

  def __init__(self, branch = 'dev-manual', user = None, pw = None, region = 'ap-southeast-1'):
    self.branchName = branch
    self.functionNames = FunctionNames(branchName = branch)
    self.lambdaClient = Lambda(user =user, pw=pw, region = region)
    self.user = user; self.pw = pw; self.region = region


  def updateWithS3(self, data,
                   inputKeyName = 'input-data-name',
                   invocationType = 'RequestResponse',
                   user= None, pw= None):
    # put users if not specified
    user = user or self.user; pw = pw or self.pw

    # extract function name and inputbucket name
    inputBucketName = self.functionNames.inputBucket()
    functionName = self.functionNames.updateS3()
    logging.info(f'bucket is {inputBucketName}')

    # save data to s3
    S3.save(key = inputKeyName,
            objectToSave = data ,
            bucket = inputBucketName,
            user=user, pw=pw)
    logging.info(f'data is saved to s3, invoking ingestion function')

    # call lambda function
    lambdaPayload = {
        'key': inputKeyName
    }
    logging.info(f'input to lambda is {lambdaPayload}')
    return self.lambdaClient.invoke(
      functionName= functionName ,
      input=lambdaPayload,
      invocationType= invocationType )

  def querySingleProduct(self, iprcode = '0171670', user=None, pw=None):
    '''query a single product'''
    #extract function name
    functionName = self.functionNames.singleQuery()

    input = { 'iprcode': iprcode }
    return self.lambdaClient.invoke(
        functionName = functionName, input = input )
