import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AutomationConnectionServicePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#application_id AutomationConnectionServicePrincipal#application_id}.
     *
     * @stability stable
     */
    readonly applicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#automation_account_name AutomationConnectionServicePrincipal#automation_account_name}.
     *
     * @stability stable
     */
    readonly automationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#certificate_thumbprint AutomationConnectionServicePrincipal#certificate_thumbprint}.
     *
     * @stability stable
     */
    readonly certificateThumbprint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#description AutomationConnectionServicePrincipal#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#name AutomationConnectionServicePrincipal#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#resource_group_name AutomationConnectionServicePrincipal#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#subscription_id AutomationConnectionServicePrincipal#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#tenant_id AutomationConnectionServicePrincipal#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#timeouts AutomationConnectionServicePrincipal#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AutomationConnectionServicePrincipalTimeouts;
}
/**
 * @stability stable
 */
export interface AutomationConnectionServicePrincipalTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#create AutomationConnectionServicePrincipal#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#delete AutomationConnectionServicePrincipal#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#read AutomationConnectionServicePrincipal#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal#update AutomationConnectionServicePrincipal#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function automationConnectionServicePrincipalTimeoutsToTerraform(struct?: AutomationConnectionServicePrincipalTimeoutsOutputReference | AutomationConnectionServicePrincipalTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AutomationConnectionServicePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AutomationConnectionServicePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AutomationConnectionServicePrincipalTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal azurerm_automation_connection_service_principal}.
 *
 * @stability stable
 */
export declare class AutomationConnectionServicePrincipal extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/automation_connection_service_principal azurerm_automation_connection_service_principal} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AutomationConnectionServicePrincipalConfig);
    private _applicationId?;
    /**
     * @stability stable
     */
    get applicationId(): string;
    /**
     * @stability stable
     */
    set applicationId(value: string);
    /**
     * @stability stable
     */
    get applicationIdInput(): string | undefined;
    private _automationAccountName?;
    /**
     * @stability stable
     */
    get automationAccountName(): string;
    /**
     * @stability stable
     */
    set automationAccountName(value: string);
    /**
     * @stability stable
     */
    get automationAccountNameInput(): string | undefined;
    private _certificateThumbprint?;
    /**
     * @stability stable
     */
    get certificateThumbprint(): string;
    /**
     * @stability stable
     */
    set certificateThumbprint(value: string);
    /**
     * @stability stable
     */
    get certificateThumbprintInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AutomationConnectionServicePrincipalTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AutomationConnectionServicePrincipalTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AutomationConnectionServicePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
