import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBillingMcaAccountScopeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#billing_account_name DataAzurermBillingMcaAccountScope#billing_account_name}.
     *
     * @stability stable
     */
    readonly billingAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#billing_profile_name DataAzurermBillingMcaAccountScope#billing_profile_name}.
     *
     * @stability stable
     */
    readonly billingProfileName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#invoice_section_name DataAzurermBillingMcaAccountScope#invoice_section_name}.
     *
     * @stability stable
     */
    readonly invoiceSectionName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#timeouts DataAzurermBillingMcaAccountScope#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBillingMcaAccountScopeTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermBillingMcaAccountScopeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#read DataAzurermBillingMcaAccountScope#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBillingMcaAccountScopeTimeoutsToTerraform(struct?: DataAzurermBillingMcaAccountScopeTimeoutsOutputReference | DataAzurermBillingMcaAccountScopeTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermBillingMcaAccountScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBillingMcaAccountScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBillingMcaAccountScopeTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope azurerm_billing_mca_account_scope}.
 *
 * @stability stable
 */
export declare class DataAzurermBillingMcaAccountScope extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope azurerm_billing_mca_account_scope} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBillingMcaAccountScopeConfig);
    private _billingAccountName?;
    /**
     * @stability stable
     */
    get billingAccountName(): string;
    /**
     * @stability stable
     */
    set billingAccountName(value: string);
    /**
     * @stability stable
     */
    get billingAccountNameInput(): string | undefined;
    private _billingProfileName?;
    /**
     * @stability stable
     */
    get billingProfileName(): string;
    /**
     * @stability stable
     */
    set billingProfileName(value: string);
    /**
     * @stability stable
     */
    get billingProfileNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _invoiceSectionName?;
    /**
     * @stability stable
     */
    get invoiceSectionName(): string;
    /**
     * @stability stable
     */
    set invoiceSectionName(value: string);
    /**
     * @stability stable
     */
    get invoiceSectionNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBillingMcaAccountScopeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBillingMcaAccountScopeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBillingMcaAccountScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
