import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#key_vault_id DataAzurermKeyVaultCertificate#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#name DataAzurermKeyVaultCertificate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#version DataAzurermKeyVaultCertificate#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#timeouts DataAzurermKeyVaultCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKeyVaultCertificateTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicyIssuerParameters extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicyKeyProperties extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get curve(): string;
    /**
     * @stability stable
     */
    get exportable(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get keySize(): number;
    /**
     * @stability stable
     */
    get keyType(): string;
    /**
     * @stability stable
     */
    get reuseKey(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionAction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get actionType(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTrigger extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get daysBeforeExpiry(): number;
    /**
     * @stability stable
     */
    get lifetimePercentage(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeAction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get action(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get trigger(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicySecretProperties extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get contentType(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dnsNames(): string[];
    /**
     * @stability stable
     */
    get emails(): string[];
    /**
     * @stability stable
     */
    get upns(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificateProperties extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get extendedKeyUsage(): string[];
    /**
     * @stability stable
     */
    get keyUsage(): string[];
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    get subjectAlternativeNames(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get validityInMonths(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateCertificatePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get issuerParameters(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get keyProperties(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get lifetimeAction(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get secretProperties(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get x509CertificateProperties(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#read DataAzurermKeyVaultCertificate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificateTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificateTimeoutsOutputReference | DataAzurermKeyVaultCertificateTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKeyVaultCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKeyVaultCertificateTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate azurerm_key_vault_certificate}.
 *
 * @stability stable
 */
export declare class DataAzurermKeyVaultCertificate extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate azurerm_key_vault_certificate} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificateConfig);
    /**
     * @stability stable
     */
    get certificateData(): string;
    /**
     * @stability stable
     */
    get certificateDataBase64(): string;
    /**
     * @stability stable
     */
    certificatePolicy(index: string): DataAzurermKeyVaultCertificateCertificatePolicy;
    /**
     * @stability stable
     */
    get expires(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get notBefore(): string;
    /**
     * @stability stable
     */
    get secretId(): string;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    /**
     * @stability stable
     */
    get versionlessId(): string;
    /**
     * @stability stable
     */
    get versionlessSecretId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKeyVaultCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKeyVaultCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKeyVaultCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
