import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermLogicAppStandardConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#name DataAzurermLogicAppStandard#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#resource_group_name DataAzurermLogicAppStandard#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#tags DataAzurermLogicAppStandard#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#identity DataAzurermLogicAppStandard#identity}
     *
     * @stability stable
     */
    readonly identity?: DataAzurermLogicAppStandardIdentity;
    /**
     * site_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#site_config DataAzurermLogicAppStandard#site_config}
     *
     * @stability stable
     */
    readonly siteConfig?: DataAzurermLogicAppStandardSiteConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#timeouts DataAzurermLogicAppStandard#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermLogicAppStandardTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppStandardConnectionString extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppStandardSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermLogicAppStandardIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#type DataAzurermLogicAppStandard#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function dataAzurermLogicAppStandardIdentityToTerraform(struct?: DataAzurermLogicAppStandardIdentityOutputReference | DataAzurermLogicAppStandardIdentity): any;
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppStandardIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLogicAppStandardIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLogicAppStandardIdentity | undefined);
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermLogicAppStandardSiteConfigIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_azure_fdid DataAzurermLogicAppStandard#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_fd_health_probe DataAzurermLogicAppStandard#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_forwarded_for DataAzurermLogicAppStandard#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_forwarded_host DataAzurermLogicAppStandard#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function dataAzurermLogicAppStandardSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataAzurermLogicAppStandardSiteConfigIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#action DataAzurermLogicAppStandard#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#headers DataAzurermLogicAppStandard#headers}.
     *
     * @stability stable
     */
    readonly headers?: DataAzurermLogicAppStandardSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#ip_address DataAzurermLogicAppStandard#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#name DataAzurermLogicAppStandard#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#priority DataAzurermLogicAppStandard#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#service_tag DataAzurermLogicAppStandard#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#virtual_network_subnet_id DataAzurermLogicAppStandard#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function dataAzurermLogicAppStandardSiteConfigIpRestrictionToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigIpRestriction | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataAzurermLogicAppStandardSiteConfigCors {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#allowed_origins DataAzurermLogicAppStandard#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#support_credentials DataAzurermLogicAppStandard#support_credentials}.
     *
     * @stability stable
     */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function dataAzurermLogicAppStandardSiteConfigCorsToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigCorsOutputReference | DataAzurermLogicAppStandardSiteConfigCors): any;
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppStandardSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLogicAppStandardSiteConfigCors | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLogicAppStandardSiteConfigCors | undefined);
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    /**
     * @stability stable
     */
    get supportCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportCredentials(): void;
    /**
     * @stability stable
     */
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermLogicAppStandardSiteConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#always_on DataAzurermLogicAppStandard#always_on}.
     *
     * @stability stable
     */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#app_scale_limit DataAzurermLogicAppStandard#app_scale_limit}.
     *
     * @stability stable
     */
    readonly appScaleLimit?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#dotnet_framework_version DataAzurermLogicAppStandard#dotnet_framework_version}.
     *
     * @stability stable
     */
    readonly dotnetFrameworkVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#elastic_instance_minimum DataAzurermLogicAppStandard#elastic_instance_minimum}.
     *
     * @stability stable
     */
    readonly elasticInstanceMinimum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#ftps_state DataAzurermLogicAppStandard#ftps_state}.
     *
     * @stability stable
     */
    readonly ftpsState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#health_check_path DataAzurermLogicAppStandard#health_check_path}.
     *
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#http2_enabled DataAzurermLogicAppStandard#http2_enabled}.
     *
     * @stability stable
     */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#ip_restriction DataAzurermLogicAppStandard#ip_restriction}.
     *
     * @stability stable
     */
    readonly ipRestriction?: DataAzurermLogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#linux_fx_version DataAzurermLogicAppStandard#linux_fx_version}.
     *
     * @stability stable
     */
    readonly linuxFxVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#min_tls_version DataAzurermLogicAppStandard#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#pre_warmed_instance_count DataAzurermLogicAppStandard#pre_warmed_instance_count}.
     *
     * @stability stable
     */
    readonly preWarmedInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#runtime_scale_monitoring_enabled DataAzurermLogicAppStandard#runtime_scale_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#use_32_bit_worker_process DataAzurermLogicAppStandard#use_32_bit_worker_process}.
     *
     * @stability stable
     */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#vnet_route_all_enabled DataAzurermLogicAppStandard#vnet_route_all_enabled}.
     *
     * @stability stable
     */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#websockets_enabled DataAzurermLogicAppStandard#websockets_enabled}.
     *
     * @stability stable
     */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#cors DataAzurermLogicAppStandard#cors}
     *
     * @stability stable
     */
    readonly cors?: DataAzurermLogicAppStandardSiteConfigCors;
}
export declare function dataAzurermLogicAppStandardSiteConfigToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigOutputReference | DataAzurermLogicAppStandardSiteConfig): any;
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppStandardSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLogicAppStandardSiteConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLogicAppStandardSiteConfig | undefined);
    private _alwaysOn?;
    /**
     * @stability stable
     */
    get alwaysOn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysOn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysOn(): void;
    /**
     * @stability stable
     */
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appScaleLimit?;
    /**
     * @stability stable
     */
    get appScaleLimit(): number;
    /**
     * @stability stable
     */
    set appScaleLimit(value: number);
    /**
     * @stability stable
     */
    resetAppScaleLimit(): void;
    /**
     * @stability stable
     */
    get appScaleLimitInput(): number | undefined;
    private _dotnetFrameworkVersion?;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    set dotnetFrameworkVersion(value: string);
    /**
     * @stability stable
     */
    resetDotnetFrameworkVersion(): void;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersionInput(): string | undefined;
    private _elasticInstanceMinimum?;
    /**
     * @stability stable
     */
    get elasticInstanceMinimum(): number;
    /**
     * @stability stable
     */
    set elasticInstanceMinimum(value: number);
    /**
     * @stability stable
     */
    resetElasticInstanceMinimum(): void;
    /**
     * @stability stable
     */
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    set ftpsState(value: string);
    /**
     * @stability stable
     */
    resetFtpsState(): void;
    /**
     * @stability stable
     */
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    set healthCheckPath(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckPath(): void;
    /**
     * @stability stable
     */
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    /**
     * @stability stable
     */
    get http2Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set http2Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttp2Enabled(): void;
    /**
     * @stability stable
     */
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    /**
     * @stability stable
     */
    get ipRestriction(): DataAzurermLogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipRestriction(value: DataAzurermLogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIpRestriction(): void;
    /**
     * @stability stable
     */
    get ipRestrictionInput(): cdktf.IResolvable | DataAzurermLogicAppStandardSiteConfigIpRestriction[] | undefined;
    private _linuxFxVersion?;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    set linuxFxVersion(value: string);
    /**
     * @stability stable
     */
    resetLinuxFxVersion(): void;
    /**
     * @stability stable
     */
    get linuxFxVersionInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    /**
     * @stability stable
     */
    get preWarmedInstanceCount(): number;
    /**
     * @stability stable
     */
    set preWarmedInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetPreWarmedInstanceCount(): void;
    /**
     * @stability stable
     */
    get preWarmedInstanceCountInput(): number | undefined;
    private _runtimeScaleMonitoringEnabled?;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRuntimeScaleMonitoringEnabled(): void;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUse32BitWorkerProcess(): void;
    /**
     * @stability stable
     */
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVnetRouteAllEnabled(): void;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    /**
     * @stability stable
     */
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWebsocketsEnabled(): void;
    /**
     * @stability stable
     */
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    /**
     * @stability stable
     */
    get cors(): DataAzurermLogicAppStandardSiteConfigCorsOutputReference;
    /**
     * @stability stable
     */
    putCors(value: DataAzurermLogicAppStandardSiteConfigCors): void;
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): DataAzurermLogicAppStandardSiteConfigCors | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermLogicAppStandardTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#read DataAzurermLogicAppStandard#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermLogicAppStandardTimeoutsToTerraform(struct?: DataAzurermLogicAppStandardTimeoutsOutputReference | DataAzurermLogicAppStandardTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermLogicAppStandardTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLogicAppStandardTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLogicAppStandardTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard azurerm_logic_app_standard}.
 *
 * @stability stable
 */
export declare class DataAzurermLogicAppStandard extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard azurerm_logic_app_standard} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermLogicAppStandardConfig);
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    appSettings(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get bundleVersion(): string;
    /**
     * @stability stable
     */
    get clientAffinityEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get clientCertificateMode(): string;
    /**
     * @stability stable
     */
    connectionString(index: string): DataAzurermLogicAppStandardConnectionString;
    /**
     * @stability stable
     */
    get customDomainVerificationId(): string;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get httpsOnly(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string;
    /**
     * @stability stable
     */
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteCredential(index: string): DataAzurermLogicAppStandardSiteCredential;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    get storageAccountShareName(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get useExtensionBundle(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get version(): string;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): DataAzurermLogicAppStandardIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: DataAzurermLogicAppStandardIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): DataAzurermLogicAppStandardIdentity | undefined;
    private _siteConfig;
    /**
     * @stability stable
     */
    get siteConfig(): DataAzurermLogicAppStandardSiteConfigOutputReference;
    /**
     * @stability stable
     */
    putSiteConfig(value: DataAzurermLogicAppStandardSiteConfig): void;
    /**
     * @stability stable
     */
    resetSiteConfig(): void;
    /**
     * @stability stable
     */
    get siteConfigInput(): DataAzurermLogicAppStandardSiteConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermLogicAppStandardTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermLogicAppStandardTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermLogicAppStandardTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
