import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPrivateEndpointConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#name DataAzurermPrivateEndpointConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#resource_group_name DataAzurermPrivateEndpointConnection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#timeouts DataAzurermPrivateEndpointConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPrivateEndpointConnectionTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermPrivateEndpointConnectionNetworkInterface extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermPrivateEndpointConnectionPrivateServiceConnection extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get requestResponse(): string;
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermPrivateEndpointConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection#read DataAzurermPrivateEndpointConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPrivateEndpointConnectionTimeoutsToTerraform(struct?: DataAzurermPrivateEndpointConnectionTimeoutsOutputReference | DataAzurermPrivateEndpointConnectionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermPrivateEndpointConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPrivateEndpointConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPrivateEndpointConnectionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection azurerm_private_endpoint_connection}.
 *
 * @stability stable
 */
export declare class DataAzurermPrivateEndpointConnection extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_endpoint_connection azurerm_private_endpoint_connection} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateEndpointConnectionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkInterface(index: string): DataAzurermPrivateEndpointConnectionNetworkInterface;
    /**
     * @stability stable
     */
    privateServiceConnection(index: string): DataAzurermPrivateEndpointConnectionPrivateServiceConnection;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPrivateEndpointConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPrivateEndpointConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPrivateEndpointConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
