import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#name DataAzurermSnapshot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#resource_group_name DataAzurermSnapshot#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#timeouts DataAzurermSnapshot#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSnapshotTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSnapshotEncryptionSettingsDiskEncryptionKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get secretUrl(): string;
    /**
     * @stability stable
     */
    get sourceVaultId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSnapshotEncryptionSettingsKeyEncryptionKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyUrl(): string;
    /**
     * @stability stable
     */
    get sourceVaultId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSnapshotEncryptionSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get diskEncryptionKey(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get keyEncryptionKey(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataAzurermSnapshotTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot#read DataAzurermSnapshot#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSnapshotTimeoutsToTerraform(struct?: DataAzurermSnapshotTimeoutsOutputReference | DataAzurermSnapshotTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSnapshotTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot azurerm_snapshot}.
 *
 * @stability stable
 */
export declare class DataAzurermSnapshot extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/snapshot azurerm_snapshot} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSnapshotConfig);
    /**
     * @stability stable
     */
    get creationOption(): string;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    encryptionSettings(index: string): DataAzurermSnapshotEncryptionSettings;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get osType(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sourceResourceId(): string;
    /**
     * @stability stable
     */
    get sourceUri(): string;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    get timeCreated(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSnapshotTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSnapshotTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
