import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryTriggerCustomEventConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#activated DataFactoryTriggerCustomEvent#activated}.
     *
     * @stability stable
     */
    readonly activated?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#additional_properties DataFactoryTriggerCustomEvent#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#annotations DataFactoryTriggerCustomEvent#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#data_factory_id DataFactoryTriggerCustomEvent#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#description DataFactoryTriggerCustomEvent#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#eventgrid_topic_id DataFactoryTriggerCustomEvent#eventgrid_topic_id}.
     *
     * @stability stable
     */
    readonly eventgridTopicId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#events DataFactoryTriggerCustomEvent#events}.
     *
     * @stability stable
     */
    readonly events: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#name DataFactoryTriggerCustomEvent#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#subject_begins_with DataFactoryTriggerCustomEvent#subject_begins_with}.
     *
     * @stability stable
     */
    readonly subjectBeginsWith?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#subject_ends_with DataFactoryTriggerCustomEvent#subject_ends_with}.
     *
     * @stability stable
     */
    readonly subjectEndsWith?: string;
    /**
     * pipeline block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#pipeline DataFactoryTriggerCustomEvent#pipeline}
     *
     * @stability stable
     */
    readonly pipeline: DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#timeouts DataFactoryTriggerCustomEvent#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryTriggerCustomEventTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryTriggerCustomEventPipeline {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#name DataFactoryTriggerCustomEvent#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#parameters DataFactoryTriggerCustomEvent#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryTriggerCustomEventPipelineToTerraform(struct?: DataFactoryTriggerCustomEventPipeline | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataFactoryTriggerCustomEventTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#create DataFactoryTriggerCustomEvent#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#delete DataFactoryTriggerCustomEvent#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#read DataFactoryTriggerCustomEvent#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#update DataFactoryTriggerCustomEvent#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryTriggerCustomEventTimeoutsToTerraform(struct?: DataFactoryTriggerCustomEventTimeoutsOutputReference | DataFactoryTriggerCustomEventTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataFactoryTriggerCustomEventTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryTriggerCustomEventTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryTriggerCustomEventTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event azurerm_data_factory_trigger_custom_event}.
 *
 * @stability stable
 */
export declare class DataFactoryTriggerCustomEvent extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event azurerm_data_factory_trigger_custom_event} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryTriggerCustomEventConfig);
    private _activated?;
    /**
     * @stability stable
     */
    get activated(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set activated(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActivated(): void;
    /**
     * @stability stable
     */
    get activatedInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _eventgridTopicId?;
    /**
     * @stability stable
     */
    get eventgridTopicId(): string;
    /**
     * @stability stable
     */
    set eventgridTopicId(value: string);
    /**
     * @stability stable
     */
    get eventgridTopicIdInput(): string | undefined;
    private _events?;
    /**
     * @stability stable
     */
    get events(): string[];
    /**
     * @stability stable
     */
    set events(value: string[]);
    /**
     * @stability stable
     */
    get eventsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _subjectBeginsWith?;
    /**
     * @stability stable
     */
    get subjectBeginsWith(): string;
    /**
     * @stability stable
     */
    set subjectBeginsWith(value: string);
    /**
     * @stability stable
     */
    resetSubjectBeginsWith(): void;
    /**
     * @stability stable
     */
    get subjectBeginsWithInput(): string | undefined;
    private _subjectEndsWith?;
    /**
     * @stability stable
     */
    get subjectEndsWith(): string;
    /**
     * @stability stable
     */
    set subjectEndsWith(value: string);
    /**
     * @stability stable
     */
    resetSubjectEndsWith(): void;
    /**
     * @stability stable
     */
    get subjectEndsWithInput(): string | undefined;
    private _pipeline?;
    /**
     * @stability stable
     */
    get pipeline(): DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set pipeline(value: DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get pipelineInput(): cdktf.IResolvable | DataFactoryTriggerCustomEventPipeline[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryTriggerCustomEventTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryTriggerCustomEventTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryTriggerCustomEventTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
