import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataProtectionBackupInstancePostgresqlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#backup_policy_id DataProtectionBackupInstancePostgresql#backup_policy_id}.
     *
     * @stability stable
     */
    readonly backupPolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#database_credential_key_vault_secret_id DataProtectionBackupInstancePostgresql#database_credential_key_vault_secret_id}.
     *
     * @stability stable
     */
    readonly databaseCredentialKeyVaultSecretId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#database_id DataProtectionBackupInstancePostgresql#database_id}.
     *
     * @stability stable
     */
    readonly databaseId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#location DataProtectionBackupInstancePostgresql#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#name DataProtectionBackupInstancePostgresql#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#vault_id DataProtectionBackupInstancePostgresql#vault_id}.
     *
     * @stability stable
     */
    readonly vaultId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#timeouts DataProtectionBackupInstancePostgresql#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataProtectionBackupInstancePostgresqlTimeouts;
}
/**
 * @stability stable
 */
export interface DataProtectionBackupInstancePostgresqlTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#create DataProtectionBackupInstancePostgresql#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#delete DataProtectionBackupInstancePostgresql#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#read DataProtectionBackupInstancePostgresql#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql#update DataProtectionBackupInstancePostgresql#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataProtectionBackupInstancePostgresqlTimeoutsToTerraform(struct?: DataProtectionBackupInstancePostgresqlTimeoutsOutputReference | DataProtectionBackupInstancePostgresqlTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataProtectionBackupInstancePostgresqlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataProtectionBackupInstancePostgresqlTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataProtectionBackupInstancePostgresqlTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql azurerm_data_protection_backup_instance_postgresql}.
 *
 * @stability stable
 */
export declare class DataProtectionBackupInstancePostgresql extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_instance_postgresql azurerm_data_protection_backup_instance_postgresql} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataProtectionBackupInstancePostgresqlConfig);
    private _backupPolicyId?;
    /**
     * @stability stable
     */
    get backupPolicyId(): string;
    /**
     * @stability stable
     */
    set backupPolicyId(value: string);
    /**
     * @stability stable
     */
    get backupPolicyIdInput(): string | undefined;
    private _databaseCredentialKeyVaultSecretId?;
    /**
     * @stability stable
     */
    get databaseCredentialKeyVaultSecretId(): string;
    /**
     * @stability stable
     */
    set databaseCredentialKeyVaultSecretId(value: string);
    /**
     * @stability stable
     */
    resetDatabaseCredentialKeyVaultSecretId(): void;
    /**
     * @stability stable
     */
    get databaseCredentialKeyVaultSecretIdInput(): string | undefined;
    private _databaseId?;
    /**
     * @stability stable
     */
    get databaseId(): string;
    /**
     * @stability stable
     */
    set databaseId(value: string);
    /**
     * @stability stable
     */
    get databaseIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _vaultId?;
    /**
     * @stability stable
     */
    get vaultId(): string;
    /**
     * @stability stable
     */
    set vaultId(value: string);
    /**
     * @stability stable
     */
    get vaultIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataProtectionBackupInstancePostgresqlTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataProtectionBackupInstancePostgresqlTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataProtectionBackupInstancePostgresqlTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
