import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExpressRouteCircuitPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#express_route_circuit_name ExpressRouteCircuitPeering#express_route_circuit_name}.
     *
     * @stability stable
     */
    readonly expressRouteCircuitName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#peer_asn ExpressRouteCircuitPeering#peer_asn}.
     *
     * @stability stable
     */
    readonly peerAsn?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#peering_type ExpressRouteCircuitPeering#peering_type}.
     *
     * @stability stable
     */
    readonly peeringType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#primary_peer_address_prefix ExpressRouteCircuitPeering#primary_peer_address_prefix}.
     *
     * @stability stable
     */
    readonly primaryPeerAddressPrefix: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#resource_group_name ExpressRouteCircuitPeering#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#route_filter_id ExpressRouteCircuitPeering#route_filter_id}.
     *
     * @stability stable
     */
    readonly routeFilterId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#secondary_peer_address_prefix ExpressRouteCircuitPeering#secondary_peer_address_prefix}.
     *
     * @stability stable
     */
    readonly secondaryPeerAddressPrefix: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#shared_key ExpressRouteCircuitPeering#shared_key}.
     *
     * @stability stable
     */
    readonly sharedKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#vlan_id ExpressRouteCircuitPeering#vlan_id}.
     *
     * @stability stable
     */
    readonly vlanId: number;
    /**
     * ipv6 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#ipv6 ExpressRouteCircuitPeering#ipv6}
     *
     * @stability stable
     */
    readonly ipv6?: ExpressRouteCircuitPeeringIpv6;
    /**
     * microsoft_peering_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#microsoft_peering_config ExpressRouteCircuitPeering#microsoft_peering_config}
     *
     * @stability stable
     */
    readonly microsoftPeeringConfig?: ExpressRouteCircuitPeeringMicrosoftPeeringConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#timeouts ExpressRouteCircuitPeering#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ExpressRouteCircuitPeeringTimeouts;
}
/**
 * @stability stable
 */
export interface ExpressRouteCircuitPeeringIpv6MicrosoftPeering {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#advertised_public_prefixes ExpressRouteCircuitPeering#advertised_public_prefixes}.
     *
     * @stability stable
     */
    readonly advertisedPublicPrefixes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#customer_asn ExpressRouteCircuitPeering#customer_asn}.
     *
     * @stability stable
     */
    readonly customerAsn?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#routing_registry_name ExpressRouteCircuitPeering#routing_registry_name}.
     *
     * @stability stable
     */
    readonly routingRegistryName?: string;
}
export declare function expressRouteCircuitPeeringIpv6MicrosoftPeeringToTerraform(struct?: ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference | ExpressRouteCircuitPeeringIpv6MicrosoftPeering): any;
/**
 * @stability stable
 */
export declare class ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteCircuitPeeringIpv6MicrosoftPeering | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteCircuitPeeringIpv6MicrosoftPeering | undefined);
    private _advertisedPublicPrefixes?;
    /**
     * @stability stable
     */
    get advertisedPublicPrefixes(): string[];
    /**
     * @stability stable
     */
    set advertisedPublicPrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetAdvertisedPublicPrefixes(): void;
    /**
     * @stability stable
     */
    get advertisedPublicPrefixesInput(): string[] | undefined;
    private _customerAsn?;
    /**
     * @stability stable
     */
    get customerAsn(): number;
    /**
     * @stability stable
     */
    set customerAsn(value: number);
    /**
     * @stability stable
     */
    resetCustomerAsn(): void;
    /**
     * @stability stable
     */
    get customerAsnInput(): number | undefined;
    private _routingRegistryName?;
    /**
     * @stability stable
     */
    get routingRegistryName(): string;
    /**
     * @stability stable
     */
    set routingRegistryName(value: string);
    /**
     * @stability stable
     */
    resetRoutingRegistryName(): void;
    /**
     * @stability stable
     */
    get routingRegistryNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRouteCircuitPeeringIpv6 {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#primary_peer_address_prefix ExpressRouteCircuitPeering#primary_peer_address_prefix}.
     *
     * @stability stable
     */
    readonly primaryPeerAddressPrefix: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#route_filter_id ExpressRouteCircuitPeering#route_filter_id}.
     *
     * @stability stable
     */
    readonly routeFilterId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#secondary_peer_address_prefix ExpressRouteCircuitPeering#secondary_peer_address_prefix}.
     *
     * @stability stable
     */
    readonly secondaryPeerAddressPrefix: string;
    /**
     * microsoft_peering block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#microsoft_peering ExpressRouteCircuitPeering#microsoft_peering}
     *
     * @stability stable
     */
    readonly microsoftPeering: ExpressRouteCircuitPeeringIpv6MicrosoftPeering;
}
export declare function expressRouteCircuitPeeringIpv6ToTerraform(struct?: ExpressRouteCircuitPeeringIpv6OutputReference | ExpressRouteCircuitPeeringIpv6): any;
/**
 * @stability stable
 */
export declare class ExpressRouteCircuitPeeringIpv6OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteCircuitPeeringIpv6 | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteCircuitPeeringIpv6 | undefined);
    private _primaryPeerAddressPrefix?;
    /**
     * @stability stable
     */
    get primaryPeerAddressPrefix(): string;
    /**
     * @stability stable
     */
    set primaryPeerAddressPrefix(value: string);
    /**
     * @stability stable
     */
    get primaryPeerAddressPrefixInput(): string | undefined;
    private _routeFilterId?;
    /**
     * @stability stable
     */
    get routeFilterId(): string;
    /**
     * @stability stable
     */
    set routeFilterId(value: string);
    /**
     * @stability stable
     */
    resetRouteFilterId(): void;
    /**
     * @stability stable
     */
    get routeFilterIdInput(): string | undefined;
    private _secondaryPeerAddressPrefix?;
    /**
     * @stability stable
     */
    get secondaryPeerAddressPrefix(): string;
    /**
     * @stability stable
     */
    set secondaryPeerAddressPrefix(value: string);
    /**
     * @stability stable
     */
    get secondaryPeerAddressPrefixInput(): string | undefined;
    private _microsoftPeering;
    /**
     * @stability stable
     */
    get microsoftPeering(): ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference;
    /**
     * @stability stable
     */
    putMicrosoftPeering(value: ExpressRouteCircuitPeeringIpv6MicrosoftPeering): void;
    /**
     * @stability stable
     */
    get microsoftPeeringInput(): ExpressRouteCircuitPeeringIpv6MicrosoftPeering | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRouteCircuitPeeringMicrosoftPeeringConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#advertised_public_prefixes ExpressRouteCircuitPeering#advertised_public_prefixes}.
     *
     * @stability stable
     */
    readonly advertisedPublicPrefixes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#customer_asn ExpressRouteCircuitPeering#customer_asn}.
     *
     * @stability stable
     */
    readonly customerAsn?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#routing_registry_name ExpressRouteCircuitPeering#routing_registry_name}.
     *
     * @stability stable
     */
    readonly routingRegistryName?: string;
}
export declare function expressRouteCircuitPeeringMicrosoftPeeringConfigToTerraform(struct?: ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference | ExpressRouteCircuitPeeringMicrosoftPeeringConfig): any;
/**
 * @stability stable
 */
export declare class ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteCircuitPeeringMicrosoftPeeringConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteCircuitPeeringMicrosoftPeeringConfig | undefined);
    private _advertisedPublicPrefixes?;
    /**
     * @stability stable
     */
    get advertisedPublicPrefixes(): string[];
    /**
     * @stability stable
     */
    set advertisedPublicPrefixes(value: string[]);
    /**
     * @stability stable
     */
    get advertisedPublicPrefixesInput(): string[] | undefined;
    private _customerAsn?;
    /**
     * @stability stable
     */
    get customerAsn(): number;
    /**
     * @stability stable
     */
    set customerAsn(value: number);
    /**
     * @stability stable
     */
    resetCustomerAsn(): void;
    /**
     * @stability stable
     */
    get customerAsnInput(): number | undefined;
    private _routingRegistryName?;
    /**
     * @stability stable
     */
    get routingRegistryName(): string;
    /**
     * @stability stable
     */
    set routingRegistryName(value: string);
    /**
     * @stability stable
     */
    resetRoutingRegistryName(): void;
    /**
     * @stability stable
     */
    get routingRegistryNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRouteCircuitPeeringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#create ExpressRouteCircuitPeering#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#delete ExpressRouteCircuitPeering#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#read ExpressRouteCircuitPeering#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#update ExpressRouteCircuitPeering#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function expressRouteCircuitPeeringTimeoutsToTerraform(struct?: ExpressRouteCircuitPeeringTimeoutsOutputReference | ExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ExpressRouteCircuitPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteCircuitPeeringTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteCircuitPeeringTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering azurerm_express_route_circuit_peering}.
 *
 * @stability stable
 */
export declare class ExpressRouteCircuitPeering extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering azurerm_express_route_circuit_peering} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExpressRouteCircuitPeeringConfig);
    /**
     * @stability stable
     */
    get azureAsn(): number;
    private _expressRouteCircuitName?;
    /**
     * @stability stable
     */
    get expressRouteCircuitName(): string;
    /**
     * @stability stable
     */
    set expressRouteCircuitName(value: string);
    /**
     * @stability stable
     */
    get expressRouteCircuitNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _peerAsn?;
    /**
     * @stability stable
     */
    get peerAsn(): number;
    /**
     * @stability stable
     */
    set peerAsn(value: number);
    /**
     * @stability stable
     */
    resetPeerAsn(): void;
    /**
     * @stability stable
     */
    get peerAsnInput(): number | undefined;
    private _peeringType?;
    /**
     * @stability stable
     */
    get peeringType(): string;
    /**
     * @stability stable
     */
    set peeringType(value: string);
    /**
     * @stability stable
     */
    get peeringTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAzurePort(): string;
    private _primaryPeerAddressPrefix?;
    /**
     * @stability stable
     */
    get primaryPeerAddressPrefix(): string;
    /**
     * @stability stable
     */
    set primaryPeerAddressPrefix(value: string);
    /**
     * @stability stable
     */
    get primaryPeerAddressPrefixInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _routeFilterId?;
    /**
     * @stability stable
     */
    get routeFilterId(): string;
    /**
     * @stability stable
     */
    set routeFilterId(value: string);
    /**
     * @stability stable
     */
    resetRouteFilterId(): void;
    /**
     * @stability stable
     */
    get routeFilterIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAzurePort(): string;
    private _secondaryPeerAddressPrefix?;
    /**
     * @stability stable
     */
    get secondaryPeerAddressPrefix(): string;
    /**
     * @stability stable
     */
    set secondaryPeerAddressPrefix(value: string);
    /**
     * @stability stable
     */
    get secondaryPeerAddressPrefixInput(): string | undefined;
    private _sharedKey?;
    /**
     * @stability stable
     */
    get sharedKey(): string;
    /**
     * @stability stable
     */
    set sharedKey(value: string);
    /**
     * @stability stable
     */
    resetSharedKey(): void;
    /**
     * @stability stable
     */
    get sharedKeyInput(): string | undefined;
    private _vlanId?;
    /**
     * @stability stable
     */
    get vlanId(): number;
    /**
     * @stability stable
     */
    set vlanId(value: number);
    /**
     * @stability stable
     */
    get vlanIdInput(): number | undefined;
    private _ipv6;
    /**
     * @stability stable
     */
    get ipv6(): ExpressRouteCircuitPeeringIpv6OutputReference;
    /**
     * @stability stable
     */
    putIpv6(value: ExpressRouteCircuitPeeringIpv6): void;
    /**
     * @stability stable
     */
    resetIpv6(): void;
    /**
     * @stability stable
     */
    get ipv6Input(): ExpressRouteCircuitPeeringIpv6 | undefined;
    private _microsoftPeeringConfig;
    /**
     * @stability stable
     */
    get microsoftPeeringConfig(): ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference;
    /**
     * @stability stable
     */
    putMicrosoftPeeringConfig(value: ExpressRouteCircuitPeeringMicrosoftPeeringConfig): void;
    /**
     * @stability stable
     */
    resetMicrosoftPeeringConfig(): void;
    /**
     * @stability stable
     */
    get microsoftPeeringConfigInput(): ExpressRouteCircuitPeeringMicrosoftPeeringConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ExpressRouteCircuitPeeringTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ExpressRouteCircuitPeeringTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ExpressRouteCircuitPeeringTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
