import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#cluster_version HdinsightInteractiveQueryCluster#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#encryption_in_transit_enabled HdinsightInteractiveQueryCluster#encryption_in_transit_enabled}.
     *
     * @stability stable
     */
    readonly encryptionInTransitEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#location HdinsightInteractiveQueryCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#name HdinsightInteractiveQueryCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#resource_group_name HdinsightInteractiveQueryCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#tags HdinsightInteractiveQueryCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#tier HdinsightInteractiveQueryCluster#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#tls_min_version HdinsightInteractiveQueryCluster#tls_min_version}.
     *
     * @stability stable
     */
    readonly tlsMinVersion?: string;
    /**
     * component_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#component_version HdinsightInteractiveQueryCluster#component_version}
     *
     * @stability stable
     */
    readonly componentVersion: HdinsightInteractiveQueryClusterComponentVersion;
    /**
     * gateway block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#gateway HdinsightInteractiveQueryCluster#gateway}
     *
     * @stability stable
     */
    readonly gateway: HdinsightInteractiveQueryClusterGateway;
    /**
     * metastores block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#metastores HdinsightInteractiveQueryCluster#metastores}
     *
     * @stability stable
     */
    readonly metastores?: HdinsightInteractiveQueryClusterMetastores;
    /**
     * monitor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#monitor HdinsightInteractiveQueryCluster#monitor}
     *
     * @stability stable
     */
    readonly monitor?: HdinsightInteractiveQueryClusterMonitor;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#network HdinsightInteractiveQueryCluster#network}
     *
     * @stability stable
     */
    readonly network?: HdinsightInteractiveQueryClusterNetwork;
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#roles HdinsightInteractiveQueryCluster#roles}
     *
     * @stability stable
     */
    readonly roles: HdinsightInteractiveQueryClusterRoles;
    /**
     * security_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#security_profile HdinsightInteractiveQueryCluster#security_profile}
     *
     * @stability stable
     */
    readonly securityProfile?: HdinsightInteractiveQueryClusterSecurityProfile;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_account HdinsightInteractiveQueryCluster#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount?: HdinsightInteractiveQueryClusterStorageAccount[] | cdktf.IResolvable;
    /**
     * storage_account_gen2 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_account_gen2 HdinsightInteractiveQueryCluster#storage_account_gen2}
     *
     * @stability stable
     */
    readonly storageAccountGen2?: HdinsightInteractiveQueryClusterStorageAccountGen2;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#timeouts HdinsightInteractiveQueryCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HdinsightInteractiveQueryClusterTimeouts;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterComponentVersion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#interactive_hive HdinsightInteractiveQueryCluster#interactive_hive}.
     *
     * @stability stable
     */
    readonly interactiveHive: string;
}
export declare function hdinsightInteractiveQueryClusterComponentVersionToTerraform(struct?: HdinsightInteractiveQueryClusterComponentVersionOutputReference | HdinsightInteractiveQueryClusterComponentVersion): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterComponentVersion | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterComponentVersion | undefined);
    private _interactiveHive?;
    /**
     * @stability stable
     */
    get interactiveHive(): string;
    /**
     * @stability stable
     */
    set interactiveHive(value: string);
    /**
     * @stability stable
     */
    get interactiveHiveInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterGateway {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#enabled HdinsightInteractiveQueryCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterGatewayToTerraform(struct?: HdinsightInteractiveQueryClusterGatewayOutputReference | HdinsightInteractiveQueryClusterGateway): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterGateway | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterGateway | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterMetastoresAmbari {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#database_name HdinsightInteractiveQueryCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#server HdinsightInteractiveQueryCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterMetastoresAmbariToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresAmbariOutputReference | HdinsightInteractiveQueryClusterMetastoresAmbari): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterMetastoresAmbari | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterMetastoresAmbari | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterMetastoresHive {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#database_name HdinsightInteractiveQueryCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#server HdinsightInteractiveQueryCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterMetastoresHiveToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresHiveOutputReference | HdinsightInteractiveQueryClusterMetastoresHive): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterMetastoresHive | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterMetastoresHive | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterMetastoresOozie {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#database_name HdinsightInteractiveQueryCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#server HdinsightInteractiveQueryCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightInteractiveQueryClusterMetastoresOozieToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresOozieOutputReference | HdinsightInteractiveQueryClusterMetastoresOozie): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterMetastoresOozie | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterMetastoresOozie | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterMetastores {
    /**
     * ambari block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ambari HdinsightInteractiveQueryCluster#ambari}
     *
     * @stability stable
     */
    readonly ambari?: HdinsightInteractiveQueryClusterMetastoresAmbari;
    /**
     * hive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#hive HdinsightInteractiveQueryCluster#hive}
     *
     * @stability stable
     */
    readonly hive?: HdinsightInteractiveQueryClusterMetastoresHive;
    /**
     * oozie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#oozie HdinsightInteractiveQueryCluster#oozie}
     *
     * @stability stable
     */
    readonly oozie?: HdinsightInteractiveQueryClusterMetastoresOozie;
}
export declare function hdinsightInteractiveQueryClusterMetastoresToTerraform(struct?: HdinsightInteractiveQueryClusterMetastoresOutputReference | HdinsightInteractiveQueryClusterMetastores): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterMetastores | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterMetastores | undefined);
    private _ambari;
    /**
     * @stability stable
     */
    get ambari(): HdinsightInteractiveQueryClusterMetastoresAmbariOutputReference;
    /**
     * @stability stable
     */
    putAmbari(value: HdinsightInteractiveQueryClusterMetastoresAmbari): void;
    /**
     * @stability stable
     */
    resetAmbari(): void;
    /**
     * @stability stable
     */
    get ambariInput(): HdinsightInteractiveQueryClusterMetastoresAmbari | undefined;
    private _hive;
    /**
     * @stability stable
     */
    get hive(): HdinsightInteractiveQueryClusterMetastoresHiveOutputReference;
    /**
     * @stability stable
     */
    putHive(value: HdinsightInteractiveQueryClusterMetastoresHive): void;
    /**
     * @stability stable
     */
    resetHive(): void;
    /**
     * @stability stable
     */
    get hiveInput(): HdinsightInteractiveQueryClusterMetastoresHive | undefined;
    private _oozie;
    /**
     * @stability stable
     */
    get oozie(): HdinsightInteractiveQueryClusterMetastoresOozieOutputReference;
    /**
     * @stability stable
     */
    putOozie(value: HdinsightInteractiveQueryClusterMetastoresOozie): void;
    /**
     * @stability stable
     */
    resetOozie(): void;
    /**
     * @stability stable
     */
    get oozieInput(): HdinsightInteractiveQueryClusterMetastoresOozie | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterMonitor {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#log_analytics_workspace_id HdinsightInteractiveQueryCluster#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#primary_key HdinsightInteractiveQueryCluster#primary_key}.
     *
     * @stability stable
     */
    readonly primaryKey: string;
}
export declare function hdinsightInteractiveQueryClusterMonitorToTerraform(struct?: HdinsightInteractiveQueryClusterMonitorOutputReference | HdinsightInteractiveQueryClusterMonitor): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterMonitor | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    set primaryKey(value: string);
    /**
     * @stability stable
     */
    get primaryKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterNetwork {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#connection_direction HdinsightInteractiveQueryCluster#connection_direction}.
     *
     * @stability stable
     */
    readonly connectionDirection?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#private_link_enabled HdinsightInteractiveQueryCluster#private_link_enabled}.
     *
     * @stability stable
     */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightInteractiveQueryClusterNetworkToTerraform(struct?: HdinsightInteractiveQueryClusterNetworkOutputReference | HdinsightInteractiveQueryClusterNetwork): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterNetwork | undefined);
    private _connectionDirection?;
    /**
     * @stability stable
     */
    get connectionDirection(): string;
    /**
     * @stability stable
     */
    set connectionDirection(value: string);
    /**
     * @stability stable
     */
    resetConnectionDirection(): void;
    /**
     * @stability stable
     */
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    /**
     * @stability stable
     */
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateLinkEnabled(): void;
    /**
     * @stability stable
     */
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRolesHeadNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ssh_keys HdinsightInteractiveQueryCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#subnet_id HdinsightInteractiveQueryCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#virtual_network_id HdinsightInteractiveQueryCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#vm_size HdinsightInteractiveQueryCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightInteractiveQueryClusterRolesHeadNodeToTerraform(struct?: HdinsightInteractiveQueryClusterRolesHeadNodeOutputReference | HdinsightInteractiveQueryClusterRolesHeadNode): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterRolesHeadNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterRolesHeadNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#max_instance_count HdinsightInteractiveQueryCluster#max_instance_count}.
     *
     * @stability stable
     */
    readonly maxInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#min_instance_count HdinsightInteractiveQueryCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount: number;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity | undefined);
    private _maxInstanceCount?;
    /**
     * @stability stable
     */
    get maxInstanceCount(): number;
    /**
     * @stability stable
     */
    set maxInstanceCount(value: number);
    /**
     * @stability stable
     */
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#days HdinsightInteractiveQueryCluster#days}.
     *
     * @stability stable
     */
    readonly days: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#target_instance_count HdinsightInteractiveQueryCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#time HdinsightInteractiveQueryCluster#time}.
     *
     * @stability stable
     */
    readonly time: string;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#timezone HdinsightInteractiveQueryCluster#timezone}.
     *
     * @stability stable
     */
    readonly timezone: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#schedule HdinsightInteractiveQueryCluster#schedule}
     *
     * @stability stable
     */
    readonly schedule: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence | undefined);
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set schedule(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get scheduleInput(): cdktf.IResolvable | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale {
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#capacity HdinsightInteractiveQueryCluster#capacity}
     *
     * @stability stable
     */
    readonly capacity?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity;
    /**
     * recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#recurrence HdinsightInteractiveQueryCluster#recurrence}
     *
     * @stability stable
     */
    readonly recurrence?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale | undefined);
    private _capacity;
    /**
     * @stability stable
     */
    get capacity(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacityOutputReference;
    /**
     * @stability stable
     */
    putCapacity(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity): void;
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    private _recurrence;
    /**
     * @stability stable
     */
    get recurrence(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putRecurrence(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence): void;
    /**
     * @stability stable
     */
    resetRecurrence(): void;
    /**
     * @stability stable
     */
    get recurrenceInput(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRolesWorkerNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#min_instance_count HdinsightInteractiveQueryCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ssh_keys HdinsightInteractiveQueryCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#subnet_id HdinsightInteractiveQueryCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#target_instance_count HdinsightInteractiveQueryCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#virtual_network_id HdinsightInteractiveQueryCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#vm_size HdinsightInteractiveQueryCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * autoscale block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#autoscale HdinsightInteractiveQueryCluster#autoscale}
     *
     * @stability stable
     */
    readonly autoscale?: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale;
}
export declare function hdinsightInteractiveQueryClusterRolesWorkerNodeToTerraform(struct?: HdinsightInteractiveQueryClusterRolesWorkerNodeOutputReference | HdinsightInteractiveQueryClusterRolesWorkerNode): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterRolesWorkerNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterRolesWorkerNode | undefined);
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetMinInstanceCount(): void;
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    /**
     * @stability stable
     */
    get targetInstanceCount(): number;
    /**
     * @stability stable
     */
    set targetInstanceCount(value: number);
    /**
     * @stability stable
     */
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _autoscale;
    /**
     * @stability stable
     */
    get autoscale(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscaleOutputReference;
    /**
     * @stability stable
     */
    putAutoscale(value: HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale): void;
    /**
     * @stability stable
     */
    resetAutoscale(): void;
    /**
     * @stability stable
     */
    get autoscaleInput(): HdinsightInteractiveQueryClusterRolesWorkerNodeAutoscale | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRolesZookeeperNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#password HdinsightInteractiveQueryCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ssh_keys HdinsightInteractiveQueryCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#subnet_id HdinsightInteractiveQueryCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#username HdinsightInteractiveQueryCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#virtual_network_id HdinsightInteractiveQueryCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#vm_size HdinsightInteractiveQueryCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightInteractiveQueryClusterRolesZookeeperNodeToTerraform(struct?: HdinsightInteractiveQueryClusterRolesZookeeperNodeOutputReference | HdinsightInteractiveQueryClusterRolesZookeeperNode): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterRolesZookeeperNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterRolesZookeeperNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterRoles {
    /**
     * head_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#head_node HdinsightInteractiveQueryCluster#head_node}
     *
     * @stability stable
     */
    readonly headNode: HdinsightInteractiveQueryClusterRolesHeadNode;
    /**
     * worker_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#worker_node HdinsightInteractiveQueryCluster#worker_node}
     *
     * @stability stable
     */
    readonly workerNode: HdinsightInteractiveQueryClusterRolesWorkerNode;
    /**
     * zookeeper_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#zookeeper_node HdinsightInteractiveQueryCluster#zookeeper_node}
     *
     * @stability stable
     */
    readonly zookeeperNode: HdinsightInteractiveQueryClusterRolesZookeeperNode;
}
export declare function hdinsightInteractiveQueryClusterRolesToTerraform(struct?: HdinsightInteractiveQueryClusterRolesOutputReference | HdinsightInteractiveQueryClusterRoles): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterRoles | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterRoles | undefined);
    private _headNode;
    /**
     * @stability stable
     */
    get headNode(): HdinsightInteractiveQueryClusterRolesHeadNodeOutputReference;
    /**
     * @stability stable
     */
    putHeadNode(value: HdinsightInteractiveQueryClusterRolesHeadNode): void;
    /**
     * @stability stable
     */
    get headNodeInput(): HdinsightInteractiveQueryClusterRolesHeadNode | undefined;
    private _workerNode;
    /**
     * @stability stable
     */
    get workerNode(): HdinsightInteractiveQueryClusterRolesWorkerNodeOutputReference;
    /**
     * @stability stable
     */
    putWorkerNode(value: HdinsightInteractiveQueryClusterRolesWorkerNode): void;
    /**
     * @stability stable
     */
    get workerNodeInput(): HdinsightInteractiveQueryClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    /**
     * @stability stable
     */
    get zookeeperNode(): HdinsightInteractiveQueryClusterRolesZookeeperNodeOutputReference;
    /**
     * @stability stable
     */
    putZookeeperNode(value: HdinsightInteractiveQueryClusterRolesZookeeperNode): void;
    /**
     * @stability stable
     */
    get zookeeperNodeInput(): HdinsightInteractiveQueryClusterRolesZookeeperNode | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterSecurityProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#aadds_resource_id HdinsightInteractiveQueryCluster#aadds_resource_id}.
     *
     * @stability stable
     */
    readonly aaddsResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#cluster_users_group_dns HdinsightInteractiveQueryCluster#cluster_users_group_dns}.
     *
     * @stability stable
     */
    readonly clusterUsersGroupDns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#domain_name HdinsightInteractiveQueryCluster#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#domain_user_password HdinsightInteractiveQueryCluster#domain_user_password}.
     *
     * @stability stable
     */
    readonly domainUserPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#domain_username HdinsightInteractiveQueryCluster#domain_username}.
     *
     * @stability stable
     */
    readonly domainUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#ldaps_urls HdinsightInteractiveQueryCluster#ldaps_urls}.
     *
     * @stability stable
     */
    readonly ldapsUrls: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#msi_resource_id HdinsightInteractiveQueryCluster#msi_resource_id}.
     *
     * @stability stable
     */
    readonly msiResourceId: string;
}
export declare function hdinsightInteractiveQueryClusterSecurityProfileToTerraform(struct?: HdinsightInteractiveQueryClusterSecurityProfileOutputReference | HdinsightInteractiveQueryClusterSecurityProfile): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterSecurityProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    /**
     * @stability stable
     */
    get aaddsResourceId(): string;
    /**
     * @stability stable
     */
    set aaddsResourceId(value: string);
    /**
     * @stability stable
     */
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    /**
     * @stability stable
     */
    get clusterUsersGroupDns(): string[];
    /**
     * @stability stable
     */
    set clusterUsersGroupDns(value: string[]);
    /**
     * @stability stable
     */
    resetClusterUsersGroupDns(): void;
    /**
     * @stability stable
     */
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    /**
     * @stability stable
     */
    get domainUserPassword(): string;
    /**
     * @stability stable
     */
    set domainUserPassword(value: string);
    /**
     * @stability stable
     */
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    /**
     * @stability stable
     */
    get domainUsername(): string;
    /**
     * @stability stable
     */
    set domainUsername(value: string);
    /**
     * @stability stable
     */
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    /**
     * @stability stable
     */
    get ldapsUrls(): string[];
    /**
     * @stability stable
     */
    set ldapsUrls(value: string[]);
    /**
     * @stability stable
     */
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    /**
     * @stability stable
     */
    get msiResourceId(): string;
    /**
     * @stability stable
     */
    set msiResourceId(value: string);
    /**
     * @stability stable
     */
    get msiResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#is_default HdinsightInteractiveQueryCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_account_key HdinsightInteractiveQueryCluster#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_container_id HdinsightInteractiveQueryCluster#storage_container_id}.
     *
     * @stability stable
     */
    readonly storageContainerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_resource_id HdinsightInteractiveQueryCluster#storage_resource_id}.
     *
     * @stability stable
     */
    readonly storageResourceId?: string;
}
export declare function hdinsightInteractiveQueryClusterStorageAccountToTerraform(struct?: HdinsightInteractiveQueryClusterStorageAccount | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterStorageAccountGen2 {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#filesystem_id HdinsightInteractiveQueryCluster#filesystem_id}.
     *
     * @stability stable
     */
    readonly filesystemId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#is_default HdinsightInteractiveQueryCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#managed_identity_resource_id HdinsightInteractiveQueryCluster#managed_identity_resource_id}.
     *
     * @stability stable
     */
    readonly managedIdentityResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#storage_resource_id HdinsightInteractiveQueryCluster#storage_resource_id}.
     *
     * @stability stable
     */
    readonly storageResourceId: string;
}
export declare function hdinsightInteractiveQueryClusterStorageAccountGen2ToTerraform(struct?: HdinsightInteractiveQueryClusterStorageAccountGen2OutputReference | HdinsightInteractiveQueryClusterStorageAccountGen2): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterStorageAccountGen2 | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    /**
     * @stability stable
     */
    get filesystemId(): string;
    /**
     * @stability stable
     */
    set filesystemId(value: string);
    /**
     * @stability stable
     */
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    /**
     * @stability stable
     */
    get isDefault(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isDefault(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    /**
     * @stability stable
     */
    get managedIdentityResourceId(): string;
    /**
     * @stability stable
     */
    set managedIdentityResourceId(value: string);
    /**
     * @stability stable
     */
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    /**
     * @stability stable
     */
    get storageResourceId(): string;
    /**
     * @stability stable
     */
    set storageResourceId(value: string);
    /**
     * @stability stable
     */
    get storageResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightInteractiveQueryClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#create HdinsightInteractiveQueryCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#delete HdinsightInteractiveQueryCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#read HdinsightInteractiveQueryCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster#update HdinsightInteractiveQueryCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hdinsightInteractiveQueryClusterTimeoutsToTerraform(struct?: HdinsightInteractiveQueryClusterTimeoutsOutputReference | HdinsightInteractiveQueryClusterTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class HdinsightInteractiveQueryClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightInteractiveQueryClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightInteractiveQueryClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster azurerm_hdinsight_interactive_query_cluster}.
 *
 * @stability stable
 */
export declare class HdinsightInteractiveQueryCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_interactive_query_cluster azurerm_hdinsight_interactive_query_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HdinsightInteractiveQueryClusterConfig);
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    set clusterVersion(value: string);
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    private _encryptionInTransitEnabled?;
    /**
     * @stability stable
     */
    get encryptionInTransitEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionInTransitEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionInTransitEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionInTransitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get httpsEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sshEndpoint(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    /**
     * @stability stable
     */
    get tlsMinVersion(): string;
    /**
     * @stability stable
     */
    set tlsMinVersion(value: string);
    /**
     * @stability stable
     */
    resetTlsMinVersion(): void;
    /**
     * @stability stable
     */
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    /**
     * @stability stable
     */
    get componentVersion(): HdinsightInteractiveQueryClusterComponentVersionOutputReference;
    /**
     * @stability stable
     */
    putComponentVersion(value: HdinsightInteractiveQueryClusterComponentVersion): void;
    /**
     * @stability stable
     */
    get componentVersionInput(): HdinsightInteractiveQueryClusterComponentVersion | undefined;
    private _gateway;
    /**
     * @stability stable
     */
    get gateway(): HdinsightInteractiveQueryClusterGatewayOutputReference;
    /**
     * @stability stable
     */
    putGateway(value: HdinsightInteractiveQueryClusterGateway): void;
    /**
     * @stability stable
     */
    get gatewayInput(): HdinsightInteractiveQueryClusterGateway | undefined;
    private _metastores;
    /**
     * @stability stable
     */
    get metastores(): HdinsightInteractiveQueryClusterMetastoresOutputReference;
    /**
     * @stability stable
     */
    putMetastores(value: HdinsightInteractiveQueryClusterMetastores): void;
    /**
     * @stability stable
     */
    resetMetastores(): void;
    /**
     * @stability stable
     */
    get metastoresInput(): HdinsightInteractiveQueryClusterMetastores | undefined;
    private _monitor;
    /**
     * @stability stable
     */
    get monitor(): HdinsightInteractiveQueryClusterMonitorOutputReference;
    /**
     * @stability stable
     */
    putMonitor(value: HdinsightInteractiveQueryClusterMonitor): void;
    /**
     * @stability stable
     */
    resetMonitor(): void;
    /**
     * @stability stable
     */
    get monitorInput(): HdinsightInteractiveQueryClusterMonitor | undefined;
    private _network;
    /**
     * @stability stable
     */
    get network(): HdinsightInteractiveQueryClusterNetworkOutputReference;
    /**
     * @stability stable
     */
    putNetwork(value: HdinsightInteractiveQueryClusterNetwork): void;
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): HdinsightInteractiveQueryClusterNetwork | undefined;
    private _roles;
    /**
     * @stability stable
     */
    get roles(): HdinsightInteractiveQueryClusterRolesOutputReference;
    /**
     * @stability stable
     */
    putRoles(value: HdinsightInteractiveQueryClusterRoles): void;
    /**
     * @stability stable
     */
    get rolesInput(): HdinsightInteractiveQueryClusterRoles | undefined;
    private _securityProfile;
    /**
     * @stability stable
     */
    get securityProfile(): HdinsightInteractiveQueryClusterSecurityProfileOutputReference;
    /**
     * @stability stable
     */
    putSecurityProfile(value: HdinsightInteractiveQueryClusterSecurityProfile): void;
    /**
     * @stability stable
     */
    resetSecurityProfile(): void;
    /**
     * @stability stable
     */
    get securityProfileInput(): HdinsightInteractiveQueryClusterSecurityProfile | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): HdinsightInteractiveQueryClusterStorageAccount[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set storageAccount(value: HdinsightInteractiveQueryClusterStorageAccount[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStorageAccount(): void;
    /**
     * @stability stable
     */
    get storageAccountInput(): cdktf.IResolvable | HdinsightInteractiveQueryClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    /**
     * @stability stable
     */
    get storageAccountGen2(): HdinsightInteractiveQueryClusterStorageAccountGen2OutputReference;
    /**
     * @stability stable
     */
    putStorageAccountGen2(value: HdinsightInteractiveQueryClusterStorageAccountGen2): void;
    /**
     * @stability stable
     */
    resetStorageAccountGen2(): void;
    /**
     * @stability stable
     */
    get storageAccountGen2Input(): HdinsightInteractiveQueryClusterStorageAccountGen2 | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HdinsightInteractiveQueryClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HdinsightInteractiveQueryClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HdinsightInteractiveQueryClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
