import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogAnalyticsStorageInsightsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#blob_container_names LogAnalyticsStorageInsights#blob_container_names}.
     *
     * @stability stable
     */
    readonly blobContainerNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#name LogAnalyticsStorageInsights#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#resource_group_name LogAnalyticsStorageInsights#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#storage_account_id LogAnalyticsStorageInsights#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#storage_account_key LogAnalyticsStorageInsights#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#table_names LogAnalyticsStorageInsights#table_names}.
     *
     * @stability stable
     */
    readonly tableNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#tags LogAnalyticsStorageInsights#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#workspace_id LogAnalyticsStorageInsights#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#timeouts LogAnalyticsStorageInsights#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogAnalyticsStorageInsightsTimeouts;
}
/**
 * @stability stable
 */
export interface LogAnalyticsStorageInsightsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#create LogAnalyticsStorageInsights#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#delete LogAnalyticsStorageInsights#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#read LogAnalyticsStorageInsights#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights#update LogAnalyticsStorageInsights#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logAnalyticsStorageInsightsTimeoutsToTerraform(struct?: LogAnalyticsStorageInsightsTimeoutsOutputReference | LogAnalyticsStorageInsightsTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class LogAnalyticsStorageInsightsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogAnalyticsStorageInsightsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogAnalyticsStorageInsightsTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights azurerm_log_analytics_storage_insights}.
 *
 * @stability stable
 */
export declare class LogAnalyticsStorageInsights extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_storage_insights azurerm_log_analytics_storage_insights} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogAnalyticsStorageInsightsConfig);
    private _blobContainerNames?;
    /**
     * @stability stable
     */
    get blobContainerNames(): string[];
    /**
     * @stability stable
     */
    set blobContainerNames(value: string[]);
    /**
     * @stability stable
     */
    resetBlobContainerNames(): void;
    /**
     * @stability stable
     */
    get blobContainerNamesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageAccountKey?;
    /**
     * @stability stable
     */
    get storageAccountKey(): string;
    /**
     * @stability stable
     */
    set storageAccountKey(value: string);
    /**
     * @stability stable
     */
    get storageAccountKeyInput(): string | undefined;
    private _tableNames?;
    /**
     * @stability stable
     */
    get tableNames(): string[];
    /**
     * @stability stable
     */
    set tableNames(value: string[]);
    /**
     * @stability stable
     */
    resetTableNames(): void;
    /**
     * @stability stable
     */
    get tableNamesInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    set workspaceId(value: string);
    /**
     * @stability stable
     */
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogAnalyticsStorageInsightsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogAnalyticsStorageInsightsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogAnalyticsStorageInsightsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
