import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaTransformConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#description MediaTransform#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#media_services_account_name MediaTransform#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#name MediaTransform#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#resource_group_name MediaTransform#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * output block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#output MediaTransform#output}
     *
     * @stability stable
     */
    readonly output?: MediaTransformOutput[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#timeouts MediaTransform#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaTransformTimeouts;
}
/**
 * @stability stable
 */
export interface MediaTransformOutputAudioAnalyzerPreset {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_analysis_mode MediaTransform#audio_analysis_mode}.
     *
     * @stability stable
     */
    readonly audioAnalysisMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_language MediaTransform#audio_language}.
     *
     * @stability stable
     */
    readonly audioLanguage?: string;
}
export declare function mediaTransformOutputAudioAnalyzerPresetToTerraform(struct?: MediaTransformOutputAudioAnalyzerPresetOutputReference | MediaTransformOutputAudioAnalyzerPreset): any;
/**
 * @stability stable
 */
export declare class MediaTransformOutputAudioAnalyzerPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaTransformOutputAudioAnalyzerPreset | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaTransformOutputAudioAnalyzerPreset | undefined);
    private _audioAnalysisMode?;
    /**
     * @stability stable
     */
    get audioAnalysisMode(): string;
    /**
     * @stability stable
     */
    set audioAnalysisMode(value: string);
    /**
     * @stability stable
     */
    resetAudioAnalysisMode(): void;
    /**
     * @stability stable
     */
    get audioAnalysisModeInput(): string | undefined;
    private _audioLanguage?;
    /**
     * @stability stable
     */
    get audioLanguage(): string;
    /**
     * @stability stable
     */
    set audioLanguage(value: string);
    /**
     * @stability stable
     */
    resetAudioLanguage(): void;
    /**
     * @stability stable
     */
    get audioLanguageInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaTransformOutputBuiltinPreset {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#preset_name MediaTransform#preset_name}.
     *
     * @stability stable
     */
    readonly presetName?: string;
}
export declare function mediaTransformOutputBuiltinPresetToTerraform(struct?: MediaTransformOutputBuiltinPresetOutputReference | MediaTransformOutputBuiltinPreset): any;
/**
 * @stability stable
 */
export declare class MediaTransformOutputBuiltinPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaTransformOutputBuiltinPreset | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaTransformOutputBuiltinPreset | undefined);
    private _presetName?;
    /**
     * @stability stable
     */
    get presetName(): string;
    /**
     * @stability stable
     */
    set presetName(value: string);
    /**
     * @stability stable
     */
    resetPresetName(): void;
    /**
     * @stability stable
     */
    get presetNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaTransformOutputFaceDetectorPreset {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#analysis_resolution MediaTransform#analysis_resolution}.
     *
     * @stability stable
     */
    readonly analysisResolution?: string;
}
export declare function mediaTransformOutputFaceDetectorPresetToTerraform(struct?: MediaTransformOutputFaceDetectorPresetOutputReference | MediaTransformOutputFaceDetectorPreset): any;
/**
 * @stability stable
 */
export declare class MediaTransformOutputFaceDetectorPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaTransformOutputFaceDetectorPreset | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaTransformOutputFaceDetectorPreset | undefined);
    private _analysisResolution?;
    /**
     * @stability stable
     */
    get analysisResolution(): string;
    /**
     * @stability stable
     */
    set analysisResolution(value: string);
    /**
     * @stability stable
     */
    resetAnalysisResolution(): void;
    /**
     * @stability stable
     */
    get analysisResolutionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaTransformOutputVideoAnalyzerPreset {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_analysis_mode MediaTransform#audio_analysis_mode}.
     *
     * @stability stable
     */
    readonly audioAnalysisMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_language MediaTransform#audio_language}.
     *
     * @stability stable
     */
    readonly audioLanguage?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#insights_type MediaTransform#insights_type}.
     *
     * @stability stable
     */
    readonly insightsType?: string;
}
export declare function mediaTransformOutputVideoAnalyzerPresetToTerraform(struct?: MediaTransformOutputVideoAnalyzerPresetOutputReference | MediaTransformOutputVideoAnalyzerPreset): any;
/**
 * @stability stable
 */
export declare class MediaTransformOutputVideoAnalyzerPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaTransformOutputVideoAnalyzerPreset | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaTransformOutputVideoAnalyzerPreset | undefined);
    private _audioAnalysisMode?;
    /**
     * @stability stable
     */
    get audioAnalysisMode(): string;
    /**
     * @stability stable
     */
    set audioAnalysisMode(value: string);
    /**
     * @stability stable
     */
    resetAudioAnalysisMode(): void;
    /**
     * @stability stable
     */
    get audioAnalysisModeInput(): string | undefined;
    private _audioLanguage?;
    /**
     * @stability stable
     */
    get audioLanguage(): string;
    /**
     * @stability stable
     */
    set audioLanguage(value: string);
    /**
     * @stability stable
     */
    resetAudioLanguage(): void;
    /**
     * @stability stable
     */
    get audioLanguageInput(): string | undefined;
    private _insightsType?;
    /**
     * @stability stable
     */
    get insightsType(): string;
    /**
     * @stability stable
     */
    set insightsType(value: string);
    /**
     * @stability stable
     */
    resetInsightsType(): void;
    /**
     * @stability stable
     */
    get insightsTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaTransformOutput {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#on_error_action MediaTransform#on_error_action}.
     *
     * @stability stable
     */
    readonly onErrorAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#relative_priority MediaTransform#relative_priority}.
     *
     * @stability stable
     */
    readonly relativePriority?: string;
    /**
     * audio_analyzer_preset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_analyzer_preset MediaTransform#audio_analyzer_preset}
     *
     * @stability stable
     */
    readonly audioAnalyzerPreset?: MediaTransformOutputAudioAnalyzerPreset;
    /**
     * builtin_preset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#builtin_preset MediaTransform#builtin_preset}
     *
     * @stability stable
     */
    readonly builtinPreset?: MediaTransformOutputBuiltinPreset;
    /**
     * face_detector_preset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#face_detector_preset MediaTransform#face_detector_preset}
     *
     * @stability stable
     */
    readonly faceDetectorPreset?: MediaTransformOutputFaceDetectorPreset;
    /**
     * video_analyzer_preset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#video_analyzer_preset MediaTransform#video_analyzer_preset}
     *
     * @stability stable
     */
    readonly videoAnalyzerPreset?: MediaTransformOutputVideoAnalyzerPreset;
}
export declare function mediaTransformOutputToTerraform(struct?: MediaTransformOutput | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MediaTransformTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#create MediaTransform#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#delete MediaTransform#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#read MediaTransform#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#update MediaTransform#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaTransformTimeoutsToTerraform(struct?: MediaTransformTimeoutsOutputReference | MediaTransformTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MediaTransformTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaTransformTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaTransformTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform azurerm_media_transform}.
 *
 * @stability stable
 */
export declare class MediaTransform extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform azurerm_media_transform} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaTransformConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _output?;
    /**
     * @stability stable
     */
    get output(): MediaTransformOutput[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set output(value: MediaTransformOutput[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOutput(): void;
    /**
     * @stability stable
     */
    get outputInput(): cdktf.IResolvable | MediaTransformOutput[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaTransformTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaTransformTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaTransformTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
