import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityCenterAutoProvisioningConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#auto_provision SecurityCenterAutoProvisioning#auto_provision}.
     *
     * @stability stable
     */
    readonly autoProvision: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#timeouts SecurityCenterAutoProvisioning#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecurityCenterAutoProvisioningTimeouts;
}
/**
 * @stability stable
 */
export interface SecurityCenterAutoProvisioningTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#create SecurityCenterAutoProvisioning#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#delete SecurityCenterAutoProvisioning#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#read SecurityCenterAutoProvisioning#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#update SecurityCenterAutoProvisioning#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function securityCenterAutoProvisioningTimeoutsToTerraform(struct?: SecurityCenterAutoProvisioningTimeoutsOutputReference | SecurityCenterAutoProvisioningTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SecurityCenterAutoProvisioningTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecurityCenterAutoProvisioningTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecurityCenterAutoProvisioningTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning azurerm_security_center_auto_provisioning}.
 *
 * @stability stable
 */
export declare class SecurityCenterAutoProvisioning extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning azurerm_security_center_auto_provisioning} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurityCenterAutoProvisioningConfig);
    private _autoProvision?;
    /**
     * @stability stable
     */
    get autoProvision(): string;
    /**
     * @stability stable
     */
    set autoProvision(value: string);
    /**
     * @stability stable
     */
    get autoProvisionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecurityCenterAutoProvisioningTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecurityCenterAutoProvisioningTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecurityCenterAutoProvisioningTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
