import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceFabricClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#add_on_features ServiceFabricCluster#add_on_features}.
     *
     * @stability stable
     */
    readonly addOnFeatures?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#cluster_code_version ServiceFabricCluster#cluster_code_version}.
     *
     * @stability stable
     */
    readonly clusterCodeVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#location ServiceFabricCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#management_endpoint ServiceFabricCluster#management_endpoint}.
     *
     * @stability stable
     */
    readonly managementEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#name ServiceFabricCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#reliability_level ServiceFabricCluster#reliability_level}.
     *
     * @stability stable
     */
    readonly reliabilityLevel: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#resource_group_name ServiceFabricCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#service_fabric_zonal_upgrade_mode ServiceFabricCluster#service_fabric_zonal_upgrade_mode}.
     *
     * @stability stable
     */
    readonly serviceFabricZonalUpgradeMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#tags ServiceFabricCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#upgrade_mode ServiceFabricCluster#upgrade_mode}.
     *
     * @stability stable
     */
    readonly upgradeMode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#vm_image ServiceFabricCluster#vm_image}.
     *
     * @stability stable
     */
    readonly vmImage: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#vmss_zonal_upgrade_mode ServiceFabricCluster#vmss_zonal_upgrade_mode}.
     *
     * @stability stable
     */
    readonly vmssZonalUpgradeMode?: string;
    /**
     * azure_active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#azure_active_directory ServiceFabricCluster#azure_active_directory}
     *
     * @stability stable
     */
    readonly azureActiveDirectory?: ServiceFabricClusterAzureActiveDirectory;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#certificate ServiceFabricCluster#certificate}
     *
     * @stability stable
     */
    readonly certificate?: ServiceFabricClusterCertificate;
    /**
     * certificate_common_names block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#certificate_common_names ServiceFabricCluster#certificate_common_names}
     *
     * @stability stable
     */
    readonly certificateCommonNames?: ServiceFabricClusterCertificateCommonNames;
    /**
     * client_certificate_common_name block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#client_certificate_common_name ServiceFabricCluster#client_certificate_common_name}
     *
     * @stability stable
     */
    readonly clientCertificateCommonName?: ServiceFabricClusterClientCertificateCommonName[] | cdktf.IResolvable;
    /**
     * client_certificate_thumbprint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#client_certificate_thumbprint ServiceFabricCluster#client_certificate_thumbprint}
     *
     * @stability stable
     */
    readonly clientCertificateThumbprint?: ServiceFabricClusterClientCertificateThumbprint[] | cdktf.IResolvable;
    /**
     * diagnostics_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#diagnostics_config ServiceFabricCluster#diagnostics_config}
     *
     * @stability stable
     */
    readonly diagnosticsConfig?: ServiceFabricClusterDiagnosticsConfig;
    /**
     * fabric_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#fabric_settings ServiceFabricCluster#fabric_settings}
     *
     * @stability stable
     */
    readonly fabricSettings?: ServiceFabricClusterFabricSettings[] | cdktf.IResolvable;
    /**
     * node_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#node_type ServiceFabricCluster#node_type}
     *
     * @stability stable
     */
    readonly nodeType: ServiceFabricClusterNodeType[] | cdktf.IResolvable;
    /**
     * reverse_proxy_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#reverse_proxy_certificate ServiceFabricCluster#reverse_proxy_certificate}
     *
     * @stability stable
     */
    readonly reverseProxyCertificate?: ServiceFabricClusterReverseProxyCertificate;
    /**
     * reverse_proxy_certificate_common_names block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#reverse_proxy_certificate_common_names ServiceFabricCluster#reverse_proxy_certificate_common_names}
     *
     * @stability stable
     */
    readonly reverseProxyCertificateCommonNames?: ServiceFabricClusterReverseProxyCertificateCommonNames;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#timeouts ServiceFabricCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceFabricClusterTimeouts;
    /**
     * upgrade_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#upgrade_policy ServiceFabricCluster#upgrade_policy}
     *
     * @stability stable
     */
    readonly upgradePolicy?: ServiceFabricClusterUpgradePolicy;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterAzureActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#client_application_id ServiceFabricCluster#client_application_id}.
     *
     * @stability stable
     */
    readonly clientApplicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#cluster_application_id ServiceFabricCluster#cluster_application_id}.
     *
     * @stability stable
     */
    readonly clusterApplicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#tenant_id ServiceFabricCluster#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
}
export declare function serviceFabricClusterAzureActiveDirectoryToTerraform(struct?: ServiceFabricClusterAzureActiveDirectoryOutputReference | ServiceFabricClusterAzureActiveDirectory): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterAzureActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterAzureActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterAzureActiveDirectory | undefined);
    private _clientApplicationId?;
    /**
     * @stability stable
     */
    get clientApplicationId(): string;
    /**
     * @stability stable
     */
    set clientApplicationId(value: string);
    /**
     * @stability stable
     */
    get clientApplicationIdInput(): string | undefined;
    private _clusterApplicationId?;
    /**
     * @stability stable
     */
    get clusterApplicationId(): string;
    /**
     * @stability stable
     */
    set clusterApplicationId(value: string);
    /**
     * @stability stable
     */
    get clusterApplicationIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#thumbprint ServiceFabricCluster#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#thumbprint_secondary ServiceFabricCluster#thumbprint_secondary}.
     *
     * @stability stable
     */
    readonly thumbprintSecondary?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}.
     *
     * @stability stable
     */
    readonly x509StoreName: string;
}
export declare function serviceFabricClusterCertificateToTerraform(struct?: ServiceFabricClusterCertificateOutputReference | ServiceFabricClusterCertificate): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterCertificate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterCertificate | undefined);
    private _thumbprint?;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    /**
     * @stability stable
     */
    set thumbprint(value: string);
    /**
     * @stability stable
     */
    get thumbprintInput(): string | undefined;
    private _thumbprintSecondary?;
    /**
     * @stability stable
     */
    get thumbprintSecondary(): string;
    /**
     * @stability stable
     */
    set thumbprintSecondary(value: string);
    /**
     * @stability stable
     */
    resetThumbprintSecondary(): void;
    /**
     * @stability stable
     */
    get thumbprintSecondaryInput(): string | undefined;
    private _x509StoreName?;
    /**
     * @stability stable
     */
    get x509StoreName(): string;
    /**
     * @stability stable
     */
    set x509StoreName(value: string);
    /**
     * @stability stable
     */
    get x509StoreNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterCertificateCommonNamesCommonNames {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#certificate_common_name ServiceFabricCluster#certificate_common_name}.
     *
     * @stability stable
     */
    readonly certificateCommonName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#certificate_issuer_thumbprint ServiceFabricCluster#certificate_issuer_thumbprint}.
     *
     * @stability stable
     */
    readonly certificateIssuerThumbprint?: string;
}
export declare function serviceFabricClusterCertificateCommonNamesCommonNamesToTerraform(struct?: ServiceFabricClusterCertificateCommonNamesCommonNames | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricClusterCertificateCommonNames {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}.
     *
     * @stability stable
     */
    readonly x509StoreName: string;
    /**
     * common_names block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#common_names ServiceFabricCluster#common_names}
     *
     * @stability stable
     */
    readonly commonNames: ServiceFabricClusterCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
}
export declare function serviceFabricClusterCertificateCommonNamesToTerraform(struct?: ServiceFabricClusterCertificateCommonNamesOutputReference | ServiceFabricClusterCertificateCommonNames): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterCertificateCommonNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterCertificateCommonNames | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterCertificateCommonNames | undefined);
    private _x509StoreName?;
    /**
     * @stability stable
     */
    get x509StoreName(): string;
    /**
     * @stability stable
     */
    set x509StoreName(value: string);
    /**
     * @stability stable
     */
    get x509StoreNameInput(): string | undefined;
    private _commonNames?;
    /**
     * @stability stable
     */
    get commonNames(): ServiceFabricClusterCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set commonNames(value: ServiceFabricClusterCertificateCommonNamesCommonNames[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get commonNamesInput(): cdktf.IResolvable | ServiceFabricClusterCertificateCommonNamesCommonNames[] | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterClientCertificateCommonName {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#common_name ServiceFabricCluster#common_name}.
     *
     * @stability stable
     */
    readonly commonName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#is_admin ServiceFabricCluster#is_admin}.
     *
     * @stability stable
     */
    readonly isAdmin: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#issuer_thumbprint ServiceFabricCluster#issuer_thumbprint}.
     *
     * @stability stable
     */
    readonly issuerThumbprint?: string;
}
export declare function serviceFabricClusterClientCertificateCommonNameToTerraform(struct?: ServiceFabricClusterClientCertificateCommonName | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricClusterClientCertificateThumbprint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#is_admin ServiceFabricCluster#is_admin}.
     *
     * @stability stable
     */
    readonly isAdmin: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#thumbprint ServiceFabricCluster#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function serviceFabricClusterClientCertificateThumbprintToTerraform(struct?: ServiceFabricClusterClientCertificateThumbprint | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricClusterDiagnosticsConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#blob_endpoint ServiceFabricCluster#blob_endpoint}.
     *
     * @stability stable
     */
    readonly blobEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#protected_account_key_name ServiceFabricCluster#protected_account_key_name}.
     *
     * @stability stable
     */
    readonly protectedAccountKeyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#queue_endpoint ServiceFabricCluster#queue_endpoint}.
     *
     * @stability stable
     */
    readonly queueEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#storage_account_name ServiceFabricCluster#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#table_endpoint ServiceFabricCluster#table_endpoint}.
     *
     * @stability stable
     */
    readonly tableEndpoint: string;
}
export declare function serviceFabricClusterDiagnosticsConfigToTerraform(struct?: ServiceFabricClusterDiagnosticsConfigOutputReference | ServiceFabricClusterDiagnosticsConfig): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterDiagnosticsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterDiagnosticsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterDiagnosticsConfig | undefined);
    private _blobEndpoint?;
    /**
     * @stability stable
     */
    get blobEndpoint(): string;
    /**
     * @stability stable
     */
    set blobEndpoint(value: string);
    /**
     * @stability stable
     */
    get blobEndpointInput(): string | undefined;
    private _protectedAccountKeyName?;
    /**
     * @stability stable
     */
    get protectedAccountKeyName(): string;
    /**
     * @stability stable
     */
    set protectedAccountKeyName(value: string);
    /**
     * @stability stable
     */
    get protectedAccountKeyNameInput(): string | undefined;
    private _queueEndpoint?;
    /**
     * @stability stable
     */
    get queueEndpoint(): string;
    /**
     * @stability stable
     */
    set queueEndpoint(value: string);
    /**
     * @stability stable
     */
    get queueEndpointInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _tableEndpoint?;
    /**
     * @stability stable
     */
    get tableEndpoint(): string;
    /**
     * @stability stable
     */
    set tableEndpoint(value: string);
    /**
     * @stability stable
     */
    get tableEndpointInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterFabricSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#name ServiceFabricCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#parameters ServiceFabricCluster#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function serviceFabricClusterFabricSettingsToTerraform(struct?: ServiceFabricClusterFabricSettings | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricClusterNodeTypeApplicationPorts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#end_port ServiceFabricCluster#end_port}.
     *
     * @stability stable
     */
    readonly endPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#start_port ServiceFabricCluster#start_port}.
     *
     * @stability stable
     */
    readonly startPort: number;
}
export declare function serviceFabricClusterNodeTypeApplicationPortsToTerraform(struct?: ServiceFabricClusterNodeTypeApplicationPortsOutputReference | ServiceFabricClusterNodeTypeApplicationPorts): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterNodeTypeApplicationPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterNodeTypeApplicationPorts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterNodeTypeApplicationPorts | undefined);
    private _endPort?;
    /**
     * @stability stable
     */
    get endPort(): number;
    /**
     * @stability stable
     */
    set endPort(value: number);
    /**
     * @stability stable
     */
    get endPortInput(): number | undefined;
    private _startPort?;
    /**
     * @stability stable
     */
    get startPort(): number;
    /**
     * @stability stable
     */
    set startPort(value: number);
    /**
     * @stability stable
     */
    get startPortInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterNodeTypeEphemeralPorts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#end_port ServiceFabricCluster#end_port}.
     *
     * @stability stable
     */
    readonly endPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#start_port ServiceFabricCluster#start_port}.
     *
     * @stability stable
     */
    readonly startPort: number;
}
export declare function serviceFabricClusterNodeTypeEphemeralPortsToTerraform(struct?: ServiceFabricClusterNodeTypeEphemeralPortsOutputReference | ServiceFabricClusterNodeTypeEphemeralPorts): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterNodeTypeEphemeralPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterNodeTypeEphemeralPorts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterNodeTypeEphemeralPorts | undefined);
    private _endPort?;
    /**
     * @stability stable
     */
    get endPort(): number;
    /**
     * @stability stable
     */
    set endPort(value: number);
    /**
     * @stability stable
     */
    get endPortInput(): number | undefined;
    private _startPort?;
    /**
     * @stability stable
     */
    get startPort(): number;
    /**
     * @stability stable
     */
    set startPort(value: number);
    /**
     * @stability stable
     */
    get startPortInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterNodeType {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#capacities ServiceFabricCluster#capacities}.
     *
     * @stability stable
     */
    readonly capacities?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#client_endpoint_port ServiceFabricCluster#client_endpoint_port}.
     *
     * @stability stable
     */
    readonly clientEndpointPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#durability_level ServiceFabricCluster#durability_level}.
     *
     * @stability stable
     */
    readonly durabilityLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#http_endpoint_port ServiceFabricCluster#http_endpoint_port}.
     *
     * @stability stable
     */
    readonly httpEndpointPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#instance_count ServiceFabricCluster#instance_count}.
     *
     * @stability stable
     */
    readonly instanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#is_primary ServiceFabricCluster#is_primary}.
     *
     * @stability stable
     */
    readonly isPrimary: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#is_stateless ServiceFabricCluster#is_stateless}.
     *
     * @stability stable
     */
    readonly isStateless?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#multiple_availability_zones ServiceFabricCluster#multiple_availability_zones}.
     *
     * @stability stable
     */
    readonly multipleAvailabilityZones?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#name ServiceFabricCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#placement_properties ServiceFabricCluster#placement_properties}.
     *
     * @stability stable
     */
    readonly placementProperties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#reverse_proxy_endpoint_port ServiceFabricCluster#reverse_proxy_endpoint_port}.
     *
     * @stability stable
     */
    readonly reverseProxyEndpointPort?: number;
    /**
     * application_ports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#application_ports ServiceFabricCluster#application_ports}
     *
     * @stability stable
     */
    readonly applicationPorts?: ServiceFabricClusterNodeTypeApplicationPorts;
    /**
     * ephemeral_ports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#ephemeral_ports ServiceFabricCluster#ephemeral_ports}
     *
     * @stability stable
     */
    readonly ephemeralPorts?: ServiceFabricClusterNodeTypeEphemeralPorts;
}
export declare function serviceFabricClusterNodeTypeToTerraform(struct?: ServiceFabricClusterNodeType | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricClusterReverseProxyCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#thumbprint ServiceFabricCluster#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#thumbprint_secondary ServiceFabricCluster#thumbprint_secondary}.
     *
     * @stability stable
     */
    readonly thumbprintSecondary?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}.
     *
     * @stability stable
     */
    readonly x509StoreName: string;
}
export declare function serviceFabricClusterReverseProxyCertificateToTerraform(struct?: ServiceFabricClusterReverseProxyCertificateOutputReference | ServiceFabricClusterReverseProxyCertificate): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterReverseProxyCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterReverseProxyCertificate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterReverseProxyCertificate | undefined);
    private _thumbprint?;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    /**
     * @stability stable
     */
    set thumbprint(value: string);
    /**
     * @stability stable
     */
    get thumbprintInput(): string | undefined;
    private _thumbprintSecondary?;
    /**
     * @stability stable
     */
    get thumbprintSecondary(): string;
    /**
     * @stability stable
     */
    set thumbprintSecondary(value: string);
    /**
     * @stability stable
     */
    resetThumbprintSecondary(): void;
    /**
     * @stability stable
     */
    get thumbprintSecondaryInput(): string | undefined;
    private _x509StoreName?;
    /**
     * @stability stable
     */
    get x509StoreName(): string;
    /**
     * @stability stable
     */
    set x509StoreName(value: string);
    /**
     * @stability stable
     */
    get x509StoreNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#certificate_common_name ServiceFabricCluster#certificate_common_name}.
     *
     * @stability stable
     */
    readonly certificateCommonName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#certificate_issuer_thumbprint ServiceFabricCluster#certificate_issuer_thumbprint}.
     *
     * @stability stable
     */
    readonly certificateIssuerThumbprint?: string;
}
export declare function serviceFabricClusterReverseProxyCertificateCommonNamesCommonNamesToTerraform(struct?: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricClusterReverseProxyCertificateCommonNames {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}.
     *
     * @stability stable
     */
    readonly x509StoreName: string;
    /**
     * common_names block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#common_names ServiceFabricCluster#common_names}
     *
     * @stability stable
     */
    readonly commonNames: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
}
export declare function serviceFabricClusterReverseProxyCertificateCommonNamesToTerraform(struct?: ServiceFabricClusterReverseProxyCertificateCommonNamesOutputReference | ServiceFabricClusterReverseProxyCertificateCommonNames): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterReverseProxyCertificateCommonNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterReverseProxyCertificateCommonNames | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterReverseProxyCertificateCommonNames | undefined);
    private _x509StoreName?;
    /**
     * @stability stable
     */
    get x509StoreName(): string;
    /**
     * @stability stable
     */
    set x509StoreName(value: string);
    /**
     * @stability stable
     */
    get x509StoreNameInput(): string | undefined;
    private _commonNames?;
    /**
     * @stability stable
     */
    get commonNames(): ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set commonNames(value: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get commonNamesInput(): cdktf.IResolvable | ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#create ServiceFabricCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#delete ServiceFabricCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#read ServiceFabricCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#update ServiceFabricCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function serviceFabricClusterTimeoutsToTerraform(struct?: ServiceFabricClusterTimeoutsOutputReference | ServiceFabricClusterTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterUpgradePolicyDeltaHealthPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#max_delta_unhealthy_applications_percent ServiceFabricCluster#max_delta_unhealthy_applications_percent}.
     *
     * @stability stable
     */
    readonly maxDeltaUnhealthyApplicationsPercent?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#max_delta_unhealthy_nodes_percent ServiceFabricCluster#max_delta_unhealthy_nodes_percent}.
     *
     * @stability stable
     */
    readonly maxDeltaUnhealthyNodesPercent?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#max_upgrade_domain_delta_unhealthy_nodes_percent ServiceFabricCluster#max_upgrade_domain_delta_unhealthy_nodes_percent}.
     *
     * @stability stable
     */
    readonly maxUpgradeDomainDeltaUnhealthyNodesPercent?: number;
}
export declare function serviceFabricClusterUpgradePolicyDeltaHealthPolicyToTerraform(struct?: ServiceFabricClusterUpgradePolicyDeltaHealthPolicyOutputReference | ServiceFabricClusterUpgradePolicyDeltaHealthPolicy): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterUpgradePolicyDeltaHealthPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterUpgradePolicyDeltaHealthPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterUpgradePolicyDeltaHealthPolicy | undefined);
    private _maxDeltaUnhealthyApplicationsPercent?;
    /**
     * @stability stable
     */
    get maxDeltaUnhealthyApplicationsPercent(): number;
    /**
     * @stability stable
     */
    set maxDeltaUnhealthyApplicationsPercent(value: number);
    /**
     * @stability stable
     */
    resetMaxDeltaUnhealthyApplicationsPercent(): void;
    /**
     * @stability stable
     */
    get maxDeltaUnhealthyApplicationsPercentInput(): number | undefined;
    private _maxDeltaUnhealthyNodesPercent?;
    /**
     * @stability stable
     */
    get maxDeltaUnhealthyNodesPercent(): number;
    /**
     * @stability stable
     */
    set maxDeltaUnhealthyNodesPercent(value: number);
    /**
     * @stability stable
     */
    resetMaxDeltaUnhealthyNodesPercent(): void;
    /**
     * @stability stable
     */
    get maxDeltaUnhealthyNodesPercentInput(): number | undefined;
    private _maxUpgradeDomainDeltaUnhealthyNodesPercent?;
    /**
     * @stability stable
     */
    get maxUpgradeDomainDeltaUnhealthyNodesPercent(): number;
    /**
     * @stability stable
     */
    set maxUpgradeDomainDeltaUnhealthyNodesPercent(value: number);
    /**
     * @stability stable
     */
    resetMaxUpgradeDomainDeltaUnhealthyNodesPercent(): void;
    /**
     * @stability stable
     */
    get maxUpgradeDomainDeltaUnhealthyNodesPercentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterUpgradePolicyHealthPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#max_unhealthy_applications_percent ServiceFabricCluster#max_unhealthy_applications_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyApplicationsPercent?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#max_unhealthy_nodes_percent ServiceFabricCluster#max_unhealthy_nodes_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyNodesPercent?: number;
}
export declare function serviceFabricClusterUpgradePolicyHealthPolicyToTerraform(struct?: ServiceFabricClusterUpgradePolicyHealthPolicyOutputReference | ServiceFabricClusterUpgradePolicyHealthPolicy): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterUpgradePolicyHealthPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterUpgradePolicyHealthPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterUpgradePolicyHealthPolicy | undefined);
    private _maxUnhealthyApplicationsPercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyApplicationsPercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyApplicationsPercent(value: number);
    /**
     * @stability stable
     */
    resetMaxUnhealthyApplicationsPercent(): void;
    /**
     * @stability stable
     */
    get maxUnhealthyApplicationsPercentInput(): number | undefined;
    private _maxUnhealthyNodesPercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyNodesPercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyNodesPercent(value: number);
    /**
     * @stability stable
     */
    resetMaxUnhealthyNodesPercent(): void;
    /**
     * @stability stable
     */
    get maxUnhealthyNodesPercentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricClusterUpgradePolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#force_restart_enabled ServiceFabricCluster#force_restart_enabled}.
     *
     * @stability stable
     */
    readonly forceRestartEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#health_check_retry_timeout ServiceFabricCluster#health_check_retry_timeout}.
     *
     * @stability stable
     */
    readonly healthCheckRetryTimeout?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#health_check_stable_duration ServiceFabricCluster#health_check_stable_duration}.
     *
     * @stability stable
     */
    readonly healthCheckStableDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#health_check_wait_duration ServiceFabricCluster#health_check_wait_duration}.
     *
     * @stability stable
     */
    readonly healthCheckWaitDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#upgrade_domain_timeout ServiceFabricCluster#upgrade_domain_timeout}.
     *
     * @stability stable
     */
    readonly upgradeDomainTimeout?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#upgrade_replica_set_check_timeout ServiceFabricCluster#upgrade_replica_set_check_timeout}.
     *
     * @stability stable
     */
    readonly upgradeReplicaSetCheckTimeout?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#upgrade_timeout ServiceFabricCluster#upgrade_timeout}.
     *
     * @stability stable
     */
    readonly upgradeTimeout?: string;
    /**
     * delta_health_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#delta_health_policy ServiceFabricCluster#delta_health_policy}
     *
     * @stability stable
     */
    readonly deltaHealthPolicy?: ServiceFabricClusterUpgradePolicyDeltaHealthPolicy;
    /**
     * health_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster#health_policy ServiceFabricCluster#health_policy}
     *
     * @stability stable
     */
    readonly healthPolicy?: ServiceFabricClusterUpgradePolicyHealthPolicy;
}
export declare function serviceFabricClusterUpgradePolicyToTerraform(struct?: ServiceFabricClusterUpgradePolicyOutputReference | ServiceFabricClusterUpgradePolicy): any;
/**
 * @stability stable
 */
export declare class ServiceFabricClusterUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricClusterUpgradePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricClusterUpgradePolicy | undefined);
    private _forceRestartEnabled?;
    /**
     * @stability stable
     */
    get forceRestartEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceRestartEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceRestartEnabled(): void;
    /**
     * @stability stable
     */
    get forceRestartEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _healthCheckRetryTimeout?;
    /**
     * @stability stable
     */
    get healthCheckRetryTimeout(): string;
    /**
     * @stability stable
     */
    set healthCheckRetryTimeout(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckRetryTimeout(): void;
    /**
     * @stability stable
     */
    get healthCheckRetryTimeoutInput(): string | undefined;
    private _healthCheckStableDuration?;
    /**
     * @stability stable
     */
    get healthCheckStableDuration(): string;
    /**
     * @stability stable
     */
    set healthCheckStableDuration(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckStableDuration(): void;
    /**
     * @stability stable
     */
    get healthCheckStableDurationInput(): string | undefined;
    private _healthCheckWaitDuration?;
    /**
     * @stability stable
     */
    get healthCheckWaitDuration(): string;
    /**
     * @stability stable
     */
    set healthCheckWaitDuration(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckWaitDuration(): void;
    /**
     * @stability stable
     */
    get healthCheckWaitDurationInput(): string | undefined;
    private _upgradeDomainTimeout?;
    /**
     * @stability stable
     */
    get upgradeDomainTimeout(): string;
    /**
     * @stability stable
     */
    set upgradeDomainTimeout(value: string);
    /**
     * @stability stable
     */
    resetUpgradeDomainTimeout(): void;
    /**
     * @stability stable
     */
    get upgradeDomainTimeoutInput(): string | undefined;
    private _upgradeReplicaSetCheckTimeout?;
    /**
     * @stability stable
     */
    get upgradeReplicaSetCheckTimeout(): string;
    /**
     * @stability stable
     */
    set upgradeReplicaSetCheckTimeout(value: string);
    /**
     * @stability stable
     */
    resetUpgradeReplicaSetCheckTimeout(): void;
    /**
     * @stability stable
     */
    get upgradeReplicaSetCheckTimeoutInput(): string | undefined;
    private _upgradeTimeout?;
    /**
     * @stability stable
     */
    get upgradeTimeout(): string;
    /**
     * @stability stable
     */
    set upgradeTimeout(value: string);
    /**
     * @stability stable
     */
    resetUpgradeTimeout(): void;
    /**
     * @stability stable
     */
    get upgradeTimeoutInput(): string | undefined;
    private _deltaHealthPolicy;
    /**
     * @stability stable
     */
    get deltaHealthPolicy(): ServiceFabricClusterUpgradePolicyDeltaHealthPolicyOutputReference;
    /**
     * @stability stable
     */
    putDeltaHealthPolicy(value: ServiceFabricClusterUpgradePolicyDeltaHealthPolicy): void;
    /**
     * @stability stable
     */
    resetDeltaHealthPolicy(): void;
    /**
     * @stability stable
     */
    get deltaHealthPolicyInput(): ServiceFabricClusterUpgradePolicyDeltaHealthPolicy | undefined;
    private _healthPolicy;
    /**
     * @stability stable
     */
    get healthPolicy(): ServiceFabricClusterUpgradePolicyHealthPolicyOutputReference;
    /**
     * @stability stable
     */
    putHealthPolicy(value: ServiceFabricClusterUpgradePolicyHealthPolicy): void;
    /**
     * @stability stable
     */
    resetHealthPolicy(): void;
    /**
     * @stability stable
     */
    get healthPolicyInput(): ServiceFabricClusterUpgradePolicyHealthPolicy | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster azurerm_service_fabric_cluster}.
 *
 * @stability stable
 */
export declare class ServiceFabricCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_cluster azurerm_service_fabric_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceFabricClusterConfig);
    private _addOnFeatures?;
    /**
     * @stability stable
     */
    get addOnFeatures(): string[];
    /**
     * @stability stable
     */
    set addOnFeatures(value: string[]);
    /**
     * @stability stable
     */
    resetAddOnFeatures(): void;
    /**
     * @stability stable
     */
    get addOnFeaturesInput(): string[] | undefined;
    private _clusterCodeVersion?;
    /**
     * @stability stable
     */
    get clusterCodeVersion(): string;
    /**
     * @stability stable
     */
    set clusterCodeVersion(value: string);
    /**
     * @stability stable
     */
    resetClusterCodeVersion(): void;
    /**
     * @stability stable
     */
    get clusterCodeVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get clusterEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _managementEndpoint?;
    /**
     * @stability stable
     */
    get managementEndpoint(): string;
    /**
     * @stability stable
     */
    set managementEndpoint(value: string);
    /**
     * @stability stable
     */
    get managementEndpointInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _reliabilityLevel?;
    /**
     * @stability stable
     */
    get reliabilityLevel(): string;
    /**
     * @stability stable
     */
    set reliabilityLevel(value: string);
    /**
     * @stability stable
     */
    get reliabilityLevelInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serviceFabricZonalUpgradeMode?;
    /**
     * @stability stable
     */
    get serviceFabricZonalUpgradeMode(): string;
    /**
     * @stability stable
     */
    set serviceFabricZonalUpgradeMode(value: string);
    /**
     * @stability stable
     */
    resetServiceFabricZonalUpgradeMode(): void;
    /**
     * @stability stable
     */
    get serviceFabricZonalUpgradeModeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _upgradeMode?;
    /**
     * @stability stable
     */
    get upgradeMode(): string;
    /**
     * @stability stable
     */
    set upgradeMode(value: string);
    /**
     * @stability stable
     */
    get upgradeModeInput(): string | undefined;
    private _vmImage?;
    /**
     * @stability stable
     */
    get vmImage(): string;
    /**
     * @stability stable
     */
    set vmImage(value: string);
    /**
     * @stability stable
     */
    get vmImageInput(): string | undefined;
    private _vmssZonalUpgradeMode?;
    /**
     * @stability stable
     */
    get vmssZonalUpgradeMode(): string;
    /**
     * @stability stable
     */
    set vmssZonalUpgradeMode(value: string);
    /**
     * @stability stable
     */
    resetVmssZonalUpgradeMode(): void;
    /**
     * @stability stable
     */
    get vmssZonalUpgradeModeInput(): string | undefined;
    private _azureActiveDirectory;
    /**
     * @stability stable
     */
    get azureActiveDirectory(): ServiceFabricClusterAzureActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putAzureActiveDirectory(value: ServiceFabricClusterAzureActiveDirectory): void;
    /**
     * @stability stable
     */
    resetAzureActiveDirectory(): void;
    /**
     * @stability stable
     */
    get azureActiveDirectoryInput(): ServiceFabricClusterAzureActiveDirectory | undefined;
    private _certificate;
    /**
     * @stability stable
     */
    get certificate(): ServiceFabricClusterCertificateOutputReference;
    /**
     * @stability stable
     */
    putCertificate(value: ServiceFabricClusterCertificate): void;
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): ServiceFabricClusterCertificate | undefined;
    private _certificateCommonNames;
    /**
     * @stability stable
     */
    get certificateCommonNames(): ServiceFabricClusterCertificateCommonNamesOutputReference;
    /**
     * @stability stable
     */
    putCertificateCommonNames(value: ServiceFabricClusterCertificateCommonNames): void;
    /**
     * @stability stable
     */
    resetCertificateCommonNames(): void;
    /**
     * @stability stable
     */
    get certificateCommonNamesInput(): ServiceFabricClusterCertificateCommonNames | undefined;
    private _clientCertificateCommonName?;
    /**
     * @stability stable
     */
    get clientCertificateCommonName(): ServiceFabricClusterClientCertificateCommonName[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientCertificateCommonName(value: ServiceFabricClusterClientCertificateCommonName[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientCertificateCommonName(): void;
    /**
     * @stability stable
     */
    get clientCertificateCommonNameInput(): cdktf.IResolvable | ServiceFabricClusterClientCertificateCommonName[] | undefined;
    private _clientCertificateThumbprint?;
    /**
     * @stability stable
     */
    get clientCertificateThumbprint(): ServiceFabricClusterClientCertificateThumbprint[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientCertificateThumbprint(value: ServiceFabricClusterClientCertificateThumbprint[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientCertificateThumbprint(): void;
    /**
     * @stability stable
     */
    get clientCertificateThumbprintInput(): cdktf.IResolvable | ServiceFabricClusterClientCertificateThumbprint[] | undefined;
    private _diagnosticsConfig;
    /**
     * @stability stable
     */
    get diagnosticsConfig(): ServiceFabricClusterDiagnosticsConfigOutputReference;
    /**
     * @stability stable
     */
    putDiagnosticsConfig(value: ServiceFabricClusterDiagnosticsConfig): void;
    /**
     * @stability stable
     */
    resetDiagnosticsConfig(): void;
    /**
     * @stability stable
     */
    get diagnosticsConfigInput(): ServiceFabricClusterDiagnosticsConfig | undefined;
    private _fabricSettings?;
    /**
     * @stability stable
     */
    get fabricSettings(): ServiceFabricClusterFabricSettings[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fabricSettings(value: ServiceFabricClusterFabricSettings[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFabricSettings(): void;
    /**
     * @stability stable
     */
    get fabricSettingsInput(): cdktf.IResolvable | ServiceFabricClusterFabricSettings[] | undefined;
    private _nodeType?;
    /**
     * @stability stable
     */
    get nodeType(): ServiceFabricClusterNodeType[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set nodeType(value: ServiceFabricClusterNodeType[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get nodeTypeInput(): cdktf.IResolvable | ServiceFabricClusterNodeType[] | undefined;
    private _reverseProxyCertificate;
    /**
     * @stability stable
     */
    get reverseProxyCertificate(): ServiceFabricClusterReverseProxyCertificateOutputReference;
    /**
     * @stability stable
     */
    putReverseProxyCertificate(value: ServiceFabricClusterReverseProxyCertificate): void;
    /**
     * @stability stable
     */
    resetReverseProxyCertificate(): void;
    /**
     * @stability stable
     */
    get reverseProxyCertificateInput(): ServiceFabricClusterReverseProxyCertificate | undefined;
    private _reverseProxyCertificateCommonNames;
    /**
     * @stability stable
     */
    get reverseProxyCertificateCommonNames(): ServiceFabricClusterReverseProxyCertificateCommonNamesOutputReference;
    /**
     * @stability stable
     */
    putReverseProxyCertificateCommonNames(value: ServiceFabricClusterReverseProxyCertificateCommonNames): void;
    /**
     * @stability stable
     */
    resetReverseProxyCertificateCommonNames(): void;
    /**
     * @stability stable
     */
    get reverseProxyCertificateCommonNamesInput(): ServiceFabricClusterReverseProxyCertificateCommonNames | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServiceFabricClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServiceFabricClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceFabricClusterTimeouts | undefined;
    private _upgradePolicy;
    /**
     * @stability stable
     */
    get upgradePolicy(): ServiceFabricClusterUpgradePolicyOutputReference;
    /**
     * @stability stable
     */
    putUpgradePolicy(value: ServiceFabricClusterUpgradePolicy): void;
    /**
     * @stability stable
     */
    resetUpgradePolicy(): void;
    /**
     * @stability stable
     */
    get upgradePolicyInput(): ServiceFabricClusterUpgradePolicy | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
