import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicebusTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#auto_delete_on_idle ServicebusTopic#auto_delete_on_idle}.
     *
     * @stability stable
     */
    readonly autoDeleteOnIdle?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#default_message_ttl ServicebusTopic#default_message_ttl}.
     *
     * @stability stable
     */
    readonly defaultMessageTtl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#duplicate_detection_history_time_window ServicebusTopic#duplicate_detection_history_time_window}.
     *
     * @stability stable
     */
    readonly duplicateDetectionHistoryTimeWindow?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#enable_batched_operations ServicebusTopic#enable_batched_operations}.
     *
     * @stability stable
     */
    readonly enableBatchedOperations?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#enable_express ServicebusTopic#enable_express}.
     *
     * @stability stable
     */
    readonly enableExpress?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#enable_partitioning ServicebusTopic#enable_partitioning}.
     *
     * @stability stable
     */
    readonly enablePartitioning?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#max_message_size_in_kilobytes ServicebusTopic#max_message_size_in_kilobytes}.
     *
     * @stability stable
     */
    readonly maxMessageSizeInKilobytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#max_size_in_megabytes ServicebusTopic#max_size_in_megabytes}.
     *
     * @stability stable
     */
    readonly maxSizeInMegabytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#name ServicebusTopic#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#namespace_id ServicebusTopic#namespace_id}.
     *
     * @stability stable
     */
    readonly namespaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#namespace_name ServicebusTopic#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#requires_duplicate_detection ServicebusTopic#requires_duplicate_detection}.
     *
     * @stability stable
     */
    readonly requiresDuplicateDetection?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#resource_group_name ServicebusTopic#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#status ServicebusTopic#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#support_ordering ServicebusTopic#support_ordering}.
     *
     * @stability stable
     */
    readonly supportOrdering?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#timeouts ServicebusTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicebusTopicTimeouts;
}
/**
 * @stability stable
 */
export interface ServicebusTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#create ServicebusTopic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#delete ServicebusTopic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#read ServicebusTopic#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic#update ServicebusTopic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicebusTopicTimeoutsToTerraform(struct?: ServicebusTopicTimeoutsOutputReference | ServicebusTopicTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ServicebusTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusTopicTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic azurerm_servicebus_topic}.
 *
 * @stability stable
 */
export declare class ServicebusTopic extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic azurerm_servicebus_topic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicebusTopicConfig);
    private _autoDeleteOnIdle?;
    /**
     * @stability stable
     */
    get autoDeleteOnIdle(): string;
    /**
     * @stability stable
     */
    set autoDeleteOnIdle(value: string);
    /**
     * @stability stable
     */
    resetAutoDeleteOnIdle(): void;
    /**
     * @stability stable
     */
    get autoDeleteOnIdleInput(): string | undefined;
    private _defaultMessageTtl?;
    /**
     * @stability stable
     */
    get defaultMessageTtl(): string;
    /**
     * @stability stable
     */
    set defaultMessageTtl(value: string);
    /**
     * @stability stable
     */
    resetDefaultMessageTtl(): void;
    /**
     * @stability stable
     */
    get defaultMessageTtlInput(): string | undefined;
    private _duplicateDetectionHistoryTimeWindow?;
    /**
     * @stability stable
     */
    get duplicateDetectionHistoryTimeWindow(): string;
    /**
     * @stability stable
     */
    set duplicateDetectionHistoryTimeWindow(value: string);
    /**
     * @stability stable
     */
    resetDuplicateDetectionHistoryTimeWindow(): void;
    /**
     * @stability stable
     */
    get duplicateDetectionHistoryTimeWindowInput(): string | undefined;
    private _enableBatchedOperations?;
    /**
     * @stability stable
     */
    get enableBatchedOperations(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBatchedOperations(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBatchedOperations(): void;
    /**
     * @stability stable
     */
    get enableBatchedOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableExpress?;
    /**
     * @stability stable
     */
    get enableExpress(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableExpress(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableExpress(): void;
    /**
     * @stability stable
     */
    get enableExpressInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePartitioning?;
    /**
     * @stability stable
     */
    get enablePartitioning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePartitioning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnablePartitioning(): void;
    /**
     * @stability stable
     */
    get enablePartitioningInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maxMessageSizeInKilobytes?;
    /**
     * @stability stable
     */
    get maxMessageSizeInKilobytes(): number;
    /**
     * @stability stable
     */
    set maxMessageSizeInKilobytes(value: number);
    /**
     * @stability stable
     */
    resetMaxMessageSizeInKilobytes(): void;
    /**
     * @stability stable
     */
    get maxMessageSizeInKilobytesInput(): number | undefined;
    private _maxSizeInMegabytes?;
    /**
     * @stability stable
     */
    get maxSizeInMegabytes(): number;
    /**
     * @stability stable
     */
    set maxSizeInMegabytes(value: number);
    /**
     * @stability stable
     */
    resetMaxSizeInMegabytes(): void;
    /**
     * @stability stable
     */
    get maxSizeInMegabytesInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceId?;
    /**
     * @stability stable
     */
    get namespaceId(): string;
    /**
     * @stability stable
     */
    set namespaceId(value: string);
    /**
     * @stability stable
     */
    resetNamespaceId(): void;
    /**
     * @stability stable
     */
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    resetNamespaceName(): void;
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _requiresDuplicateDetection?;
    /**
     * @stability stable
     */
    get requiresDuplicateDetection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requiresDuplicateDetection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequiresDuplicateDetection(): void;
    /**
     * @stability stable
     */
    get requiresDuplicateDetectionInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetResourceGroupName(): void;
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _supportOrdering?;
    /**
     * @stability stable
     */
    get supportOrdering(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportOrdering(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportOrdering(): void;
    /**
     * @stability stable
     */
    get supportOrderingInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicebusTopicTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicebusTopicTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicebusTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
