import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputBlobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#batch_max_wait_time StreamAnalyticsOutputBlob#batch_max_wait_time}.
     *
     * @stability stable
     */
    readonly batchMaxWaitTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#batch_min_rows StreamAnalyticsOutputBlob#batch_min_rows}.
     *
     * @stability stable
     */
    readonly batchMinRows?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#date_format StreamAnalyticsOutputBlob#date_format}.
     *
     * @stability stable
     */
    readonly dateFormat: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#name StreamAnalyticsOutputBlob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#path_pattern StreamAnalyticsOutputBlob#path_pattern}.
     *
     * @stability stable
     */
    readonly pathPattern: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#resource_group_name StreamAnalyticsOutputBlob#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#storage_account_key StreamAnalyticsOutputBlob#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#storage_account_name StreamAnalyticsOutputBlob#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#storage_container_name StreamAnalyticsOutputBlob#storage_container_name}.
     *
     * @stability stable
     */
    readonly storageContainerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#stream_analytics_job_name StreamAnalyticsOutputBlob#stream_analytics_job_name}.
     *
     * @stability stable
     */
    readonly streamAnalyticsJobName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#time_format StreamAnalyticsOutputBlob#time_format}.
     *
     * @stability stable
     */
    readonly timeFormat: string;
    /**
     * serialization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#serialization StreamAnalyticsOutputBlob#serialization}
     *
     * @stability stable
     */
    readonly serialization: StreamAnalyticsOutputBlobSerialization;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#timeouts StreamAnalyticsOutputBlob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsOutputBlobTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputBlobSerialization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#encoding StreamAnalyticsOutputBlob#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#field_delimiter StreamAnalyticsOutputBlob#field_delimiter}.
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#format StreamAnalyticsOutputBlob#format}.
     *
     * @stability stable
     */
    readonly format?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#type StreamAnalyticsOutputBlob#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsOutputBlobSerializationToTerraform(struct?: StreamAnalyticsOutputBlobSerializationOutputReference | StreamAnalyticsOutputBlobSerialization): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsOutputBlobSerializationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsOutputBlobSerialization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsOutputBlobSerialization | undefined);
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _format?;
    /**
     * @stability stable
     */
    get format(): string;
    /**
     * @stability stable
     */
    set format(value: string);
    /**
     * @stability stable
     */
    resetFormat(): void;
    /**
     * @stability stable
     */
    get formatInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputBlobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#create StreamAnalyticsOutputBlob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#delete StreamAnalyticsOutputBlob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#read StreamAnalyticsOutputBlob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob#update StreamAnalyticsOutputBlob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsOutputBlobTimeoutsToTerraform(struct?: StreamAnalyticsOutputBlobTimeoutsOutputReference | StreamAnalyticsOutputBlobTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsOutputBlobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsOutputBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsOutputBlobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob azurerm_stream_analytics_output_blob}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsOutputBlob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_blob azurerm_stream_analytics_output_blob} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputBlobConfig);
    private _batchMaxWaitTime?;
    /**
     * @stability stable
     */
    get batchMaxWaitTime(): string;
    /**
     * @stability stable
     */
    set batchMaxWaitTime(value: string);
    /**
     * @stability stable
     */
    resetBatchMaxWaitTime(): void;
    /**
     * @stability stable
     */
    get batchMaxWaitTimeInput(): string | undefined;
    private _batchMinRows?;
    /**
     * @stability stable
     */
    get batchMinRows(): number;
    /**
     * @stability stable
     */
    set batchMinRows(value: number);
    /**
     * @stability stable
     */
    resetBatchMinRows(): void;
    /**
     * @stability stable
     */
    get batchMinRowsInput(): number | undefined;
    private _dateFormat?;
    /**
     * @stability stable
     */
    get dateFormat(): string;
    /**
     * @stability stable
     */
    set dateFormat(value: string);
    /**
     * @stability stable
     */
    get dateFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _pathPattern?;
    /**
     * @stability stable
     */
    get pathPattern(): string;
    /**
     * @stability stable
     */
    set pathPattern(value: string);
    /**
     * @stability stable
     */
    get pathPatternInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountKey?;
    /**
     * @stability stable
     */
    get storageAccountKey(): string;
    /**
     * @stability stable
     */
    set storageAccountKey(value: string);
    /**
     * @stability stable
     */
    get storageAccountKeyInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _storageContainerName?;
    /**
     * @stability stable
     */
    get storageContainerName(): string;
    /**
     * @stability stable
     */
    set storageContainerName(value: string);
    /**
     * @stability stable
     */
    get storageContainerNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    /**
     * @stability stable
     */
    get streamAnalyticsJobName(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsJobName(value: string);
    /**
     * @stability stable
     */
    get streamAnalyticsJobNameInput(): string | undefined;
    private _timeFormat?;
    /**
     * @stability stable
     */
    get timeFormat(): string;
    /**
     * @stability stable
     */
    set timeFormat(value: string);
    /**
     * @stability stable
     */
    get timeFormatInput(): string | undefined;
    private _serialization;
    /**
     * @stability stable
     */
    get serialization(): StreamAnalyticsOutputBlobSerializationOutputReference;
    /**
     * @stability stable
     */
    putSerialization(value: StreamAnalyticsOutputBlobSerialization): void;
    /**
     * @stability stable
     */
    get serializationInput(): StreamAnalyticsOutputBlobSerialization | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsOutputBlobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsOutputBlobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsOutputBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
