import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TrafficManagerExternalEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#enabled TrafficManagerExternalEndpoint#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#endpoint_location TrafficManagerExternalEndpoint#endpoint_location}.
     *
     * @stability stable
     */
    readonly endpointLocation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#geo_mappings TrafficManagerExternalEndpoint#geo_mappings}.
     *
     * @stability stable
     */
    readonly geoMappings?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#name TrafficManagerExternalEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#priority TrafficManagerExternalEndpoint#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#profile_id TrafficManagerExternalEndpoint#profile_id}.
     *
     * @stability stable
     */
    readonly profileId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#target TrafficManagerExternalEndpoint#target}.
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#weight TrafficManagerExternalEndpoint#weight}.
     *
     * @stability stable
     */
    readonly weight: number;
    /**
     * custom_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#custom_header TrafficManagerExternalEndpoint#custom_header}
     *
     * @stability stable
     */
    readonly customHeader?: TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * subnet block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#subnet TrafficManagerExternalEndpoint#subnet}
     *
     * @stability stable
     */
    readonly subnet?: TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#timeouts TrafficManagerExternalEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TrafficManagerExternalEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface TrafficManagerExternalEndpointCustomHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#name TrafficManagerExternalEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#value TrafficManagerExternalEndpoint#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function trafficManagerExternalEndpointCustomHeaderToTerraform(struct?: TrafficManagerExternalEndpointCustomHeader | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerExternalEndpointSubnet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#first TrafficManagerExternalEndpoint#first}.
     *
     * @stability stable
     */
    readonly first: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#last TrafficManagerExternalEndpoint#last}.
     *
     * @stability stable
     */
    readonly last?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#scope TrafficManagerExternalEndpoint#scope}.
     *
     * @stability stable
     */
    readonly scope?: number;
}
export declare function trafficManagerExternalEndpointSubnetToTerraform(struct?: TrafficManagerExternalEndpointSubnet | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerExternalEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#create TrafficManagerExternalEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#delete TrafficManagerExternalEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#read TrafficManagerExternalEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#update TrafficManagerExternalEndpoint#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function trafficManagerExternalEndpointTimeoutsToTerraform(struct?: TrafficManagerExternalEndpointTimeoutsOutputReference | TrafficManagerExternalEndpointTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class TrafficManagerExternalEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TrafficManagerExternalEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TrafficManagerExternalEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint azurerm_traffic_manager_external_endpoint}.
 *
 * @stability stable
 */
export declare class TrafficManagerExternalEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint azurerm_traffic_manager_external_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TrafficManagerExternalEndpointConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointLocation?;
    /**
     * @stability stable
     */
    get endpointLocation(): string;
    /**
     * @stability stable
     */
    set endpointLocation(value: string);
    /**
     * @stability stable
     */
    resetEndpointLocation(): void;
    /**
     * @stability stable
     */
    get endpointLocationInput(): string | undefined;
    private _geoMappings?;
    /**
     * @stability stable
     */
    get geoMappings(): string[];
    /**
     * @stability stable
     */
    set geoMappings(value: string[]);
    /**
     * @stability stable
     */
    resetGeoMappings(): void;
    /**
     * @stability stable
     */
    get geoMappingsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _profileId?;
    /**
     * @stability stable
     */
    get profileId(): string;
    /**
     * @stability stable
     */
    set profileId(value: string);
    /**
     * @stability stable
     */
    get profileIdInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _weight?;
    /**
     * @stability stable
     */
    get weight(): number;
    /**
     * @stability stable
     */
    set weight(value: number);
    /**
     * @stability stable
     */
    get weightInput(): number | undefined;
    private _customHeader?;
    /**
     * @stability stable
     */
    get customHeader(): TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customHeader(value: TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomHeader(): void;
    /**
     * @stability stable
     */
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerExternalEndpointCustomHeader[] | undefined;
    private _subnet?;
    /**
     * @stability stable
     */
    get subnet(): TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set subnet(value: TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSubnet(): void;
    /**
     * @stability stable
     */
    get subnetInput(): cdktf.IResolvable | TrafficManagerExternalEndpointSubnet[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TrafficManagerExternalEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TrafficManagerExternalEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TrafficManagerExternalEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
