import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VmwarePrivateCloudConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#internet_connection_enabled VmwarePrivateCloud#internet_connection_enabled}.
     *
     * @stability stable
     */
    readonly internetConnectionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#location VmwarePrivateCloud#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#name VmwarePrivateCloud#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#network_subnet_cidr VmwarePrivateCloud#network_subnet_cidr}.
     *
     * @stability stable
     */
    readonly networkSubnetCidr: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#nsxt_password VmwarePrivateCloud#nsxt_password}.
     *
     * @stability stable
     */
    readonly nsxtPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#resource_group_name VmwarePrivateCloud#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#sku_name VmwarePrivateCloud#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#tags VmwarePrivateCloud#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#vcenter_password VmwarePrivateCloud#vcenter_password}.
     *
     * @stability stable
     */
    readonly vcenterPassword?: string;
    /**
     * management_cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#management_cluster VmwarePrivateCloud#management_cluster}
     *
     * @stability stable
     */
    readonly managementCluster: VmwarePrivateCloudManagementCluster;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#timeouts VmwarePrivateCloud#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VmwarePrivateCloudTimeouts;
}
/**
 * @stability stable
 */
export declare class VmwarePrivateCloudCircuit extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get expressRouteId(): string;
    /**
     * @stability stable
     */
    get expressRoutePrivatePeeringId(): string;
    /**
     * @stability stable
     */
    get primarySubnetCidr(): string;
    /**
     * @stability stable
     */
    get secondarySubnetCidr(): string;
}
/**
 * @stability stable
 */
export interface VmwarePrivateCloudManagementCluster {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#size VmwarePrivateCloud#size}.
     *
     * @stability stable
     */
    readonly size: number;
}
export declare function vmwarePrivateCloudManagementClusterToTerraform(struct?: VmwarePrivateCloudManagementClusterOutputReference | VmwarePrivateCloudManagementCluster): any;
/**
 * @stability stable
 */
export declare class VmwarePrivateCloudManagementClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VmwarePrivateCloudManagementCluster | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VmwarePrivateCloudManagementCluster | undefined);
    /**
     * @stability stable
     */
    get hosts(): string[];
    /**
     * @stability stable
     */
    get id(): number;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface VmwarePrivateCloudTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#create VmwarePrivateCloud#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#delete VmwarePrivateCloud#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#read VmwarePrivateCloud#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud#update VmwarePrivateCloud#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vmwarePrivateCloudTimeoutsToTerraform(struct?: VmwarePrivateCloudTimeoutsOutputReference | VmwarePrivateCloudTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VmwarePrivateCloudTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VmwarePrivateCloudTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VmwarePrivateCloudTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud azurerm_vmware_private_cloud}.
 *
 * @stability stable
 */
export declare class VmwarePrivateCloud extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_private_cloud azurerm_vmware_private_cloud} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VmwarePrivateCloudConfig);
    /**
     * @stability stable
     */
    circuit(index: string): VmwarePrivateCloudCircuit;
    /**
     * @stability stable
     */
    get hcxCloudManagerEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _internetConnectionEnabled?;
    /**
     * @stability stable
     */
    get internetConnectionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internetConnectionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternetConnectionEnabled(): void;
    /**
     * @stability stable
     */
    get internetConnectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get managementSubnetCidr(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkSubnetCidr?;
    /**
     * @stability stable
     */
    get networkSubnetCidr(): string;
    /**
     * @stability stable
     */
    set networkSubnetCidr(value: string);
    /**
     * @stability stable
     */
    get networkSubnetCidrInput(): string | undefined;
    /**
     * @stability stable
     */
    get nsxtCertificateThumbprint(): string;
    /**
     * @stability stable
     */
    get nsxtManagerEndpoint(): string;
    private _nsxtPassword?;
    /**
     * @stability stable
     */
    get nsxtPassword(): string;
    /**
     * @stability stable
     */
    set nsxtPassword(value: string);
    /**
     * @stability stable
     */
    resetNsxtPassword(): void;
    /**
     * @stability stable
     */
    get nsxtPasswordInput(): string | undefined;
    /**
     * @stability stable
     */
    get provisioningSubnetCidr(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get vcenterCertificateThumbprint(): string;
    private _vcenterPassword?;
    /**
     * @stability stable
     */
    get vcenterPassword(): string;
    /**
     * @stability stable
     */
    set vcenterPassword(value: string);
    /**
     * @stability stable
     */
    resetVcenterPassword(): void;
    /**
     * @stability stable
     */
    get vcenterPasswordInput(): string | undefined;
    /**
     * @stability stable
     */
    get vcsaEndpoint(): string;
    /**
     * @stability stable
     */
    get vmotionSubnetCidr(): string;
    private _managementCluster;
    /**
     * @stability stable
     */
    get managementCluster(): VmwarePrivateCloudManagementClusterOutputReference;
    /**
     * @stability stable
     */
    putManagementCluster(value: VmwarePrivateCloudManagementCluster): void;
    /**
     * @stability stable
     */
    get managementClusterInput(): VmwarePrivateCloudManagementCluster | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VmwarePrivateCloudTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VmwarePrivateCloudTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VmwarePrivateCloudTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
