import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WebPubsubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#aad_auth_enabled WebPubsub#aad_auth_enabled}.
     *
     * @stability stable
     */
    readonly aadAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#capacity WebPubsub#capacity}.
     *
     * @stability stable
     */
    readonly capacity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#local_auth_enabled WebPubsub#local_auth_enabled}.
     *
     * @stability stable
     */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#location WebPubsub#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#name WebPubsub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#public_network_access_enabled WebPubsub#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#resource_group_name WebPubsub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#sku WebPubsub#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#tags WebPubsub#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#tls_client_cert_enabled WebPubsub#tls_client_cert_enabled}.
     *
     * @stability stable
     */
    readonly tlsClientCertEnabled?: boolean | cdktf.IResolvable;
    /**
     * live_trace block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#live_trace WebPubsub#live_trace}
     *
     * @stability stable
     */
    readonly liveTrace?: WebPubsubLiveTrace;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#timeouts WebPubsub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WebPubsubTimeouts;
}
/**
 * @stability stable
 */
export interface WebPubsubLiveTrace {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#connectivity_logs_enabled WebPubsub#connectivity_logs_enabled}.
     *
     * @stability stable
     */
    readonly connectivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#enabled WebPubsub#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#http_request_logs_enabled WebPubsub#http_request_logs_enabled}.
     *
     * @stability stable
     */
    readonly httpRequestLogsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#messaging_logs_enabled WebPubsub#messaging_logs_enabled}.
     *
     * @stability stable
     */
    readonly messagingLogsEnabled?: boolean | cdktf.IResolvable;
}
export declare function webPubsubLiveTraceToTerraform(struct?: WebPubsubLiveTraceOutputReference | WebPubsubLiveTrace): any;
/**
 * @stability stable
 */
export declare class WebPubsubLiveTraceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WebPubsubLiveTrace | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WebPubsubLiveTrace | undefined);
    private _connectivityLogsEnabled?;
    /**
     * @stability stable
     */
    get connectivityLogsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set connectivityLogsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetConnectivityLogsEnabled(): void;
    /**
     * @stability stable
     */
    get connectivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpRequestLogsEnabled?;
    /**
     * @stability stable
     */
    get httpRequestLogsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpRequestLogsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpRequestLogsEnabled(): void;
    /**
     * @stability stable
     */
    get httpRequestLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _messagingLogsEnabled?;
    /**
     * @stability stable
     */
    get messagingLogsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set messagingLogsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMessagingLogsEnabled(): void;
    /**
     * @stability stable
     */
    get messagingLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface WebPubsubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#create WebPubsub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#delete WebPubsub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#read WebPubsub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub#update WebPubsub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function webPubsubTimeoutsToTerraform(struct?: WebPubsubTimeoutsOutputReference | WebPubsubTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class WebPubsubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WebPubsubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WebPubsubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub azurerm_web_pubsub}.
 *
 * @stability stable
 */
export declare class WebPubsub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub azurerm_web_pubsub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WebPubsubConfig);
    private _aadAuthEnabled?;
    /**
     * @stability stable
     */
    get aadAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set aadAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAadAuthEnabled(): void;
    /**
     * @stability stable
     */
    get aadAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    /**
     * @stability stable
     */
    get externalIp(): string;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _localAuthEnabled?;
    /**
     * @stability stable
     */
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthEnabled(): void;
    /**
     * @stability stable
     */
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get publicPort(): number;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get serverPort(): number;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tlsClientCertEnabled?;
    /**
     * @stability stable
     */
    get tlsClientCertEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsClientCertEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsClientCertEnabled(): void;
    /**
     * @stability stable
     */
    get tlsClientCertEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get version(): string;
    private _liveTrace;
    /**
     * @stability stable
     */
    get liveTrace(): WebPubsubLiveTraceOutputReference;
    /**
     * @stability stable
     */
    putLiveTrace(value: WebPubsubLiveTrace): void;
    /**
     * @stability stable
     */
    resetLiveTrace(): void;
    /**
     * @stability stable
     */
    get liveTraceInput(): WebPubsubLiveTrace | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): WebPubsubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WebPubsubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WebPubsubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
