# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import typing
from enum import Enum, auto

class PyAgentType:
    r"""
    agent class
    """
    organization: builtins.str
    namespace: builtins.str
    agent_type: builtins.str
    def __new__(cls,agent_org:builtins.str, agent_ns:builtins.str, agent_class:builtins.str): ...

class PyRequestResponseConfiguration:
    r"""
    request response session config
    """
    ...

class PyService:
    id: builtins.int

class PySessionInfo:
    id: builtins.int
    def __new__(cls,session_id:builtins.int): ...

class PySessionConfiguration(Enum):
    FireAndForget = auto()
    RequestResponse = auto()
    Streaming = auto()

class PySessionDirection(Enum):
    r"""
    session direction
    """
    SENDER = auto()
    RECEIVER = auto()
    BIDIRECTIONAL = auto()

class PySessionType(Enum):
    r"""
    session type
    """
    FIRE_AND_FORGET = auto()
    REQUEST_RESPONSE = auto()
    STREAMING = auto()

def connect(svc:PyService, config:dict) -> typing.Any:
    ...

def create_pyservice(organization:builtins.str, namespace:builtins.str, agent_type:builtins.str, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def create_session(svc:PyService, config:PySessionConfiguration) -> typing.Any:
    ...

def delete_session(svc:PyService, session_id:builtins.int) -> typing.Any:
    ...

def disconnect(svc:PyService, conn:builtins.int) -> typing.Any:
    ...

def get_default_session_config(svc:PyService, session_type:PySessionType) -> typing.Any:
    ...

def get_session_config(svc:PyService, session_id:builtins.int) -> typing.Any:
    ...

def init_tracing(config:dict) -> typing.Any:
    ...

def publish(svc:PyService, session_info:PySessionInfo, fanout:builtins.int, blob:typing.Sequence[builtins.int], name:typing.Optional[PyAgentType]=None, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def receive(svc:PyService) -> typing.Any:
    ...

def remove_route(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def run_server(svc:PyService, config:dict) -> typing.Any:
    ...

def set_default_session_config(svc:PyService, config:PySessionConfiguration) -> typing.Any:
    ...

def set_route(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def set_session_config(svc:PyService, session_id:builtins.int, config:PySessionConfiguration) -> typing.Any:
    ...

def stop_server(svc:PyService, endpoint:builtins.str) -> typing.Any:
    ...

def subscribe(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def unsubscribe(svc:PyService, conn:builtins.int, name:PyAgentType, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

