URL_TYPE = {'https': 'https://', 'http': 'http://', 'ftp': 'ftp://'}

URL_DIC = {
    'eastmoney': 'datacenter-web.eastmoney.com/',
    'shibor': 'www.shibor.org/dqs/rest/cm-u-bk-shibor/',
    'LPR':'www.shibor.org/dqs/rest/cm-u-bk-currency/',
    'mofcom':'data.mofcom.gov.cn/',
    'jin10':'cdn.jin10.com/dc/reports/',
    'data-jin10':'datacenter-api.jin10.com/',
    '2jin10':'cdn.jin10.com/data_center/reports/',
    'ctci':'59.252.41.60/portal//out/dm',
    'chinamoney':'www.chinamoney.com.cn/',
    'sina':'quotes.sina.cn/',
    'institution':'114.115.232.154:8080/'
}

URL_PARA = {
    'eastmoney': 'api/data/v1/get',
    'LPR':'LprHisExcel?lang=CN&strStartDate={}&strEndDate={}',
    'data': 'ShiborHisExcel?lang=cn&startDate={}&endDate={}',
    'quote':
    'ShiborPriHisExcel?lang=cn&startDate={}&endDate={}&memCode=|100000111000000101001|100000211000000101001|100000311000000101001|100000411000000101001|100000531000000102001|100000844030000102001|100000711000000102001|100000911000000102001|100001435010000102001|200001131000000102001|101000111000000104001|102000031000000104001|290000531000000106001|100001011000000102001|100001244010000102001|101050011000000208011|100005311000000103001|100001511000000102001&instnCnNm=|%E5%B7%A5%E5%95%86%E9%93%B6%E8%A1%8C|%E5%86%9C%E4%B8%9A%E9%93%B6%E8%A1%8C|%E4%B8%AD%E5%9B%BD%E9%93%B6%E8%A1%8C|%E5%BB%BA%E8%AE%BE%E9%93%B6%E8%A1%8C|%E4%BA%A4%E9%80%9A%E9%93%B6%E8%A1%8C|%E6%8B%9B%E5%95%86%E9%93%B6%E8%A1%8C|%E4%B8%AD%E4%BF%A1%E9%93%B6%E8%A1%8C|%E5%85%89%E5%A4%A7%E9%93%B6%E8%A1%8C|%E5%85%B4%E4%B8%9A%E9%93%B6%E8%A1%8C|%E6%B5%A6%E5%8F%91%E9%93%B6%E8%A1%8C|%E5%8C%97%E4%BA%AC%E9%93%B6%E8%A1%8C|%E4%B8%8A%E6%B5%B7%E9%93%B6%E8%A1%8C|%E6%B1%87%E4%B8%B0%E9%93%B6%E8%A1%8C|%E6%B1%87%E4%B8%B0%E4%B8%AD%E5%9B%BD|%E5%8D%8E%E5%A4%8F%E9%93%B6%E8%A1%8C|%E5%B9%BF%E5%8F%91%E9%93%B6%E8%A1%8C|%E9%82%AE%E5%82%A8%E9%93%B6%E8%A1%8C|%E5%9B%BD%E5%BC%80%E8%A1%8C|%E6%B0%91%E7%94%9F%E9%93%B6%E8%A1%8C&instnEnNm=|ICBC|ABC|BOC|CBC|BOCOM|CMB|CNCB|CEB|CIB|SPDB|BOB|BOS|HSBC|HXB|GDB|PSBC|CDB|CMSB',
    'avg': 'ShiborMnHisExcel?lang=cn&startDate={}&endDate={}&tendencyvalue=',
    'ISFC':'datamofcom/front/gnmy/shrzgmQuery',
    'GDP_yoy':'dc_chinese_gdp_yoy_all.js?v={}&_={}',
    'CPI_mom':'dc_chinese_cpi_mom_all.js?v={}&_={}',
    'CPI_yoy':'dc_chinese_cpi_yoy_all.js?v={}&_={}',
    'PPI_yoy':'dc_chinese_ppi_yoy_all.js?v={}&_={}',
    'exports_yoy':'dc_chinese_exports_yoy_all.js?v=({},{})',
    'imports_yoy':'dc_chinese_imports_yoy_all.js?v=({},{})',
    'trade_balance':'dc_chinese_trade_balance_all.js?v=({},{})',
    'industrial_production_yoy':'dc_chinese_industrial_production_yoy_all.js?v=v=({},{})',
    'PMI_yoy':'dc_chinese_manufacturing_pmi_all.js?v={}&_={}',
    'cx_PMI_yoy':'dc_chinese_caixin_manufacturing_pmi_all.js?v={}&_={}',
    'cx_services_PMI_yoy':'dc_chinese_caixin_services_pmi_all.js?v={}&_={}',
    'non_man_PMI':'dc_chinese_non_manufacturing_pmi_all.js?v={}&_={}',
    'fx_reserves':'dc_chinese_fx_reserves_all.js?v={}&_={}',
    'M2_yearly':'dc_chinese_m2_money_supply_yoy_all.js?v={}&_={}',
    'daily_energy':'dc_qihuo_energy_report_all.js?v={}&_={}',
    'rmb':'exchange_rate.json',
    'market_margin_sz':'fs_2.json',
    'market_margin_sh':'dc_market_margin_sse_all.js?v={}&_={}',
    'au_report':'sge.json',
    'list_v2':'reports/list_v2',
    'ctci':'?t=157829853359',
    'ctci_detail':'/list/cebdf627f9c24c22a507e2f2e25e2b43?t=1578298533161',
    'ctci_detail_hist':'/listAll?t=1578299685398',
    'society_electricity':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601557771972/MacPage_Service.get_pagedata',
    'society_traffic_volume':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK160155094538/MacPage_Service.get_pagedata',
    'postal_telecommunicational':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601624495046/MacPage_Service.get_pagedata',
    'international_tourism_fx':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601651495761/MacPage_Service.get_pagedata',
    'passenger_load_factor':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601651495761/MacPage_Service.get_pagedata',
    'freight_index':'mac/view/vMacExcle.php',
    'central_bank_balance':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601651495761/MacPage_Service.get_pagedata',
    'insurance':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601651495761/MacPage_Service.get_pagedata',
    'supply_of_money':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601651495761/MacPage_Service.get_pagedata',
    'swap_rate':'ags/ms/cm-u-bk-shibor/IfccHis',
    'foreign_exchange_gold':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601651495761/MacPage_Service.get_pagedata',
    'retail_price_index':'mac/api/jsonp_v3.php/SINAREMOTECALLCALLBACK1601651495761/MacPage_Service.get_pagedata',
    'cons_opec_month_1':'reports/dates?category=opec&_={}',
    'cons_opec_month_2':'reports/list?category=opec&date={}&_={}',
    'jin10_5':'reports/dates',
    'lme_holding':'lme_position.json',
    'lme_stock':'lme_stock.json',
    'leverage_ratio':'handler/download.ashx',
    'crypto': 'crypto_currency/list',
    'sentiment':'sentiment/datas',
    'vix': 'vix/datas',
    'INTEREST_RATE':'dc_usa_interest_rate_decision_all.js?v={}&_={}',
    'NON_FARM':'dc_nonfarm_payrolls_all.js?v={}&_={}',
    'UNEMPLOYMENT_RATE':'dc_usa_unemployment_rate_all.js??v={}&_={}',
    'EIA_CRUDE':'dc_eia_crude_oil_all.js?v={}&_={}',
    'INITIAL_JOBLESS':'dc_initial_jobless_all.js?v={}&_={}',
    'CORE_PCE_PRICE':'dc_usa_core_pce_price_all.js?v={}&_={}',
    'LMCI':'dc_usa_lmci_all.js?v={}&_={}',
    'CPI_MONTHLY':'dc_usa_cpi_all.js?v={}&_={}',
    'ADP_NONFARM':'dc_adp_nonfarm_employment_all.js?v={}&_={}',
    'GDP_MONTHLY':'dc_usa_gdp_all.js?v={}&_={}',
    'EIA_CRUDE_PRODUCE':'dc_eia_crude_oil_produce_all.js?v={}&_={}',
    'core_cpi_monthly':'dc_usa_core_cpi_all.js?v=({},{})',
    'personal_spending':'dc_usa_personal_spending_all.js?v=({},{})',
    'usa_retail_sales':'dc_usa_retail_sales_all.js?v=({},{})',
    'import_price':'dc_usa_import_price_all.js?v=({},{})',
    'export_price':'dc_usa_export_price_all.js?v=({},{})',
    'usa_job_cuts':'dc_usa_job_cuts_all.js?v=({},{})',
    'real_consumer_spending':'dc_usa_real_consumer_spending_all.js?v=({},{})',
    'usa_trade_balance':'dc_usa_trade_balance_all.js?v=({},{})',
    'usa_current_account':'dc_usa_current_account_all.js?v=({},{})',
    'rig_count':'baker.json',
    'usa_ppi':'dc_usa_ppi_all.js?v=({},{})',
    'usa_core_ppi':'dc_usa_core_ppi_all.js?v=({},{})',
    'usa_api_crude_stock':'dc_usa_api_crude_stock_all.js?v=({},{})',
    'usa_pmi':'dc_usa_pmi_all.js?v=({},{})',
    'usa_ism_pmi':'dc_usa_ism_pmi_all.js?v=({},{})',
    'usa_industrial_production':'dc_usa_industrial_production_all.js?v=({},{})',
    'usa_durable_goods_orders':'dc_usa_durable_goods_orders_all.js?v=({},{})',
    'usa_factory_orders':'dc_usa_factory_orders_all.js?v=({},{})',
    'usa_services_pmi':'dc_usa_services_pmi_all.js?v=({},{})',
    'usa_business_inventories':'dc_usa_business_inventories_all.js?v=({},{})',
    'usa_ism_non_pmi':'dc_usa_ism_non_pmi_all.js?v=({},{})',
    'usa_nahb_house_market_index':'dc_usa_nahb_house_market_index_all.js?v=({},{})',
    'usa_house_starts':'dc_usa_house_starts_all.js?v=({},{})',
    'usa_new_home_sales':'dc_usa_new_home_sales_all.js?v=({},{})',
    'usa_building_permits':'dc_usa_building_permits_all.js?v=({},{})',
    'usa_exist_home_sales':'dc_usa_exist_home_sales_all.js?v=({},{})',
    'usa_house_price_index':'dc_usa_house_price_index_all.js?v=({},{})',
    'usa_spcs20':'dc_usa_spcs20_all.js?v=({},{})',
    'usa_pending_home_sales':'dc_usa_pending_home_sales_all.js?v=({},{})',
    'usa_cb_consumer_confidence':'dc_usa_cb_consumer_confidence_all.js?v=({},{})',
    'usa_nfib_small_business':'dc_usa_nfib_small_business_all.js?v=({},{})',
    'usa_michigan_consumer_sentiment':'dc_usa_michigan_consumer_sentiment_all.js?v=({},{})',
    'usa_crude_inner':'usa_oil.json',
    'usa_cftc_nc_holding':'cftc_4.json',
    'usa_cftc_c_holding':'cftc_2.json',
    'usa_cftc_merchant_currency_holding':'cftc_3.json',
    'usa_cftc_merchant_goods_holding':'cftc_1.json'


}

REQ_COLUMNS = {
    "China_CGPI":"REPORT_DATE,TIME,BASE,BASE_SAME,BASE_SEQUENTIAL,FARM_BASE,FARM_BASE_SAME,FARM_BASE_SEQUENTIAL,MINERAL_BASE,MINERAL_BASE_SAME,MINERAL_BASE_SEQUENTIAL,ENERGY_BASE,ENERGY_BASE_SAME,ENERGY_BASE_SEQUENTIAL",
    "China_FDI":"REPORT_DATE,TIME,ACTUAL_FOREIGN,ACTUAL_FOREIGN_SAME,ACTUAL_FOREIGN_SEQUENTIAL,ACTUAL_FOREIGN_ACCUMULATE,FOREIGN_ACCUMULATE_SAME"
}

TABLE_COLUMN = {
    'China_CGPI':[
        "月份",
        "总指数-指数值",
        "总指数-同比增长",
        "总指数-环比增长",
        "农产品-指数值",
        "农产品-同比增长",
        "农产品-环比增长",
        "矿产品-指数值",
        "矿产品-同比增长",
        "矿产品-环比增长",
        "煤油电-指数值",
        "煤油电-同比增长",
        "煤油电-环比增长"
    ],
    'China_FDI':[
        "月份",
        "当月",
        "当月-同比增长",
        "当月-环比增长",
        "累计",
        "累计-同比增长",
    ],
    'China_ISFC_1':[
        "月份",
        "其中-未贴现银行承兑汇票",
        "其中-委托贷款",
        "其中-委托贷款外币贷款",
        "其中-人民币贷款",
        "其中-企业债券",
        "社会融资规模增量",
        "其中-非金融企业境内股票融资",
        "其中-信托贷款",
    ],
    'China_ISFC_2':[
        "月份",
        "社会融资规模增量",
        "其中-人民币贷款",
        "其中-委托贷款外币贷款",
        "其中-委托贷款",
        "其中-信托贷款",
        "其中-未贴现银行承兑汇票",
        "其中-企业债券",
        "其中-非金融企业境内股票融资",
    ]
}

HEADERS = {
    'jin10':{
        "accept": "*/*",
        "accept-encoding": "gzip, deflate, br",
        "accept-language": "zh-CN,zh;q=0.9,en;q=0.8",
        "cache-control": "no-cache",
        "origin": "https://datacenter.jin10.com",
        "pragma": "no-cache",
        "referer": "https://datacenter.jin10.com/reportType/dc_usa_michigan_consumer_sentiment",
        "sec-fetch-dest": "empty",
        "sec-fetch-mode": "cors",
        "sec-fetch-site": "same-site",
        "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36",
        "x-app-id": "rU6QIu7JHe2gOUeR",
        "x-csrf-token": "",
        "x-version": "1.0.0",
    },
    '2jin10': {
        "accept": "*/*",
        "accept-encoding": "gzip, deflate, br",
        "accept-language": "zh-CN,zh;q=0.9,en;q=0.8",
        "cache-control": "no-cache",
        "origin": "https://datacenter.jin10.com",
        "pragma": "no-cache",
        "referer": "https://datacenter.jin10.com/reportType/dc_market_margin_sse",
        "sec-fetch-dest": "empty",
        "sec-fetch-mode": "cors",
        "sec-fetch-site": "same-site",
        "x-app-id": "rU6QIu7JHe2gOUeR",
        "x-csrf-token": "",
        "x-version": "1.0.0",
        "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.135 Safari/537.36",
    },
    '3jin10':{
        "accept": "*/*",
        "accept-encoding": "gzip, deflate, br",
        "accept-language": "zh-CN,zh;q=0.9,en;q=0.8",
        "cache-control": "no-cache",
        "origin": "https://datacenter.jin10.com",
        "pragma": "no-cache",
        "sec-fetch-dest": "empty",
        "sec-fetch-mode": "cors",
        "sec-fetch-site": "same-site",
        "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36",
        "x-app-id": "rU6QIu7JHe2gOUeR",
        "x-csrf-token": "",
        "x-version": "1.0.0",
    },
    '4jin10':{
        "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36",
        "x-app-id": "rU6QIu7JHe2gOUeR",
        "x-csrf-token": "x-csrf-token",
        "x-version": "1.0.0",
    },
    '5jin10':{
        "accept": "*/*",
        "accept-encoding": "gzip, deflate, br",
        "accept-language": "zh-CN,zh;q=0.9,en;q=0.8",
        "cache-control": "no-cache",
        "origin": "https://datacenter.jin10.com",
        "pragma": "no-cache",
        "referer": "https://datacenter.jin10.com/reportType/dc_opec_report",
        "sec-fetch-mode": "cors",
        "sec-fetch-site": "same-site",
        "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36",
        "x-app-id": "rU6QIu7JHe2gOUeR",
        "x-csrf-token": "",
        "x-version": "1.0.0",
    },
    'chinamoney':{
        "Accept": "application/json, text/javascript, */*; q=0.01",
        "Accept-Encoding": "gzip, deflate, br",
        "Accept-Language": "zh-CN,zh;q=0.9,en;q=0.8",
        "Cache-Control": "no-cache",
        "Connection": "keep-alive",
        "Content-Length": "0",
        "Host": "www.chinamoney.com.cn",
        "Origin": "https://www.chinamoney.com.cn",
        "Pragma": "no-cache",
        "Referer": "https://www.chinamoney.com.cn/chinese/bkcurvfxhis/?cfgItemType=72&curveType=FR007",
        "sec-ch-ua": '"Google Chrome";v="107", "Chromium";v="107", "Not=A?Brand";v="24"',
        "sec-ch-ua-mobile": "?0",
        "sec-ch-ua-platform": '"Windows"',
        "Sec-Fetch-Dest": "empty",
        "Sec-Fetch-Mode": "cors",
        "Sec-Fetch-Site": "same-origin",
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36",
        "X-Requested-With": "XMLHttpRequest"
    }
}