"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .capture_mode_response import CaptureModeResponse
from .entity_payment_route_response import (
    EntityPaymentRouteResponse,
    EntityPaymentRouteResponseTypedDict,
)
from .line_categories_response import LineCategoriesResponse
from .locale_response import LocaleResponse
from .metadata import Metadata, MetadataTypedDict
from .method_response import MethodResponse
from .mode import Mode
from .payment_address import PaymentAddress, PaymentAddressTypedDict
from .payment_details_card_audition_response import PaymentDetailsCardAuditionResponse
from .payment_details_card_funding_response import PaymentDetailsCardFundingResponse
from .payment_details_card_label_response import PaymentDetailsCardLabelResponse
from .payment_details_card_security_response import PaymentDetailsCardSecurityResponse
from .payment_details_failure_reason_response import PaymentDetailsFailureReasonResponse
from .payment_details_fee_region_response import PaymentDetailsFeeRegionResponse
from .payment_details_receipt_card_read_method_response import (
    PaymentDetailsReceiptCardReadMethodResponse,
)
from .payment_details_receipt_card_verification_method_response import (
    PaymentDetailsReceiptCardVerificationMethodResponse,
)
from .payment_details_seller_protection_response import (
    PaymentDetailsSellerProtectionResponse,
)
from .payment_details_wallet_response import PaymentDetailsWalletResponse
from .payment_line_type_response import PaymentLineTypeResponse
from .payment_status import PaymentStatus
from .recurring_line_item import RecurringLineItem, RecurringLineItemTypedDict
from .sequence_type_response import SequenceTypeResponse
from .status_reason import StatusReason, StatusReasonTypedDict
from .url import URL, URLTypedDict
from datetime import date
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentResponseLineTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    type: NotRequired[PaymentLineTypeResponse]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """
    vat_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[LineCategoriesResponse]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""
    recurring: NotRequired[RecurringLineItemTypedDict]


class PaymentResponseLine(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[Amount, pydantic.Field(alias="unitPrice")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[Amount, pydantic.Field(alias="totalAmount")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    type: Annotated[
        Optional[PaymentLineTypeResponse], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="discountAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """

    vat_amount: Annotated[Optional[Amount], pydantic.Field(alias="vatAmount")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[
        List[
            Annotated[LineCategoriesResponse, PlainValidator(validate_open_enum(False))]
        ]
    ] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""

    recurring: Optional[RecurringLineItem] = None


class PaymentResponseApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: NotRequired[str]
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class PaymentResponseApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: Optional[str] = None
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class ReceiptTypedDict(TypedDict):
    r"""The Point of sale receipt object."""

    authorization_code: NotRequired[Nullable[str]]
    r"""A unique code provided by the cardholder’s bank to confirm that the transaction was successfully approved."""
    application_identifier: NotRequired[Nullable[str]]
    r"""The unique number that identifies a specific payment application on a chip card."""
    card_read_method: NotRequired[Nullable[PaymentDetailsReceiptCardReadMethodResponse]]
    r"""The method by which the card was read by the terminal."""
    card_verification_method: NotRequired[
        Nullable[PaymentDetailsReceiptCardVerificationMethodResponse]
    ]
    r"""The method used to verify the cardholder's identity."""


class Receipt(BaseModel):
    r"""The Point of sale receipt object."""

    authorization_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="authorizationCode")
    ] = UNSET
    r"""A unique code provided by the cardholder’s bank to confirm that the transaction was successfully approved."""

    application_identifier: Annotated[
        OptionalNullable[str], pydantic.Field(alias="applicationIdentifier")
    ] = UNSET
    r"""The unique number that identifies a specific payment application on a chip card."""

    card_read_method: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsReceiptCardReadMethodResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="cardReadMethod"),
    ] = UNSET
    r"""The method by which the card was read by the terminal."""

    card_verification_method: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsReceiptCardVerificationMethodResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="cardVerificationMethod"),
    ] = UNSET
    r"""The method used to verify the cardholder's identity."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "authorizationCode",
            "applicationIdentifier",
            "cardReadMethod",
            "cardVerificationMethod",
        ]
        nullable_fields = [
            "authorizationCode",
            "applicationIdentifier",
            "cardReadMethod",
            "cardVerificationMethod",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class QrCodeTypedDict(TypedDict):
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """

    height: NotRequired[int]
    r"""The height of the QR code image in pixels."""
    width: NotRequired[int]
    r"""The width of the QR code image in pixels."""
    src: NotRequired[str]
    r"""The URL to the QR code image. The image is a PNG file, and can be displayed directly in the browser or
    downloaded.
    """


class QrCode(BaseModel):
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """

    height: Optional[int] = None
    r"""The height of the QR code image in pixels."""

    width: Optional[int] = None
    r"""The width of the QR code image in pixels."""

    src: Optional[str] = None
    r"""The URL to the QR code image. The image is a PNG file, and can be displayed directly in the browser or
    downloaded.
    """


class PaymentResponseDetailsTypedDict(TypedDict):
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """

    consumer_name: NotRequired[Nullable[str]]
    r"""The customer's name, if made available by the payment method. For card payments, refer to details.cardHolder."""
    consumer_account: NotRequired[Nullable[str]]
    r"""The customer's account reference.

    For banking-based payment methods — such as iDEAL — this is normally either an IBAN or a domestic bank account
    number.

    For PayPal, the account reference is an email address.

    For card and Bancontact payments, refer to details.cardNumber.
    """
    consumer_bic: NotRequired[Nullable[str]]
    r"""The BIC of the customer's bank account, if applicable."""
    shipping_address: NotRequired[Nullable[Dict[str, Any]]]
    r"""For wallet payment methods — such as Apple Pay and PayPal — the shipping address is often already known by the
    wallet provider. In these cases the shipping address may be available as a payment detail.
    """
    card_number: NotRequired[Nullable[str]]
    r"""For bancontact, it will be the customer's masked card number. For cards, it will be the last 4-digit of the
    PAN. For Point-of-sale, it will be the the last 4 digits of the customer's masked card number.
    """
    bank_name: NotRequired[str]
    r"""The name of the bank that the customer will need to make the bank transfer payment towards."""
    bank_account: NotRequired[str]
    r"""The bank account number the customer will need to make the bank transfer payment towards."""
    bank_bic: NotRequired[str]
    r"""The BIC of the bank the customer will need to make the bank transfer payment towards."""
    transfer_reference: NotRequired[Nullable[str]]
    r"""The Mollie-generated reference the customer needs to use when transfering the amount. Do not apply any
    formatting here; show it to the customer as-is.
    """
    card_fingerprint: NotRequired[Nullable[str]]
    r"""A unique fingerprint for a specific card. Can be used to identify returning customers.

    In the case of Point-of-sale payments, it's a unique identifier assigned to a cardholder's payment account,
    linking multiple transactions from wallets and physical card to a single account, also across payment methods
    or when the card is reissued.
    """
    card_holder: NotRequired[Nullable[str]]
    r"""The customer's name as shown on their card."""
    card_audition: NotRequired[Nullable[PaymentDetailsCardAuditionResponse]]
    r"""The card's target audience, if known."""
    card_label: NotRequired[Nullable[PaymentDetailsCardLabelResponse]]
    r"""The card's label, if known."""
    card_country_code: NotRequired[Nullable[str]]
    r"""The ISO 3166-1 alpha-2 country code of the country the card was issued in."""
    card_expiry_date: NotRequired[Nullable[str]]
    r"""The expiry date (MM/YY) of the card as displayed on the card."""
    card_funding: NotRequired[Nullable[PaymentDetailsCardFundingResponse]]
    r"""The card type."""
    card_security: NotRequired[Nullable[PaymentDetailsCardSecurityResponse]]
    r"""The level of security applied during card processing."""
    fee_region: NotRequired[Nullable[PaymentDetailsFeeRegionResponse]]
    r"""The applicable card fee region."""
    card_masked_number: NotRequired[Nullable[str]]
    r"""The first 6 and last 4 digits of the card number."""
    card3ds_eci: NotRequired[Nullable[str]]
    r"""The outcome of authentication attempted on transactions enforced by 3DS (ie valid only for oneoff and first)."""
    card_bin: NotRequired[Nullable[str]]
    r"""The first 6 digit of the card bank identification number."""
    card_issuer: NotRequired[Nullable[str]]
    r"""The issuer of the Card."""
    failure_reason: NotRequired[Nullable[PaymentDetailsFailureReasonResponse]]
    r"""A failure code to help understand why the payment failed."""
    failure_message: NotRequired[Nullable[str]]
    r"""A human-friendly failure message that can be shown to the customer. The message is translated in accordance
    with the payment's locale setting.
    """
    wallet: NotRequired[Nullable[PaymentDetailsWalletResponse]]
    r"""The wallet used when creating the payment."""
    paypal_reference: NotRequired[Nullable[str]]
    r"""PayPal's reference for the payment."""
    paypal_payer_id: NotRequired[Nullable[str]]
    r"""ID of the customer's PayPal account."""
    seller_protection: NotRequired[Nullable[PaymentDetailsSellerProtectionResponse]]
    r"""Indicates to what extent the payment is eligible for PayPal's Seller Protection. Only available for PayPal
    payments, and if the information is made available by PayPal.
    """
    paypal_fee: NotRequired[Nullable[AmountNullableTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    customer_reference: NotRequired[str]
    r"""The paysafecard customer reference either provided via the API or otherwise auto-generated by Mollie."""
    terminal_id: NotRequired[str]
    r"""The ID of the terminal device where the payment took place on."""
    masked_number: NotRequired[Nullable[str]]
    r"""The first 6 digits & last 4 digits of the customer's masked card number."""
    receipt: NotRequired[ReceiptTypedDict]
    r"""The Point of sale receipt object."""
    creditor_identifier: NotRequired[Nullable[str]]
    r"""The creditor identifier indicates who is authorized to execute the payment. In this case, it is a
    reference to Mollie.
    """
    due_date: NotRequired[Nullable[date]]
    r"""Estimated date the payment is debited from the customer's bank account, in YYYY-MM-DD format."""
    signature_date: NotRequired[Nullable[date]]
    r"""Date the payment has been signed by the customer, in YYYY-MM-DD format. Only available if the payment
    has been signed.
    """
    bank_reason_code: NotRequired[Nullable[str]]
    r"""The official reason why this payment has failed. A detailed description of each reason is available on the
    website of the European Payments Council.
    """
    bank_reason: NotRequired[Nullable[str]]
    r"""A human-friendly description of the failure reason."""
    end_to_end_identifier: NotRequired[Nullable[str]]
    r"""The end-to-end identifier you provided in the batch file."""
    mandate_reference: NotRequired[Nullable[str]]
    r"""The mandate reference you provided in the batch file."""
    batch_reference: NotRequired[Nullable[str]]
    r"""The batch reference you provided in the batch file."""
    file_reference: NotRequired[Nullable[str]]
    r"""The file reference you provided in the batch file."""
    qr_code: NotRequired[QrCodeTypedDict]
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """
    voucher_number: NotRequired[str]
    r"""For payments with gift cards: the masked gift card number of the first gift card applied to the payment."""
    giftcards: NotRequired[List[Dict[str, Any]]]
    r"""An array of detail objects for each gift card that was used on this payment, if any."""
    issuer: NotRequired[str]
    r"""For payments with vouchers: the brand name of the first voucher applied."""
    vouchers: NotRequired[List[Dict[str, Any]]]
    r"""An array of detail objects for each voucher that was used on this payment, if any."""
    remainder_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    remainder_method: NotRequired[str]
    r"""The payment method used to pay the remainder amount, after all gift cards or vouchers were applied."""
    remainder_details: NotRequired[Dict[str, Any]]
    r"""Optional include. The full payment method details of the remainder payment."""


class PaymentResponseDetails(BaseModel):
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """

    consumer_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerName")
    ] = UNSET
    r"""The customer's name, if made available by the payment method. For card payments, refer to details.cardHolder."""

    consumer_account: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerAccount")
    ] = UNSET
    r"""The customer's account reference.

    For banking-based payment methods — such as iDEAL — this is normally either an IBAN or a domestic bank account
    number.

    For PayPal, the account reference is an email address.

    For card and Bancontact payments, refer to details.cardNumber.
    """

    consumer_bic: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerBic")
    ] = UNSET
    r"""The BIC of the customer's bank account, if applicable."""

    shipping_address: Annotated[
        OptionalNullable[Dict[str, Any]], pydantic.Field(alias="shippingAddress")
    ] = UNSET
    r"""For wallet payment methods — such as Apple Pay and PayPal — the shipping address is often already known by the
    wallet provider. In these cases the shipping address may be available as a payment detail.
    """

    card_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardNumber")
    ] = UNSET
    r"""For bancontact, it will be the customer's masked card number. For cards, it will be the last 4-digit of the
    PAN. For Point-of-sale, it will be the the last 4 digits of the customer's masked card number.
    """

    bank_name: Annotated[Optional[str], pydantic.Field(alias="bankName")] = None
    r"""The name of the bank that the customer will need to make the bank transfer payment towards."""

    bank_account: Annotated[Optional[str], pydantic.Field(alias="bankAccount")] = None
    r"""The bank account number the customer will need to make the bank transfer payment towards."""

    bank_bic: Annotated[Optional[str], pydantic.Field(alias="bankBic")] = None
    r"""The BIC of the bank the customer will need to make the bank transfer payment towards."""

    transfer_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="transferReference")
    ] = UNSET
    r"""The Mollie-generated reference the customer needs to use when transfering the amount. Do not apply any
    formatting here; show it to the customer as-is.
    """

    card_fingerprint: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardFingerprint")
    ] = UNSET
    r"""A unique fingerprint for a specific card. Can be used to identify returning customers.

    In the case of Point-of-sale payments, it's a unique identifier assigned to a cardholder's payment account,
    linking multiple transactions from wallets and physical card to a single account, also across payment methods
    or when the card is reissued.
    """

    card_holder: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardHolder")
    ] = UNSET
    r"""The customer's name as shown on their card."""

    card_audition: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsCardAuditionResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="cardAudition"),
    ] = UNSET
    r"""The card's target audience, if known."""

    card_label: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsCardLabelResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="cardLabel"),
    ] = UNSET
    r"""The card's label, if known."""

    card_country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardCountryCode")
    ] = UNSET
    r"""The ISO 3166-1 alpha-2 country code of the country the card was issued in."""

    card_expiry_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardExpiryDate")
    ] = UNSET
    r"""The expiry date (MM/YY) of the card as displayed on the card."""

    card_funding: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsCardFundingResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="cardFunding"),
    ] = UNSET
    r"""The card type."""

    card_security: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsCardSecurityResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="cardSecurity"),
    ] = UNSET
    r"""The level of security applied during card processing."""

    fee_region: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsFeeRegionResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="feeRegion"),
    ] = UNSET
    r"""The applicable card fee region."""

    card_masked_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardMaskedNumber")
    ] = UNSET
    r"""The first 6 and last 4 digits of the card number."""

    card3ds_eci: Annotated[
        OptionalNullable[str], pydantic.Field(alias="card3dsEci")
    ] = UNSET
    r"""The outcome of authentication attempted on transactions enforced by 3DS (ie valid only for oneoff and first)."""

    card_bin: Annotated[OptionalNullable[str], pydantic.Field(alias="cardBin")] = UNSET
    r"""The first 6 digit of the card bank identification number."""

    card_issuer: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardIssuer")
    ] = UNSET
    r"""The issuer of the Card."""

    failure_reason: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsFailureReasonResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="failureReason"),
    ] = UNSET
    r"""A failure code to help understand why the payment failed."""

    failure_message: Annotated[
        OptionalNullable[str], pydantic.Field(alias="failureMessage")
    ] = UNSET
    r"""A human-friendly failure message that can be shown to the customer. The message is translated in accordance
    with the payment's locale setting.
    """

    wallet: Annotated[
        OptionalNullable[PaymentDetailsWalletResponse],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The wallet used when creating the payment."""

    paypal_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="paypalReference")
    ] = UNSET
    r"""PayPal's reference for the payment."""

    paypal_payer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="paypalPayerId")
    ] = UNSET
    r"""ID of the customer's PayPal account."""

    seller_protection: Annotated[
        Annotated[
            OptionalNullable[PaymentDetailsSellerProtectionResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="sellerProtection"),
    ] = UNSET
    r"""Indicates to what extent the payment is eligible for PayPal's Seller Protection. Only available for PayPal
    payments, and if the information is made available by PayPal.
    """

    paypal_fee: Annotated[
        OptionalNullable[AmountNullable], pydantic.Field(alias="paypalFee")
    ] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    customer_reference: Annotated[
        Optional[str], pydantic.Field(alias="customerReference")
    ] = None
    r"""The paysafecard customer reference either provided via the API or otherwise auto-generated by Mollie."""

    terminal_id: Annotated[Optional[str], pydantic.Field(alias="terminalId")] = None
    r"""The ID of the terminal device where the payment took place on."""

    masked_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="maskedNumber")
    ] = UNSET
    r"""The first 6 digits & last 4 digits of the customer's masked card number."""

    receipt: Optional[Receipt] = None
    r"""The Point of sale receipt object."""

    creditor_identifier: Annotated[
        OptionalNullable[str], pydantic.Field(alias="creditorIdentifier")
    ] = UNSET
    r"""The creditor identifier indicates who is authorized to execute the payment. In this case, it is a
    reference to Mollie.
    """

    due_date: Annotated[OptionalNullable[date], pydantic.Field(alias="dueDate")] = UNSET
    r"""Estimated date the payment is debited from the customer's bank account, in YYYY-MM-DD format."""

    signature_date: Annotated[
        OptionalNullable[date], pydantic.Field(alias="signatureDate")
    ] = UNSET
    r"""Date the payment has been signed by the customer, in YYYY-MM-DD format. Only available if the payment
    has been signed.
    """

    bank_reason_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="bankReasonCode")
    ] = UNSET
    r"""The official reason why this payment has failed. A detailed description of each reason is available on the
    website of the European Payments Council.
    """

    bank_reason: Annotated[
        OptionalNullable[str], pydantic.Field(alias="bankReason")
    ] = UNSET
    r"""A human-friendly description of the failure reason."""

    end_to_end_identifier: Annotated[
        OptionalNullable[str], pydantic.Field(alias="endToEndIdentifier")
    ] = UNSET
    r"""The end-to-end identifier you provided in the batch file."""

    mandate_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="mandateReference")
    ] = UNSET
    r"""The mandate reference you provided in the batch file."""

    batch_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="batchReference")
    ] = UNSET
    r"""The batch reference you provided in the batch file."""

    file_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fileReference")
    ] = UNSET
    r"""The file reference you provided in the batch file."""

    qr_code: Annotated[Optional[QrCode], pydantic.Field(alias="qrCode")] = None
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """

    voucher_number: Annotated[Optional[str], pydantic.Field(alias="voucherNumber")] = (
        None
    )
    r"""For payments with gift cards: the masked gift card number of the first gift card applied to the payment."""

    giftcards: Optional[List[Dict[str, Any]]] = None
    r"""An array of detail objects for each gift card that was used on this payment, if any."""

    issuer: Optional[str] = None
    r"""For payments with vouchers: the brand name of the first voucher applied."""

    vouchers: Optional[List[Dict[str, Any]]] = None
    r"""An array of detail objects for each voucher that was used on this payment, if any."""

    remainder_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="remainderAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    remainder_method: Annotated[
        Optional[str], pydantic.Field(alias="remainderMethod")
    ] = None
    r"""The payment method used to pay the remainder amount, after all gift cards or vouchers were applied."""

    remainder_details: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="remainderDetails")
    ] = None
    r"""Optional include. The full payment method details of the remainder payment."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "shippingAddress",
            "cardNumber",
            "bankName",
            "bankAccount",
            "bankBic",
            "transferReference",
            "cardFingerprint",
            "cardHolder",
            "cardAudition",
            "cardLabel",
            "cardCountryCode",
            "cardExpiryDate",
            "cardFunding",
            "cardSecurity",
            "feeRegion",
            "cardMaskedNumber",
            "card3dsEci",
            "cardBin",
            "cardIssuer",
            "failureReason",
            "failureMessage",
            "wallet",
            "paypalReference",
            "paypalPayerId",
            "sellerProtection",
            "paypalFee",
            "customerReference",
            "terminalId",
            "maskedNumber",
            "receipt",
            "creditorIdentifier",
            "dueDate",
            "signatureDate",
            "bankReasonCode",
            "bankReason",
            "endToEndIdentifier",
            "mandateReference",
            "batchReference",
            "fileReference",
            "qrCode",
            "voucherNumber",
            "giftcards",
            "issuer",
            "vouchers",
            "remainderAmount",
            "remainderMethod",
            "remainderDetails",
        ]
        nullable_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "shippingAddress",
            "cardNumber",
            "transferReference",
            "cardFingerprint",
            "cardHolder",
            "cardAudition",
            "cardLabel",
            "cardCountryCode",
            "cardExpiryDate",
            "cardFunding",
            "cardSecurity",
            "feeRegion",
            "cardMaskedNumber",
            "card3dsEci",
            "cardBin",
            "cardIssuer",
            "failureReason",
            "failureMessage",
            "wallet",
            "paypalReference",
            "paypalPayerId",
            "sellerProtection",
            "paypalFee",
            "maskedNumber",
            "creditorIdentifier",
            "dueDate",
            "signatureDate",
            "bankReasonCode",
            "bankReason",
            "endToEndIdentifier",
            "mandateReference",
            "batchReference",
            "fileReference",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    checkout: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    mobile_app_checkout: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    change_payment_state: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    refunds: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    chargebacks: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    captures: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    mandate: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    subscription: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    order: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    terminal: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    status: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    pay_online: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    checkout: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    mobile_app_checkout: Annotated[
        Optional[URL], pydantic.Field(alias="mobileAppCheckout")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    change_payment_state: Annotated[
        Optional[URL], pydantic.Field(alias="changePaymentState")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    refunds: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    chargebacks: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    captures: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    mandate: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    subscription: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    order: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    terminal: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    status: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    pay_online: Annotated[Optional[URL], pydantic.Field(alias="payOnline")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentResponseTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a payment object. Will always contain the string `payment` for this endpoint."""
    id: NotRequired[str]
    mode: NotRequired[Mode]
    r"""Whether this entity was created in live mode or in test mode."""
    description: NotRequired[str]
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_refunded: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_remaining: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_captured: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_charged_back: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    settlement_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    lines: NotRequired[Nullable[List[PaymentResponseLineTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[PaymentAddressTypedDict]
    shipping_address: NotRequired[PaymentAddressTypedDict]
    locale: NotRequired[Nullable[LocaleResponse]]
    r"""Allows you to preset the language to be used."""
    country_code: NotRequired[Nullable[str]]
    r"""This optional field contains your customer's ISO 3166-1 alpha-2 country code, detected by us during checkout. This
    field is omitted if the country code was not detected.
    """
    method: NotRequired[Nullable[MethodResponse]]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    capture_mode: NotRequired[Nullable[CaptureModeResponse]]
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """
    capture_delay: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """
    capture_before: NotRequired[Nullable[str]]
    r"""Indicates the date before which the payment needs to be captured, in ISO 8601 format. From this date onwards we
    can no longer guarantee a successful capture. The parameter is omitted if the payment is not authorized (yet).
    """
    application_fee: NotRequired[Nullable[PaymentResponseApplicationFeeTypedDict]]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """
    routing: NotRequired[Nullable[List[EntityPaymentRouteResponseTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """
    sequence_type: NotRequired[SequenceTypeResponse]
    subscription_id: NotRequired[str]
    mandate_id: NotRequired[str]
    customer_id: NotRequired[str]
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    settlement_id: NotRequired[str]
    order_id: NotRequired[str]
    status: NotRequired[PaymentStatus]
    r"""The payment's status. Refer to the [documentation regarding statuses](https://docs.mollie.com/docs/status-change#/) for more info about which
    statuses occur at what point.
    """
    status_reason: NotRequired[Nullable[StatusReasonTypedDict]]
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale
    payments.

    You can find more information about the possible values of this object on
    [this page](status-reasons).**
    """
    is_cancelable: NotRequired[Nullable[bool]]
    r"""Whether the payment can be canceled. This parameter is omitted if the payment reaches a final state."""
    details: NotRequired[Nullable[PaymentResponseDetailsTypedDict]]
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    authorized_at: NotRequired[Nullable[str]]
    r"""The date and time the payment became authorized, in ISO 8601 format. This parameter is omitted if the payment is
    not authorized (yet).
    """
    paid_at: NotRequired[Nullable[str]]
    r"""The date and time the payment became paid, in ISO 8601 format. This parameter is omitted if the payment is not
    completed (yet).
    """
    canceled_at: NotRequired[Nullable[str]]
    r"""The date and time the payment was canceled, in ISO 8601 format. This parameter is omitted if the payment is not
    canceled (yet).
    """
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time the payment will expire, in ISO 8601 format. This parameter is omitted if the payment can no
    longer expire.
    """
    expired_at: NotRequired[Nullable[str]]
    r"""The date and time the payment was expired, in ISO 8601 format. This parameter is omitted if the payment did not
    expire (yet).
    """
    failed_at: NotRequired[Nullable[str]]
    r"""The date and time the payment failed, in ISO 8601 format. This parameter is omitted if the payment did not fail
    (yet).
    """
    links: NotRequired[PaymentResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class PaymentResponse(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a payment object. Will always contain the string `payment` for this endpoint."""

    id: Optional[str] = None

    mode: Annotated[Optional[Mode], PlainValidator(validate_open_enum(False))] = None
    r"""Whether this entity was created in live mode or in test mode."""

    description: Optional[str] = None
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_refunded: Annotated[
        Optional[Amount], pydantic.Field(alias="amountRefunded")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_remaining: Annotated[
        Optional[Amount], pydantic.Field(alias="amountRemaining")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_captured: Annotated[
        Optional[Amount], pydantic.Field(alias="amountCaptured")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_charged_back: Annotated[
        Optional[Amount], pydantic.Field(alias="amountChargedBack")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    settlement_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="settlementAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    lines: OptionalNullable[List[PaymentResponseLine]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="billingAddress")
    ] = None

    shipping_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="shippingAddress")
    ] = None

    locale: Annotated[
        OptionalNullable[LocaleResponse], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""Allows you to preset the language to be used."""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""This optional field contains your customer's ISO 3166-1 alpha-2 country code, detected by us during checkout. This
    field is omitted if the country code was not detected.
    """

    method: Annotated[
        OptionalNullable[MethodResponse], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    capture_mode: Annotated[
        Annotated[
            OptionalNullable[CaptureModeResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="captureMode"),
    ] = UNSET
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """

    capture_delay: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureDelay")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """

    capture_before: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureBefore")
    ] = UNSET
    r"""Indicates the date before which the payment needs to be captured, in ISO 8601 format. From this date onwards we
    can no longer guarantee a successful capture. The parameter is omitted if the payment is not authorized (yet).
    """

    application_fee: Annotated[
        OptionalNullable[PaymentResponseApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = UNSET
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    routing: OptionalNullable[List[EntityPaymentRouteResponse]] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """

    sequence_type: Annotated[
        Annotated[
            Optional[SequenceTypeResponse], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="sequenceType"),
    ] = None

    subscription_id: Annotated[
        Optional[str], pydantic.Field(alias="subscriptionId")
    ] = None

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None

    status: Annotated[
        Optional[PaymentStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The payment's status. Refer to the [documentation regarding statuses](https://docs.mollie.com/docs/status-change#/) for more info about which
    statuses occur at what point.
    """

    status_reason: Annotated[
        OptionalNullable[StatusReason], pydantic.Field(alias="statusReason")
    ] = UNSET
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale
    payments.

    You can find more information about the possible values of this object on
    [this page](status-reasons).**
    """

    is_cancelable: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="isCancelable")
    ] = UNSET
    r"""Whether the payment can be canceled. This parameter is omitted if the payment reaches a final state."""

    details: OptionalNullable[PaymentResponseDetails] = UNSET
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    authorized_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="authorizedAt")
    ] = UNSET
    r"""The date and time the payment became authorized, in ISO 8601 format. This parameter is omitted if the payment is
    not authorized (yet).
    """

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""The date and time the payment became paid, in ISO 8601 format. This parameter is omitted if the payment is not
    completed (yet).
    """

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The date and time the payment was canceled, in ISO 8601 format. This parameter is omitted if the payment is not
    canceled (yet).
    """

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time the payment will expire, in ISO 8601 format. This parameter is omitted if the payment can no
    longer expire.
    """

    expired_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiredAt")] = (
        UNSET
    )
    r"""The date and time the payment was expired, in ISO 8601 format. This parameter is omitted if the payment did not
    expire (yet).
    """

    failed_at: Annotated[OptionalNullable[str], pydantic.Field(alias="failedAt")] = (
        UNSET
    )
    r"""The date and time the payment failed, in ISO 8601 format. This parameter is omitted if the payment did not fail
    (yet).
    """

    links: Annotated[Optional[PaymentResponseLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "amount",
            "amountRefunded",
            "amountRemaining",
            "amountCaptured",
            "amountChargedBack",
            "settlementAmount",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "locale",
            "countryCode",
            "method",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "captureBefore",
            "applicationFee",
            "routing",
            "sequenceType",
            "subscriptionId",
            "mandateId",
            "customerId",
            "profileId",
            "settlementId",
            "orderId",
            "status",
            "statusReason",
            "isCancelable",
            "details",
            "createdAt",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "failedAt",
            "_links",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "locale",
            "countryCode",
            "method",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "captureBefore",
            "applicationFee",
            "routing",
            "statusReason",
            "isCancelable",
            "details",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "failedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
